/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileStore;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class SimpleFSFileStore
implements IFileStore {
    private static final ILogger logger = GlobalLog.getLogger(SimpleFSFileStore.class);
    private File base;

    public SimpleFSFileStore(String string) {
        this.base = new File(string);
        if (!this.base.exists() && !this.base.mkdirs()) {
            throw new RuntimeException("Cannot create directory");
        }
        if (!this.base.isDirectory()) {
            throw new RuntimeException("The specified path is not a directory");
        }
    }

    @Override
    public String getStoreLocation() {
        return this.base.getAbsolutePath();
    }

    private File keyToFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key should not be null");
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.base, string);
        }
        return file;
    }

    @Override
    public boolean has(String string) {
        File file = this.keyToFile(string);
        return file.exists();
    }

    @Override
    public boolean remove(String string) {
        File file = this.keyToFile(string);
        return file.delete();
    }

    @Override
    public byte[] get(String string) {
        byte[] byArray;
        File file = this.keyToFile(string);
        if (!file.exists()) {
            (new Object[1])[0] = file.getAbsolutePath();
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            long l2 = file.length();
            byte[] byArray2 = new byte[(int)l2];
            dataInputStream.readFully(byArray2);
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return null;
            }
        }
        dataInputStream.close();
        return byArray;
    }

    @Override
    public String put(byte[] byArray) {
        return this.put(null, byArray);
    }

    @Override
    public String put(String string, byte[] byArray) {
        String string2;
        if (byArray == null) {
            throw new IllegalArgumentException("Input data cannot be null");
        }
        if (string == null) {
            string = Formatter.byteArrayToHexString(Hash.calculateSHA256(byArray));
        }
        File file = this.keyToFile(string);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        try {
            dataOutputStream.write(byArray);
            string2 = string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return null;
            }
        }
        dataOutputStream.close();
        return string2;
    }

    @Override
    public List<String> list() {
        throw new RuntimeException("Not implemented");
    }
}

