/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseWriter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.io.StreamWrappers;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.zip.CRC32;

public class JDB2Writer
implements IFileDatabaseWriter {
    private static final ILogger logger = GlobalLog.getLogger(JDB2Writer.class);
    private File file;
    private RandomAccessFile fa;
    private Deque<Mark> marks = new ArrayDeque<Mark>();

    public JDB2Writer(File file) throws IOException {
        this(file, false);
    }

    public JDB2Writer(File file, boolean bl) throws IOException {
        if (bl && file.exists()) {
            this.file = file;
            this.fa = new RandomAccessFile(file, "rw");
            long l2 = this.fa.length();
            if (l2 < 32L) {
                throw new IOException("Truncated JDB2 header");
            }
            int n2 = this.readIntLE();
            if (n2 != 843203658) {
                throw new IOException("Missing JDB2 marker");
            }
            this.fa.seek(l2);
        } else {
            if (file.exists()) {
                file.delete();
            }
            IO.createFoldersForFile(file);
            this.file = file;
            this.fa = new RandomAccessFile(file, "rw");
            this.writeIntLE(843203658);
            this.writeIntLE(AbstractContext.app_ver.toInt());
            for (int i = 2; i < 8; ++i) {
                this.writeIntLE(0);
            }
        }
    }

    @Override
    public boolean hasBackingFile() {
        return true;
    }

    @Override
    public File getBackingFile() {
        return this.file;
    }

    @Override
    public OutputStream beginRecord(int n2, int n3) throws IOException {
        if (n2 < 0 || n2 > 0xFFFFFF) {
            throw new IllegalArgumentException("Invalid record type");
        }
        if ((n3 & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("Invalid record flags");
        }
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 2) != 0;
        final boolean bl3 = (n3 & 4) != 0;
        int n4 = n2 | n3 << 24;
        this.writeIntLE(n4);
        this.writeIntLE(0);
        this.writeIntLE(0);
        for (int i = 3; i < 8; ++i) {
            this.writeIntLE(0);
        }
        final Mark mark = new Mark(this.fa.getFilePointer(), bl3);
        this.marks.push(mark);
        OutputStream outputStream = new OutputStream(){
            CRC32 crc;
            {
                this.crc = bl3 ? mark.crc : null;
            }

            @Override
            public void write(int n2) throws IOException {
                JDB2Writer.this.fa.write(n2);
                if (this.crc != null) {
                    this.crc.update(n2);
                }
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                JDB2Writer.this.fa.write(byArray);
                if (this.crc != null) {
                    this.crc.update(byArray);
                }
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                JDB2Writer.this.fa.write(byArray, n2, n3);
                if (this.crc != null) {
                    this.crc.update(byArray, n2, n3);
                }
            }
        };
        outputStream = new BufferedOutputStream(outputStream, JDB2Writer.getFileBufferSize());
        if (bl2) {
            byte[] byArray = JDB2Writer.getRecordEncryptionKey(n4);
            outputStream = StreamWrappers.getEncryptedStream(outputStream, byArray);
        }
        if (bl) {
            outputStream = StreamWrappers.getCompressedStream(outputStream);
        }
        return outputStream;
    }

    static int getFileBufferSize() {
        return 0x100000;
    }

    static byte[] getRecordEncryptionKey(int n2) {
        String string = Strings.ff("rk_%08X", n2);
        return Strings.encodeASCII(string);
    }

    @Override
    public void endRecord(OutputStream outputStream) throws IOException {
        outputStream.flush();
        outputStream.close();
        Mark mark = this.marks.pop();
        long l2 = this.fa.getFilePointer();
        long l3 = mark.ptr;
        int n2 = (int)(l2 - l3);
        (new Object[1])[0] = n2;
        this.fa.seek(l3 - 28L);
        this.writeIntLE(n2);
        if (mark.crc != null) {
            this.writeIntLE((int)mark.crc.getValue());
        }
        this.fa.seek(l2);
    }

    @Override
    public void verify() {
        if (!this.marks.isEmpty()) {
            throw new IllegalStateException("Not all records were closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.fa.close();
        this.fa = null;
    }

    private void writeIntLE(int n2) throws IOException {
        n2 = n2 << 24 | n2 << 8 & 0xFF0000 | n2 >>> 8 & 0xFF00 | n2 >>> 24;
        this.fa.writeInt(n2);
    }

    private int readIntLE() throws IOException {
        int n2 = this.fa.readInt();
        return EndianUtil.swapInt(n2);
    }

    private static class Mark {
        long ptr;
        CRC32 crc;

        Mark(long l2, boolean bl) {
            if (l2 < 0L) {
                throw new IllegalArgumentException();
            }
            this.ptr = l2;
            if (bl) {
                this.crc = new CRC32();
            }
        }
    }
}

