/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.core.dao.IFileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.impl.JDB2Manager;
import com.pnfsoftware.jeb.core.dao.impl.JDB2Writer;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.StreamWrappers;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class JDB2Reader
implements IFileDatabaseReader {
    private static final ILogger logger = GlobalLog.getLogger(JDB2Reader.class);
    private File file;
    private RandomAccessFile fa;
    private int jebVersionInt;
    private List<RecordDescription> records = new ArrayList<RecordDescription>();

    public JDB2Reader(File file) throws IOException {
        this.file = file;
        this.fa = new RandomAccessFile(file, "r");
        if (this.readIntLE() != 843203658) {
            throw new IOException();
        }
        this.jebVersionInt = this.readIntLE();
        this.fa.skipBytes(24);
        try {
            while (this.fa.getFilePointer() + 8L <= this.fa.length()) {
                int n2 = this.readIntLE();
                int n3 = n2 & 0xFFFFFF;
                int n4 = n2 >> 24 & 0xFF;
                int n5 = this.readIntLE();
                Integer n6 = null;
                if (this.jebVersionInt >= 263424) {
                    n6 = this.readIntLE();
                    this.fa.skipBytes(20);
                }
                long l2 = this.fa.getFilePointer();
                if (n6 != null && (n4 & 4) != 0) {
                    Integer n7 = null;
                    CRC32 cRC32 = new CRC32();
                    try {
                        Hash.checksumBlockFileUpdate(cRC32, this.fa, n5);
                        n7 = (int)cRC32.getValue();
                    }
                    catch (Exception exception) {
                        logger.catchingSilent(exception);
                    }
                    this.fa.seek(l2);
                    if (n7 == null || !n7.equals(n6)) {
                        logger.error("JDB2 record '%s' is corrupted! Will attempt project reload anyway...", JDB2Manager.projectTypeToName(n3));
                    }
                }
                this.records.add(new RecordDescription(n3, n4, n6, l2, n5));
                this.fa.skipBytes(n5);
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException);
        }
        this.fa.seek(32L);
    }

    public int getJebVersionInt() {
        return this.jebVersionInt;
    }

    @Override
    public boolean hasBackingFile() {
        return true;
    }

    @Override
    public File getBackingFile() {
        return this.file;
    }

    @Override
    public List<RecordDescription> getRecordDescriptions() {
        return this.records;
    }

    @Override
    public RecordDescription getRecordDescription(int n2) {
        for (RecordDescription recordDescription : this.records) {
            if (recordDescription.getType() != n2) continue;
            return recordDescription;
        }
        return null;
    }

    @Override
    public InputStream getRecord(int n2) throws IOException {
        RecordDescription recordDescription = this.getRecordDescription(n2);
        if (recordDescription == null) {
            throw new IOException(Strings.ff("A record of type %X was not found", n2));
        }
        return this.getRecord(recordDescription);
    }

    @Override
    public InputStream getRecord(RecordDescription recordDescription) throws IOException {
        boolean bl = (recordDescription.flags & 1) != 0;
        boolean bl2 = (recordDescription.flags & 2) != 0;
        int n2 = recordDescription.dataSize;
        this.fa.seek(recordDescription.dataOffset);
        final long l2 = this.fa.getFilePointer() + (long)n2;
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                if (JDB2Reader.this.fa.getFilePointer() >= l2) {
                    return -1;
                }
                return JDB2Reader.this.fa.read();
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                if (n3 == 0) {
                    return 0;
                }
                int n4 = (int)(l2 - JDB2Reader.this.fa.getFilePointer());
                if (n4 <= 0) {
                    return -1;
                }
                if (n4 < n3) {
                    n3 = n4;
                }
                return JDB2Reader.this.fa.read(byArray, n2, n3);
            }

            @Override
            public int available() throws IOException {
                return (int)(l2 - JDB2Reader.this.fa.getFilePointer());
            }
        };
        inputStream = new BufferedInputStream(inputStream, JDB2Writer.getFileBufferSize());
        if (bl2) {
            int n3 = recordDescription.type & 0xFFFFFF | (recordDescription.flags & 0xFF) << 24;
            byte[] byArray = JDB2Writer.getRecordEncryptionKey(n3);
            inputStream = StreamWrappers.getDecryptedStream(inputStream, byArray);
        }
        if (bl) {
            inputStream = StreamWrappers.getUncompressedStream(inputStream);
        }
        return inputStream;
    }

    @Override
    public void close() throws IOException {
        this.fa.close();
        this.fa = null;
    }

    private int readIntLE() throws IOException {
        int n2 = this.fa.readInt();
        n2 = n2 << 24 | n2 << 8 & 0xFF0000 | n2 >>> 8 & 0xFF00 | n2 >>> 24;
        return n2;
    }

    public static class RecordDescription {
        int type;
        int flags;
        Integer crcValue;
        long dataOffset;
        int dataSize;

        public RecordDescription(int n2, int n3, Integer n4, long l2, int n5) {
            this.type = n2;
            this.flags = n3;
            this.crcValue = n4;
            this.dataOffset = l2;
            this.dataSize = n5;
        }

        public int getType() {
            return this.type;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getCrcValue() {
            return this.crcValue;
        }

        public long getOffsetToData() {
            return this.dataOffset;
        }

        public int getSizeOfData() {
            return this.dataSize;
        }
    }
}

