/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core.dao.impl;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.core.dao.IFileDatabase;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseReader;
import com.pnfsoftware.jeb.core.dao.IFileDatabaseWriter;
import com.pnfsoftware.jeb.core.dao.impl.JDB2Reader;
import com.pnfsoftware.jeb.core.dao.impl.JDB2Writer;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.io.LEDataOutputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JDB2Manager
implements IFileDatabase {
    private static final ILogger logger = GlobalLog.getLogger(JDB2Manager.class);
    public static final String EXTENSION = ".jdb2";
    public static final int MARKER = 843203658;
    public static final int TYPE_PROJECT = 4870736;
    public static final int TYPE_QSTATES = 4932433;
    public static final int TYPE_ARTIFACTS = 5526081;
    public static final int TYPE_PROJECT_CONFIGURATION = 4411472;
    public static final int TYPE_PROJECT_METADATA = 5066832;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_COMPRESS = 1;
    public static final int FLAG_ENCRYPT = 2;
    public static final int FLAG_CRCCHECK = 4;
    static final int FLAGS_MASK = -8;
    private File base;

    public JDB2Manager(String string) {
        this.base = new File(string);
        if (!this.base.exists() && !this.base.mkdirs()) {
            throw new RuntimeException("Cannot create directory");
        }
        if (!this.base.isDirectory()) {
            throw new RuntimeException("The specified path is not a directory");
        }
    }

    private String buildStoreKey(String string, int n2) {
        return Strings.ff("%s", string);
    }

    private File keyToFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key should not be null");
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.base, string);
        }
        return file;
    }

    @Override
    public boolean saveFile(String string, byte[] byArray) {
        int n2;
        File file = this.keyToFile(string);
        LEDataOutputStream lEDataOutputStream = new LEDataOutputStream(new DataOutputStream(new FileOutputStream(file)));
        try {
            lEDataOutputStream.writeInt(843203658);
            lEDataOutputStream.writeInt(AbstractContext.app_ver.toInt());
            for (n2 = 2; n2 < 8; n2 += 1) {
                lEDataOutputStream.writeInt(0);
            }
            lEDataOutputStream.writeInt(4870736);
            lEDataOutputStream.writeInt(byArray.length);
            lEDataOutputStream.write(byArray);
            n2 = 1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    lEDataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catching(iOException);
                return false;
            }
        }
        lEDataOutputStream.close();
        return n2 != 0;
    }

    @Override
    public byte[] loadFile(String string) {
        byte[] byArray;
        File file = this.keyToFile(string);
        if (!file.exists()) {
            return null;
        }
        LEDataInputStream lEDataInputStream = new LEDataInputStream(new DataInputStream(new FileInputStream(file)));
        try {
            if (lEDataInputStream.readInt() != 843203658) {
                throw new IOException("Illegal JDB2 marker");
            }
            lEDataInputStream.skipBytes(4);
            lEDataInputStream.skipBytes(24);
            if (lEDataInputStream.readInt() != 4870736) {
                throw new IOException("Illegal JDB2 block: a project entry was expected");
            }
            int n2 = lEDataInputStream.readInt();
            byte[] byArray2 = new byte[n2];
            int n3 = lEDataInputStream.read(byArray2, 0, n2);
            if (n3 != n2) {
                throw new IOException(Strings.ff("Illegal JDB2 block size: %d bytes were expected, got %d", n2, n3));
            }
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    lEDataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.catching(exception);
                return null;
            }
        }
        lEDataInputStream.close();
        return byArray;
    }

    @Override
    public boolean hasFile(String string) {
        File file = this.keyToFile(string);
        return file.exists();
    }

    @Override
    public File getFileObject(String string) {
        return this.keyToFile(string);
    }

    @Override
    public boolean deleteFile(String string) {
        File file = this.keyToFile(string);
        return file.delete();
    }

    @Override
    public InputStream getFileReader(String string) throws FileNotFoundException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new FileInputStream(file);
    }

    @Override
    public OutputStream getFileWriter(String string) throws FileNotFoundException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new FileOutputStream(file);
    }

    @Override
    public IFileDatabaseWriter getDatabaseWriter(String string) throws IOException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new JDB2Writer(file);
    }

    @Override
    public IFileDatabaseReader getDatabaseReader(String string) throws IOException {
        String string2 = this.buildStoreKey(string, 0);
        File file = this.keyToFile(string2);
        return new JDB2Reader(file);
    }

    public static String projectTypeToName(int n2) {
        switch (n2) {
            case 4870736: {
                return "PROJECT";
            }
            case 4932433: {
                return "QSTATES";
            }
            case 5526081: {
                return "ARTIFACTS";
            }
            case 4411472: {
                return "PROJECT_CONFIGURATION";
            }
            case 5066832: {
                return "PROJECT_METADATA";
            }
        }
        return Strings.ff("0x%X", n2);
    }
}

