/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerStaticOk;
import java.io.File;
import java.io.IOException;

@Ser
public class Version
implements Comparable<Version> {
    public static final int RELEASE = 0;
    public static final int BETA = 1;
    public static final int ALPHA = 2;
    public static final int CHANNEL_STABLE = 0;
    public static final int CHANNEL_MOST_UNSTABLE = 2;
    @SerStaticOk
    private static final String[] channelNames = new String[]{"RELEASE", "BETA", "ALPHA"};
    @SerStaticOk
    private static final String[] channelInfoStrings = new String[]{"Stable build.", "Unstable build, may contain glitches.", "Early unstable build, contains glitches and may crash."};
    @SerId(value=1)
    private int major;
    @SerId(value=2)
    private int minor;
    @SerId(value=3)
    private int buildid;
    @SerId(value=4)
    private long timestamp;
    @SerId(value=5)
    private int channel;

    public static String getChannelName(int n2) {
        if (n2 < 0) {
            return "UNKNOWN";
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return channelNames[n2];
            }
        }
        return "UNSTABLE" + n2;
    }

    public static String getChannelInfo(int n2) {
        if (n2 < 0) {
            return "UNKNOWN";
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return channelInfoStrings[n2];
            }
        }
        return "Illegal build channel, certainly unstable.";
    }

    public static String[] getChannelNames() {
        return channelNames;
    }

    public Version(Version version) {
        this(version.major, version.minor, version.buildid, version.timestamp, version.channel);
    }

    public Version(int n2, int n3) {
        this(n2, n3, 0, 0L);
    }

    public Version(int n2, int n3, int n4) {
        this(n2, n3, n4, 0L);
    }

    public Version(int n2, int n3, int n4, long l2) {
        this(n2, n3, n4, l2, 0);
    }

    public Version(int n2, int n3, int n4, long l2, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || l2 < 0L || n5 < 0 || n5 > 2) {
            throw new RuntimeException("Invalid version");
        }
        this.major = n2;
        this.minor = n3;
        this.buildid = n4;
        this.timestamp = l2;
        this.channel = n5;
    }

    public static Version create(int n2, int n3) {
        return new Version(n2, n3, 0, 0L, 0);
    }

    public static Version create(int n2, int n3, int n4) {
        return new Version(n2, n3, n4, 0L, 0);
    }

    public static Version create(int n2, int n3, int n4, long l2) {
        return new Version(n2, n3, n4, l2);
    }

    public static Version create(int n2, int n3, int n4, long l2, int n5) {
        return new Version(n2, n3, n4, l2, n5);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuildid() {
        return this.buildid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getChannelString() {
        switch (this.channel) {
            case 0: {
                return null;
            }
            case 1: {
                return "beta";
            }
            case 2: {
                return "alpha";
            }
        }
        throw new RuntimeException("Invalid channel id");
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.buildid;
        n2 = 31 * n2 + this.major;
        n2 = 31 * n2 + this.minor;
        n2 = 31 * n2 + Long.valueOf(this.timestamp).hashCode();
        n2 = 31 * n2 + this.channel;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.buildid == version.buildid && this.timestamp == version.timestamp && this.channel == version.channel;
    }

    @Override
    public int compareTo(Version version) {
        if (this.major > version.major) {
            return 1;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid > version.buildid) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid == version.buildid && this.timestamp > version.timestamp) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid == version.buildid && this.timestamp == version.timestamp) {
            return -Integer.compare(this.channel, version.channel);
        }
        return -1;
    }

    public int compareToIgnoreTimestamp(Version version) {
        if (this.major > version.major) {
            return 1;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid > version.buildid) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid == version.buildid) {
            return -Integer.compare(this.channel, version.channel);
        }
        return -1;
    }

    public int compareToIgnoreChannel(Version version) {
        if (this.major > version.major) {
            return 1;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid > version.buildid) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor && this.buildid == version.buildid) {
            return Long.compare(this.timestamp, version.timestamp);
        }
        return -1;
    }

    public int compareToIgnoreTimestampAndChannel(Version version) {
        if (this.major > version.major) {
            return 1;
        }
        if (this.major == version.major && this.minor > version.minor) {
            return 1;
        }
        if (this.major == version.major && this.minor == version.minor) {
            return Integer.compare(this.buildid, version.buildid);
        }
        return -1;
    }

    public boolean like(int n2) {
        return this.major == n2;
    }

    public boolean like(int n2, int n3) {
        return this.major == n2 && this.minor == n3;
    }

    public boolean like(int n2, int n3, int n4) {
        return this.major == n2 && this.minor == n3 && this.buildid == n4;
    }

    public String format(boolean bl) {
        if (this.channel != 0) {
            if (bl) {
                String string = this.getChannelString();
                if (this.timestamp == 0L) {
                    return Strings.ff("%d.%d-%s.%d", this.major, this.minor, string, this.buildid);
                }
                return Strings.ff("%d.%d-%s.%d.%d", this.major, this.minor, string, this.buildid, this.timestamp);
            }
            return Strings.ff("%d.%d.%d.%d.%d", this.major, this.minor, this.buildid, this.timestamp, this.channel);
        }
        if (this.timestamp == 0L) {
            return Strings.ff("%d.%d.%d", this.major, this.minor, this.buildid);
        }
        return Strings.ff("%d.%d.%d.%d", this.major, this.minor, this.buildid, this.timestamp);
    }

    public String formatCompact() {
        if (this.channel != 0) {
            return Strings.ff("%d.%d.%d.%d.%d", this.major, this.minor, this.buildid, this.timestamp, this.channel);
        }
        if (this.timestamp != 0L) {
            return Strings.ff("%d.%d.%d.%d", this.major, this.minor, this.buildid, this.timestamp);
        }
        if (this.buildid != 0) {
            return Strings.ff("%d.%d.%d", this.major, this.minor, this.buildid);
        }
        return Strings.ff("%d.%d", this.major, this.minor);
    }

    public String toString() {
        return this.format(true);
    }

    public static Version parseFromString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.trim().split("\\.", -1);
        if (stringArray.length > 5) {
            return null;
        }
        boolean bl = stringArray.length != 5;
        try {
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = 0;
            int n4 = 0;
            if (bl) {
                if (stringArray.length >= 2) {
                    String string2 = stringArray[1];
                    int n5 = string2.indexOf(45);
                    if (n5 < 0) {
                        n3 = Integer.parseInt(string2);
                        n4 = 0;
                    } else {
                        String string3;
                        n3 = Integer.parseInt(string2.substring(0, n5));
                        switch (string3 = string2.substring(n5 + 1)) {
                            case "beta": {
                                n4 = 1;
                                break;
                            }
                            case "alpha": {
                                n4 = 2;
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                }
            } else {
                n3 = Integer.parseInt(stringArray[1]);
                n4 = Integer.parseInt(stringArray[4]);
            }
            int n6 = 0;
            if (stringArray.length >= 3) {
                n6 = Integer.parseInt(stringArray[2]);
            }
            long l2 = 0L;
            try {
                if (stringArray.length >= 4) {
                    l2 = Long.parseLong(stringArray[3]);
                }
            }
            catch (Exception exception) {}
            return new Version(n2, n3, n6, l2, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Version parseFromFile(File file) {
        try {
            String string = new String(IO.readFile(file), "UTF-8");
            return Version.parseFromString(string.trim());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int toInt() {
        int n2 = Math.min(this.major, 255);
        int n3 = Math.min(this.minor, 255);
        int n4 = Math.min(this.buildid, 255);
        return n2 * 65536 + n3 * 256 + n4;
    }

    public static Version fromInt(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        return new Version(n3, n4, n5);
    }
}

