/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.ScriptMetadata;
import com.pnfsoftware.jeb.core.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ScriptMetadataParser {
    public static ScriptMetadata extract(File file) throws IOException {
        return ScriptMetadataParser.extract(file, null);
    }

    public static ScriptMetadata extract(File file, String string) throws IOException {
        if (string == null) {
            string = file.getName().endsWith(".py") ? "#" : "//";
        }
        String string2 = string + "?";
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));){
            String string3;
            ScriptMetadata scriptMetadata = new ScriptMetadata();
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() == 0) continue;
                if (!string3.startsWith(string)) break;
                if (!string3.startsWith(string2)) continue;
                ScriptMetadataParser.processEntry(file, string3.substring(string2.length()).trim(), scriptMetadata);
            }
            ScriptMetadata scriptMetadata2 = scriptMetadata;
            return scriptMetadata2;
        }
    }

    private static boolean processEntry(File file, String string, ScriptMetadata scriptMetadata) {
        String string2 = "type=";
        if (string.startsWith(string2)) {
            String string3 = string.substring(string2.length()).trim();
            if (!string3.isEmpty()) {
                scriptMetadata.type = string3;
            }
            return true;
        }
        string2 = "description=";
        if (string.startsWith(string2)) {
            String string4 = string.substring(string2.length()).trim();
            if (!string4.isEmpty()) {
                scriptMetadata.description = string4;
            }
            return true;
        }
        string2 = "author=";
        if (string.startsWith(string2)) {
            String string5 = string.substring(string2.length()).trim();
            if (!string5.isEmpty()) {
                scriptMetadata.author = string5;
            }
            return true;
        }
        string2 = "version=";
        if (string.startsWith(string2)) {
            String string6 = string.substring(string2.length()).trim();
            if (!string6.isEmpty()) {
                Version version = Version.parseFromString(string6);
                if (version == null) {
                    return false;
                }
                scriptMetadata.version = version;
            }
            return true;
        }
        string2 = "shortcut=";
        if (string.startsWith(string2)) {
            String string7 = string.substring(string2.length()).trim();
            if (!string7.isEmpty()) {
                scriptMetadata.shortcut = string7;
            }
            return true;
        }
        if (string.startsWith("deprecated=") || string.equals("deprecated")) {
            scriptMetadata.deprecated = true;
            return true;
        }
        if (string.startsWith("nolist=") || string.equals("nolist")) {
            scriptMetadata.nolist = true;
            return true;
        }
        return false;
    }
}

