/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.IUnitContribution;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.IUnitFilter;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.qp;
import java.util.ArrayList;
import java.util.List;

public class RuntimeProjectUtil {
    private static final ILogger logger = GlobalLog.getLogger(RuntimeProjectUtil.class);

    public static IRuntimeProject findProject(IUnitCreator iUnitCreator) {
        IUnitCreator iUnitCreator2 = iUnitCreator;
        while (iUnitCreator2 instanceof IUnit) {
            iUnitCreator2 = ((IUnit)iUnitCreator2).getParent();
        }
        if (iUnitCreator2 == null) {
            logger.error("No parent artifact found for unit. Is the project being deserialized?", new Object[0]);
            return null;
        }
        IArtifact iArtifact = (IArtifact)iUnitCreator2;
        try {
            for (IEnginesContext iEnginesContext : JebCoreService.getInstance().listEnginesContexts()) {
                for (IRuntimeProject iRuntimeProject : iEnginesContext.getProjects()) {
                    for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                        if (iLiveArtifact.getArtifact() != iArtifact) continue;
                        return iRuntimeProject;
                    }
                }
            }
        }
        catch (JebException jebException) {}
        return null;
    }

    public static List<IUnit> getAllUnits(IRuntimeProject iRuntimeProject) {
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
            for (IUnit iUnit : iLiveArtifact.getUnits()) {
                RuntimeProjectUtil.getAllUnitsRecurse(arrayList, iUnit);
            }
        }
        return arrayList;
    }

    private static void getAllUnitsRecurse(List<IUnit> list, IUnit iUnit) {
        if (iUnit == null) {
            return;
        }
        list.add(iUnit);
        for (IUnit iUnit2 : iUnit.getChildren()) {
            RuntimeProjectUtil.getAllUnitsRecurse(list, iUnit2);
        }
    }

    public static <T extends IUnit> T findFirstUnitByType(IRuntimeProject iRuntimeProject, Class<T> clazz, boolean bl) {
        if (iRuntimeProject != null) {
            for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                for (IUnit iUnit : iLiveArtifact.getUnits()) {
                    T t = RuntimeProjectUtil.findFirstUnitByTypeRecurse(iUnit, clazz, bl);
                    if (t == null) continue;
                    return t;
                }
            }
        }
        return null;
    }

    private static <T extends IUnit> T findFirstUnitByTypeRecurse(IUnit iUnit, Class<T> clazz, boolean bl) {
        if (iUnit != null) {
            if (clazz == null || clazz == iUnit.getClass() || !bl && clazz.isInstance(iUnit)) {
                return (T)iUnit;
            }
            for (IUnit iUnit2 : iUnit.getChildren()) {
                T t = RuntimeProjectUtil.findFirstUnitByTypeRecurse(iUnit2, clazz, bl);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static <T extends IUnit> List<T> findUnits(IRuntimeProject iRuntimeProject, Class<T> clazz) {
        return RuntimeProjectUtil.findUnitsByType(iRuntimeProject, clazz, false);
    }

    public static <T extends IUnit> List<T> findUnitsByType(IRuntimeProject iRuntimeProject, Class<T> clazz, boolean bl) {
        ArrayList arrayList = new ArrayList();
        if (iRuntimeProject != null) {
            for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                for (IUnit iUnit : iLiveArtifact.getUnits()) {
                    RuntimeProjectUtil.findUnitsByTypeRecurse(iUnit, clazz, bl, arrayList);
                }
            }
        }
        return arrayList;
    }

    private static <T extends IUnit> void findUnitsByTypeRecurse(IUnit iUnit, Class<T> clazz, boolean bl, List<T> list) {
        if (iUnit != null) {
            if (clazz == null || clazz == iUnit.getClass() || !bl && clazz.isInstance(iUnit)) {
                list.add(iUnit);
            }
            for (IUnit iUnit2 : iUnit.getChildren()) {
                RuntimeProjectUtil.findUnitsByTypeRecurse(iUnit2, clazz, bl, list);
            }
        }
    }

    public static IUnit findUnitByUid(IRuntimeProject iRuntimeProject, final long l2) {
        return Lists.getFirst(RuntimeProjectUtil.filterUnits(iRuntimeProject, new IUnitFilter(){

            @Override
            public int check2(IUnit iUnit) {
                return iUnit.getUid() == l2 ? 3 : 0;
            }
        }));
    }

    public static List<IUnit> filterUnits(IRuntimeProject iRuntimeProject, IUnitFilter iUnitFilter) {
        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
        for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
            for (IUnit iUnit : iLiveArtifact.getUnits()) {
                RuntimeProjectUtil.filterUnitsRecurse(iUnit, iUnitFilter, arrayList);
            }
        }
        return arrayList;
    }

    private static boolean filterUnitsRecurse(IUnit iUnit, IUnitFilter iUnitFilter, List<IUnit> list) {
        if (iUnit != null) {
            if (iUnitFilter == null) {
                list.add(iUnit);
            } else {
                int n2 = iUnitFilter.check2(iUnit);
                if ((n2 & 1) != 0) {
                    list.add(iUnit);
                }
                if ((n2 & 2) != 0) {
                    return false;
                }
            }
            for (IUnit iUnit2 : iUnit.getChildren()) {
                if (RuntimeProjectUtil.filterUnitsRecurse(iUnit2, iUnitFilter, list)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<IUnitContribution> findUnitContributions(IRuntimeProject iRuntimeProject, IUnit iUnit) {
        class Filter
        implements IUnitFilter {
            private List<IUnitContribution> contributions = new ArrayList<IUnitContribution>();
            final /* synthetic */ IUnit val$target;

            Filter(IUnit iUnit) {
                this.val$target = iUnit;
            }

            @Override
            public boolean check(IUnit iUnit) {
                try {
                    if (!iUnit.isProcessed()) {
                        return false;
                    }
                    for (IUnitContribution iUnitContribution : iUnit.getContributions()) {
                        if (this.contributions.contains(iUnitContribution) || !iUnitContribution.isTarget(this.val$target)) continue;
                        this.contributions.add(iUnitContribution);
                    }
                }
                catch (Exception exception) {
                    logger.catching(exception);
                    return false;
                }
                return true;
            }

            public List<IUnitContribution> getContributions() {
                return this.contributions;
            }
        }
        Filter filter = new Filter(iUnit);
        RuntimeProjectUtil.filterUnits(iRuntimeProject, filter);
        return filter.getContributions();
    }

    public static boolean destroyLiveArtifact(ILiveArtifact iLiveArtifact) {
        if (iLiveArtifact.getRuntimeProject() instanceof qp) {
            qp qp2 = (qp)iLiveArtifact.getRuntimeProject();
            return qp2.ce(iLiveArtifact);
        }
        return false;
    }

    public static boolean hasNotification(IRuntimeProject iRuntimeProject) {
        return RuntimeProjectUtil.hasNotification(iRuntimeProject, 0);
    }

    public static boolean hasNotification(IRuntimeProject iRuntimeProject, int n2) {
        for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
            for (IUnit iUnit : iLiveArtifact.getUnits()) {
                if (!RuntimeProjectUtil.hasNotificationRecurse(iUnit, n2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasNotificationRecurse(IUnit iUnit, int n2) {
        try {
            for (IUnitNotification object : iUnit.getNotificationManager().getNotifications()) {
                if (object.getType().getLevel() < n2) continue;
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.catching(runtimeException);
        }
        for (IUnit iUnit2 : iUnit.getChildren()) {
            if (!RuntimeProjectUtil.hasNotificationRecurse(iUnit2, n2)) continue;
            return true;
        }
        return false;
    }
}

