/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.client.ErrorLogGenerator;
import com.pnfsoftware.jeb.core.CoreOptions;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.events.ExceptionNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.TelemetryNotification;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.zo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JebCoreService {
    private static final ILogger logger = GlobalLog.getLogger(JebCoreService.class);

    public static ICoreContext getExistingInstance() {
        return zo.mm();
    }

    public static ICoreContext getInstance() throws JebException {
        return zo.ce();
    }

    public static ICoreContext getInstance(String string) throws JebException {
        return zo.ce(string, null);
    }

    public static ICoreContext getInstance(String string, CoreOptions coreOptions) throws JebException {
        return zo.ce(string, coreOptions);
    }

    public static IEnginesContext getDefaultEnginesContext() {
        return JebCoreService.getExistingInstance().getDefaultEnginesContexts();
    }

    public static void notifyExceptionToClient(Throwable throwable, int n2, Map<String, Object> map, IUnit iUnit) {
        if (throwable == null) {
            return;
        }
        try {
            ICoreContext iCoreContext = JebCoreService.getInstance();
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("urlencoded-threads", ErrorLogGenerator.generateUrlencodedThreadsRecordValue());
            if (iUnit != null) {
                String string = UnitUtil.buildFullyQualifiedUnitPath(iUnit);
                map.put("unit-path", string);
            }
            iCoreContext.notifyListeners(new JebEvent(J.Notification, new ExceptionNotification(throwable, null, n2, map)));
        }
        catch (JebException jebException) {}
    }

    public static void notifyExceptionToClient(Throwable throwable) {
        JebCoreService.notifyExceptionToClient(throwable, 0, null, null);
    }

    public static void notifySilentExceptionToClient(Throwable throwable) {
        JebCoreService.notifyExceptionToClient(throwable, 1, null, null);
    }

    public static void notifySilentExceptionToClient(Throwable throwable, IUnit iUnit) {
        JebCoreService.notifyExceptionToClient(throwable, 1, null, iUnit);
    }

    public static void notifySilentExceptionToClient(Throwable throwable, Map<String, Object> map) {
        JebCoreService.notifyExceptionToClient(throwable, 1, map, null);
    }

    public static void silentExcept(Throwable throwable) {
        JebCoreService.notifySilentExceptionToClient(throwable);
    }

    public static void notifyTelemetryToClient(String string, Map<String, String> map) {
        if (string == null) {
            return;
        }
        try {
            if (map == null) {
                map = Collections.emptyMap();
            }
            JebCoreService.getInstance().notifyListeners(new JebEvent(J.Notification, new TelemetryNotification(string, map)));
        }
        catch (JebException jebException) {}
    }

    public static void notifyTelemetryToClient(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }

    public static void notifyTelemetryToClient(String string, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }

    public static void notifyTelemetryToClient(String string, String string2, String string3, String string4, String string5) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        hashMap.put(string4, string5);
        JebCoreService.notifyTelemetryToClient(string, hashMap);
    }
}

