/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.impl.AbstractCommentManager;
import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Ser
public class BookmarkManager
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(BookmarkManager.class);
    @SerId(value=1)
    private WeakIdentityHashMap<IUnit, Collection<Bookmark>> map = new WeakIdentityHashMap();
    @SerTransient
    private volatile boolean cleanedUp;

    @Override
    public void onEvent(IEvent iEvent) {
        if (iEvent instanceof JebEvent && iEvent.getType() == J.UnitDestroyed && iEvent.getData() instanceof IUnit) {
            IUnit iUnit = (IUnit)iEvent.getData();
            (new Object[1])[0] = iUnit;
            this.remove(iUnit);
        }
    }

    public void set(IUnit iUnit, String string, String string2) {
        this.set(iUnit, string, string2, false);
    }

    public void set(IUnit iUnit, String string, String string2, boolean bl) {
        Collection<Object> collection;
        this.cleanupDanglingRefs();
        if (iUnit == null) {
            throw new IllegalArgumentException();
        }
        if (iUnit instanceof IAddressableUnit) {
            string = ((IAddressableUnit)iUnit).getCanonicalAddress(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = false;
        Object object = this.map;
        synchronized (object) {
            collection = this.map.get(iUnit);
            if (collection == null) {
                collection = new ArrayList<Bookmark>();
                this.map.put(iUnit, collection);
            }
            for (Object object2 : collection) {
                if (!Strings.equals(string, ((Bookmark)object2).address)) continue;
                ((Bookmark)object2).description = string2;
                bl2 = true;
            }
            if (!bl2) {
                Iterator<Object> iterator = new Bookmark(iUnit, string, string2);
                collection.add((Bookmark)((Object)iterator));
            }
        }
        if (!bl && string != null && iUnit instanceof IInteractiveUnit && !((IInteractiveUnit)iUnit).isDisposed() && ((IInteractiveUnit)iUnit).getCommentManager() != null) {
            object = ((IInteractiveUnit)iUnit).getCommentManager();
            if (bl2) {
                collection = ((AbstractCommentManager)object).getMetaComments(string, 4096, 0);
                for (Object object2 : collection) {
                    ((AbstractCommentManager)object).removeMetaComment(string, (MetaComment)object2, false);
                }
            }
            ((AbstractCommentManager)object).addMetaComment(string, new MetaComment(string2, 4096), true);
        }
    }

    public String get(IUnit iUnit, String string) {
        Collection<Bookmark> collection;
        this.cleanupDanglingRefs();
        if (iUnit == null) {
            throw new IllegalArgumentException();
        }
        if (iUnit instanceof IAddressableUnit) {
            string = ((IAddressableUnit)iUnit).getCanonicalAddress(string);
        }
        WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
        synchronized (weakIdentityHashMap) {
            collection = this.map.get(iUnit);
        }
        if (collection == null) {
            return null;
        }
        for (Bookmark bookmark : collection) {
            if (!Strings.equals(string, bookmark.address)) continue;
            return bookmark.description;
        }
        return null;
    }

    public Collection<Bookmark> get(IUnit iUnit) {
        Collection<Bookmark> collection;
        this.cleanupDanglingRefs();
        if (iUnit == null) {
            throw new IllegalArgumentException();
        }
        WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
        synchronized (weakIdentityHashMap) {
            collection = this.map.get(iUnit);
        }
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    public List<Bookmark> getAll() {
        this.cleanupDanglingRefs();
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
        synchronized (weakIdentityHashMap) {
            for (Collection<Bookmark> collection : this.map.values()) {
                arrayList.addAll(collection);
            }
        }
        return arrayList;
    }

    public boolean remove(IUnit iUnit, String string) {
        String string2;
        this.cleanupDanglingRefs();
        if (iUnit == null) {
            throw new IllegalArgumentException();
        }
        if (iUnit instanceof IAddressableUnit) {
            string = ((IAddressableUnit)iUnit).getCanonicalAddress(string);
        }
        WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
        synchronized (weakIdentityHashMap) {
            Collection<Bookmark> collection = this.map.get(iUnit);
            if (collection == null) {
                return false;
            }
            Bookmark bookmark = null;
            for (Bookmark bookmark2 : collection) {
                if (!Strings.equals(string, bookmark2.address)) continue;
                bookmark = bookmark2;
                break;
            }
            if (bookmark == null) {
                return false;
            }
            string2 = bookmark.description;
            collection.remove(bookmark);
            if (collection.isEmpty()) {
                this.map.remove(iUnit);
            }
        }
        if (string != null && iUnit instanceof IInteractiveUnit && ((IInteractiveUnit)iUnit).getCommentManager() != null) {
            ((IInteractiveUnit)iUnit).getCommentManager().removeMetaComment(string, new MetaComment(string2, 4096), true);
        }
        return true;
    }

    public boolean remove(IUnit iUnit) {
        this.cleanupDanglingRefs();
        if (iUnit == null) {
            throw new IllegalArgumentException();
        }
        WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
        synchronized (weakIdentityHashMap) {
            Collection<Bookmark> collection = this.map.get(iUnit);
            if (collection == null) {
                return false;
            }
            for (Bookmark bookmark : new ArrayList<Bookmark>(collection)) {
                this.remove(iUnit, bookmark.address);
            }
        }
        this.map.remove(iUnit);
        return true;
    }

    private void cleanupDanglingRefs() {
        if (!this.cleanedUp) {
            WeakIdentityHashMap<IUnit, Collection<Bookmark>> weakIdentityHashMap = this.map;
            synchronized (weakIdentityHashMap) {
                if (!this.cleanedUp) {
                    this.cleanedUp = true;
                    try {
                        ArrayList<IUnit> arrayList = new ArrayList<IUnit>();
                        for (IUnit iUnit : this.map.keySet()) {
                            if (!iUnit.isDisposed() && iUnit.getPropertyManager() != null) continue;
                            arrayList.add(iUnit);
                        }
                        for (IUnit iUnit : arrayList) {
                            this.remove(iUnit);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Ser
    public static class Bookmark {
        @SerId(value=1)
        private IUnit unit;
        @SerId(value=2)
        private String address;
        @SerId(value=3)
        private String description;

        public Bookmark(IUnit iUnit, String string, String string2) {
            if (iUnit == null) {
                throw new IllegalArgumentException("Null unit");
            }
            this.unit = iUnit;
            this.address = string;
            this.description = string2;
        }

        public IUnit getUnit() {
            return this.unit;
        }

        public String getAddress() {
            return this.address;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return Strings.ff("%s:%s:%s", this.unit.getName(), this.address, this.description);
        }
    }
}

