/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;

public class AssetManager {
    private static final ILogger logger = GlobalLog.getLogger(AssetManager.class);

    public static InputStream getAsset(String string) throws IOException {
        InputStream inputStream = AssetManager.class.getResourceAsStream("assets/" + string);
        if (inputStream == null) {
            throw new IOException(Strings.ff("Asset \"%s\" does not exist", string));
        }
        return inputStream;
    }

    public static boolean isAsset(String string) {
        try {
            InputStream inputStream = AssetManager.getAsset(string);
            boolean bl = true;
            if (inputStream != null) {
                inputStream.close();
            }
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] getAssetBytes(String string) {
        byte[] byArray;
        block8: {
            InputStream inputStream = AssetManager.getAsset(string);
            try {
                byArray = IO.readInputStream(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public static int getAssetSize(String string) {
        int n2;
        block8: {
            InputStream inputStream = AssetManager.getAsset(string);
            try {
                n2 = inputStream.available();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                    return -1;
                }
            }
            inputStream.close();
        }
        return n2;
    }
}

