/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.core;

import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.JebEventSource;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class Artifact
extends JebEventSource
implements IArtifact {
    private static final ILogger logger = GlobalLog.getLogger(Artifact.class);
    public static final Artifact EMPTY = new Artifact("emptyArtifact", new BytesInput(new byte[0]));
    @SerId(value=1)
    private long creationTimestamp = System.currentTimeMillis();
    @SerId(value=2)
    private String name;
    @SerId(value=3)
    private IInput input;
    @SerId(value=4)
    private String notes;

    public Artifact(String string, IInput iInput) {
        this.name = string;
        this.input = iInput;
        this.notes = "";
    }

    @Override
    public IUnitCreator getParent() {
        return null;
    }

    @Override
    public IInput getInput() {
        return this.input;
    }

    public void setInput(IInput iInput) {
        this.input = iInput;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (string == null || string.equals(this.name)) {
            return;
        }
        this.name = string;
        this.notifyListeners(new JebEvent(J.ArtifactPropertyChanged));
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String string) {
        if (string == null || string.equals(this.notes)) {
            return;
        }
        this.notes = string;
        this.notifyListeners(new JebEvent(J.ArtifactPropertyChanged));
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String toString() {
        return Strings.ff("Artifact:{%s}", this.getName());
    }
}

