/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.telemetry;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryEndpoint;
import com.pnfsoftware.jeb.client.telemetry.TelemetryException;
import com.pnfsoftware.jeb.client.telemetry.TelemetryRecord;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.csv;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class StandardTelemetryDatabase
implements ITelemetryDatabase {
    private static final ILogger logger = GlobalLog.getLogger(StandardTelemetryDatabase.class);
    private static final String version = AbstractContext.app_ver.toString();
    private static final String jtdMarker = "JTD1";
    private static final String properMarker = csv.ce(new byte[]{16, 62, 60, 16, 6, 12, 71, 14, 27, 82, 69, 2, 93, 0, 2, 57}, 2, 13);
    private static final int defaultDumpPeriodSeconds = 300;
    private static final int defaultPurgeThreshold = 100000;
    private ITelemetryEndpoint endpoint;
    private File dbfile;
    private Connection connection = null;
    private Thread threadDumper;
    private volatile int dumpPeriodSeconds = 300;
    private volatile int purgeThreshold = 100000;
    private int errcnt;

    public StandardTelemetryDatabase(String string, ITelemetryEndpoint iTelemetryEndpoint) throws IOException, TelemetryException {
        this(string, iTelemetryEndpoint, false);
    }

    public StandardTelemetryDatabase(String string, ITelemetryEndpoint iTelemetryEndpoint, boolean bl) throws IOException, TelemetryException {
        Object object;
        AutoCloseable autoCloseable;
        boolean bl2;
        if (iTelemetryEndpoint == null) {
            throw new IllegalArgumentException("Specify an endpoint");
        }
        this.endpoint = iTelemetryEndpoint;
        string = IO.abs(string).replace('\\', '/');
        this.dbfile = new File(string);
        boolean bl3 = bl2 = !this.dbfile.exists() || this.dbfile.length() == 0L;
        if (!bl2) {
            try {
                autoCloseable = new RandomAccessFile(this.dbfile, "rw");
                try {
                    object = new byte[16];
                    ((RandomAccessFile)autoCloseable).seek(0L);
                    ((RandomAccessFile)autoCloseable).readFully((byte[])object);
                    if (Strings.decodeASCII(object).startsWith(jtdMarker)) {
                        if ((long)(16 + EndianUtil.bytesToInt(object, 4, ByteOrder.BIG_ENDIAN)) != this.dbfile.length()) {
                            throw new IOException("Unexpected size");
                        }
                        ((RandomAccessFile)autoCloseable).seek(0L);
                        ((RandomAccessFile)autoCloseable).write(Strings.encodeASCII(properMarker));
                        ((RandomAccessFile)autoCloseable).close();
                    }
                }
                finally {
                    ((RandomAccessFile)autoCloseable).close();
                }
            }
            catch (IOException iOException) {
                throw new TelemetryException(iOException);
            }
        }
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + string);
        }
        catch (SQLException sQLException) {
            throw new TelemetryException(sQLException);
        }
        if (bl2) {
            try {
                autoCloseable = this.connection.createStatement();
                try {
                    object = csv.ce(new byte[]{-126, 17, 23, 4, 21, 17, 101, 116, 21, 3, 14, 9, 101, 69, 19, 19, 11, 26, 7, 83, 8, 92, 29, 4, 8, 22, 7, 21, 12, 29, 80, 73, 7, 26, 88, 12, 86, 19, 23, 1, 26, 6, 1, 78, 84, 17, 29, 12, 88, 12, 69, 19, 19, 11, 26, 26, 15, 12, 8, 69, 84, 17, 29, 12, 88, 12, 80, 2, 29, 31, 21, 23, 6, 29, 12, 22, 83, 84, 17, 29, 12, 93}, 1, 193);
                    autoCloseable.executeUpdate((String)object);
                }
                finally {
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException2) {}
                throw new TelemetryException(sQLException);
            }
        }
        if (bl) {
            this.startDumperThread();
        }
    }

    public void startDumperThread() {
        if (this.threadDumper != null) {
            throw new IllegalStateException();
        }
        this.threadDumper = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                int n2 = 10 + new Random().nextInt(11);
                try {
                    Thread.sleep((long)n2 * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (StandardTelemetryDatabase.this.connection == null) {
                    return;
                }
                try {
                    StandardTelemetryDatabase.this.dump();
                }
                catch (Exception exception) {
                    logger.catchingSilent(exception);
                }
                while (true) {
                    try {
                        Thread.sleep((long)StandardTelemetryDatabase.this.dumpPeriodSeconds * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (StandardTelemetryDatabase.this.connection == null) break;
                    try {
                        StandardTelemetryDatabase.this.dump();
                    }
                    catch (Exception exception) {
                        logger.catchingSilent(exception);
                    }
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                logger.catchingSilent(exception);
            }
        }
    }

    @Override
    public synchronized void close() throws TelemetryException {
        if (this.connection == null) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.errcnt > 0) {
            this.dbfile.delete();
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            throw new TelemetryException(sQLException);
        }
        finally {
            this.connection = null;
        }
        if (this.errcnt == 0) {
            int n2 = (int)this.dbfile.length();
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.dbfile, "rw");){
                byte[] byArray = new byte[16];
                randomAccessFile.seek(0L);
                randomAccessFile.readFully(byArray);
                if (Arrays.equals(byArray, Strings.encodeASCII(properMarker))) {
                    randomAccessFile.seek(0L);
                    randomAccessFile.write(Strings.encodeASCII(jtdMarker));
                    randomAccessFile.writeInt(n2 - 16);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                throw new TelemetryException(iOException);
            }
        }
    }

    public void setDumpPeriod(int n2) {
        if (n2 <= 0) {
            n2 = 300;
        }
        this.dumpPeriodSeconds = n2;
    }

    public int getDumpPeriod() {
        return this.dumpPeriodSeconds;
    }

    public void setPurgeThreshold(int n2) {
        if (n2 <= 0) {
            n2 = 100000;
        }
        this.purgeThreshold = n2;
    }

    public int getPurgeThreshold() {
        return this.purgeThreshold;
    }

    @Override
    public boolean record(String string) {
        return this.record(string, null);
    }

    @Override
    public boolean record(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string2, string3);
        return this.record(string, linkedHashMap);
    }

    @Override
    public boolean record(String string, String string2, String string3, String string4, String string5) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(string2, string3);
        linkedHashMap.put(string4, string5);
        return this.record(string, linkedHashMap);
    }

    @Override
    public synchronized boolean record(String string, Map<String, String> map) {
        boolean bl;
        block10: {
            int n2 = (int)(System.currentTimeMillis() / 1000L);
            Statement statement = this.connection.createStatement();
            try {
                String string2;
                String string3;
                if (map == null || map.isEmpty()) {
                    string3 = csv.ce(new byte[]{10, 33, 35, 60, 32, 61, 71, 33, 58, 116, 103, 67, 76, 86, 84, 87, 77, 64, 4, 84, 91, 93, 87, 71, 88, 65, 34, 2, 77, 67, 26, 0, 82, 18, 7, 11, 65, 67, 82, 69, 31, 17, 29, 84, 15, 7, 11, 12, 69, 73, 55, 53, 41, 38, 107, 115, 105, 73, 8, 12, 82, 78, 66, 27, 83, 95, 0, 85, 64, 0, 66, 91}, 2, 131);
                    string2 = Strings.ff(string3, n2, version, string);
                } else {
                    string3 = Strings.encodeMap(map);
                    String string4 = csv.ce("INSERT INTO events(timestamp, version, eventname, properties) VALUES(%d, '%s', '%s', '%s')");
                    string2 = Strings.ff(string4, n2, version, string, string3);
                }
                statement.executeUpdate(string2);
                bl = true;
                if (statement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    ++this.errcnt;
                    logger.catchingSilent(exception);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized int size() {
        try (Statement statement = this.connection.createStatement();){
            int n2;
            block14: {
                ResultSet resultSet = statement.executeQuery(csv.ce(new byte[]{115, 22, 9, 9, 6, 23, 116, 99, 12, 26, 27, 26, 124, 2, 3, 9, 102, 20, 29, 2, 109, 69, 19, 19, 11, 26, 7}, 1, 32));
                try {
                    resultSet.next();
                    n2 = resultSet.getInt(1);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n2;
        }
        catch (SQLException sQLException) {
            ++this.errcnt;
            logger.catchingSilent(sQLException);
            return -1;
        }
    }

    public synchronized boolean clear() {
        boolean bl;
        block8: {
            Statement statement = this.connection.createStatement();
            try {
                statement.execute(csv.ce(new byte[]{97, 1, 9, 9, 17, 17, 101, 102, 20, 29, 2, 109, 69, 19, 19, 11, 26, 7}, 1, 37));
                bl = true;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    ++this.errcnt;
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dump() {
        if (!this.endpoint.canDump()) {
            return false;
        }
        StandardTelemetryDatabase standardTelemetryDatabase = this;
        synchronized (standardTelemetryDatabase) {
            ArrayList<TelemetryRecord> arrayList;
            try (Statement statement = this.connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(csv.ce(new byte[]{16, 42, 60, 60, 49, 61, 71, 66, 84, 102, 122, 44, 100, 0, 84, 79, 92, 93, 88, 83}, 2, 18));){
                int n2;
                arrayList = new ArrayList<TelemetryRecord>();
                while (resultSet.next()) {
                    (new Object[1])[0] = resultSet.getString("eventname");
                    n2 = resultSet.getInt("timestamp");
                    String string = resultSet.getString("version");
                    String string2 = resultSet.getString("eventname");
                    Map<String, String> map = Strings.decodeMap(resultSet.getString("properties"));
                    arrayList.add(new TelemetryRecord(n2, string, string2, map));
                }
                if (arrayList.isEmpty()) {
                    n2 = 1;
                    return n2 != 0;
                }
                statement.execute(csv.ce(new byte[]{-25, 1, 9, 9, 17, 17, 101, 102, 20, 29, 2, 109, 69, 19, 19, 11, 26, 7}, 1, 163));
            }
            catch (SQLException sQLException) {
                ++this.errcnt;
                logger.catchingSilent(sQLException);
                return false;
            }
            return this.endpoint.dump(arrayList);
        }
    }
}

