/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.api.IScript;
import com.pnfsoftware.jeb.client.script.PythonScriptFactory;
import com.pnfsoftware.jeb.client.script.ScriptException;
import com.pnfsoftware.jeb.client.script.ScriptExecutionException;
import com.pnfsoftware.jeb.client.script.ScriptPreparationException;
import com.pnfsoftware.jeb.client.script.ScriptType;
import com.pnfsoftware.jeb.client.script.ScriptUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import org.python.core.PyException;

public class ScriptLoader {
    private static final ILogger logger = GlobalLog.getLogger(ScriptLoader.class);
    private ScriptType scripttype;
    private IScript script;
    private File libdir;

    public ScriptLoader(String string, String string2) throws ScriptException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        this.libdir = new File(string2);
        if (!this.libdir.exists()) {
            if (!this.libdir.mkdir()) {
                throw new ScriptPreparationException(Strings.ff("Cannot create directory \"%s\"", string2));
            }
        } else if (!this.libdir.isDirectory()) {
            throw new ScriptPreparationException(Strings.ff("Path \"%s\" is not a directory", string2));
        }
        this.load(string);
    }

    public ScriptType getScriptType() {
        return this.scripttype;
    }

    private void load(String string) throws ScriptException {
        String string2;
        String string3;
        File file = new File(string);
        if (!file.exists() && !(file = new File(this.libdir, string)).exists()) {
            throw new ScriptPreparationException(S.s(706));
        }
        String string4 = file.getName();
        if (string4.endsWith(".py")) {
            string3 = string4.substring(0, string4.length() - 3);
            string2 = ScriptUtil.filenameToClassname(string3);
            if (string2 == null) {
                throw new ScriptPreparationException("Illegal script name");
            }
        } else {
            throw new ScriptPreparationException("Unsupported script extension");
        }
        this.loadPython(file, string3, string2);
    }

    private void loadPython(File file, String string, String string2) throws ScriptException {
        try (PythonScriptFactory pythonScriptFactory = null;){
            pythonScriptFactory = new PythonScriptFactory(file.getAbsoluteFile().getParent(), string, string2);
            this.script = pythonScriptFactory.create();
        }
        this.scripttype = ScriptType.PYTHON;
    }

    private void initJython() throws ScriptException {
        String string = null;
        for (String string2 : this.libdir.list()) {
            if (!string2.startsWith("jython") || !string2.toLowerCase().endsWith(".jar")) continue;
            string = new File(this.libdir, string2).getAbsolutePath();
            break;
        }
        if (string == null) {
            throw new ScriptPreparationException("Jython is required to run client scripts, refer to SCRIPTS.TXT for setup instructions");
        }
        logger.debug("Found Jython package: %s", string);
    }

    public void execute(IClientContext iClientContext) throws ScriptException {
        try {
            this.script.run(iClientContext);
        }
        catch (PyException pyException) {
            throw new ScriptExecutionException(pyException);
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
    }
}

