/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.api.IScript;
import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.client.script.ScriptInitializationException;
import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.Writer;
import java.util.Properties;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PythonScriptFactory {
    private static final ILogger logger = GlobalLog.getLogger(PythonScriptFactory.class);
    private static int globalCreationCount;
    private String directory;
    private String filenameNoExt;
    private String classname;
    private PythonInterpreter interpreter;
    private PyObject scriptClass;

    public PythonScriptFactory(String string, String string2, String string3) throws ScriptInitializationException {
        this.directory = string;
        this.filenameNoExt = string2;
        this.classname = string3;
        this.init(null);
    }

    private void init(String string) throws ScriptInitializationException {
        if (globalCreationCount++ == 0) {
            logger.info("Initializing Jython, please wait...", new Object[0]);
        }
        Properties properties = new Properties();
        properties.put("python.console.encoding", "UTF-8");
        if (SystemUtil.getMajorJavaVersion() <= 8) {
            properties.put("python.security.respectJavaAccessibility", "false");
        }
        Properties properties2 = System.getProperties();
        PythonInterpreter.initialize((Properties)properties2, (Properties)properties, (String[])new String[0]);
        long l2 = System.currentTimeMillis();
        JythonUtil.softCheckJavaVersion();
        this.interpreter = new PythonInterpreter(null, new PySystemState());
        (new Object[1])[0] = System.currentTimeMillis() - l2;
        this.interpreter.exec("import sys");
        this.interpreter.exec(Strings.ff("sys.path.append(\"%s\")", this.directory.replace("\\", "\\\\")));
        String string2 = Strings.ff("%s = __import__('%s', fromlist=['%s']).%s", this.classname, this.filenameNoExt, this.classname, this.classname);
        this.interpreter.exec(string2);
        LogRedirectionOutputStream logRedirectionOutputStream = new LogRedirectionOutputStream();
        this.interpreter.setOut((Writer)logRedirectionOutputStream);
        this.scriptClass = this.interpreter.get(this.classname);
    }

    public void close() {
        this.interpreter.cleanup();
        this.interpreter = null;
    }

    public IScript create() throws ScriptInitializationException {
        if (this.interpreter == null) {
            throw new IllegalStateException("The script interpreter is not initialized");
        }
        PyObject pyObject = this.scriptClass.__call__();
        return (IScript)pyObject.__tojava__(IScript.class);
    }
}

