/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class LogRedirectionOutputStream
extends Writer {
    private static final ILogger logger = GlobalLog.getLogger(LogRedirectionOutputStream.class);
    private int logLevel;
    private StringBuilder current;

    public LogRedirectionOutputStream() {
        this(30, false);
    }

    public LogRedirectionOutputStream(int n2, boolean bl) {
        this.logLevel = n2;
        if (bl) {
            this.current = new StringBuilder();
        }
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            String string = new String(Arrays.copyOfRange(cArray, n2, n2 + n3));
            if (string.isEmpty()) {
                return;
            }
            if (this.logLevel != Integer.MAX_VALUE) {
                logger.log(this.logLevel, true, string, new Object[0]);
            }
            if (this.current != null) {
                StringBuilder stringBuilder = this.current;
                synchronized (stringBuilder) {
                    this.current.append(string);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String pullCurrent() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        StringBuilder stringBuilder = this.current;
        synchronized (stringBuilder) {
            String string = this.current.toString();
            this.current.setLength(0);
            return string;
        }
    }
}

