/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.python.core.PyClass;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class JythonUtil {
    private static final ILogger logger = GlobalLog.getLogger(JythonUtil.class);
    public static final int FLAG_CLASS = 1;
    public static final int FLAG_FUNCTION = 2;

    public static void softCheckJavaVersion() {
        int n2 = SystemUtil.getMajorJavaVersion();
        if (n2 < 8) {
            logger.warn("Jython requires JDK 8 or above. You are currently using JDK %d.", n2);
        }
    }

    public static File findJythonJar(File file) throws JebException {
        for (String string : file.list()) {
            if (!string.startsWith("jython") || !string.toLowerCase().endsWith(".jar")) continue;
            return new File(file, string);
        }
        throw new JebException("Cannot find Jython: Copy your Jython JAR package to the folder: " + file);
    }

    public static List<String> retrieveMembers(PyObject pyObject) {
        return JythonUtil.retrieveMembers(pyObject, 3);
    }

    public static List<String> retrieveMembers(PyObject pyObject, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JythonUtil.collectMethodsFromDict(pyObject, arrayList, n2);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {}
        try {
            PyObject pyObject2 = (PyObject)pyObject.getClass().getField("instclass").get(pyObject);
            JythonUtil.collectMethodsFromDict(pyObject2, arrayList, n2);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {}
        return arrayList;
    }

    private static void collectMethodsFromDict(PyObject pyObject, List<String> list, int n2) throws ReflectiveOperationException {
        Object object = pyObject.getClass().getField("__dict__").get(pyObject);
        Map map = (Map)object.getClass().getDeclaredMethod("getMap", new Class[0]).invoke(object, new Object[0]);
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            if ((n2 & 1) != 0 && v2 instanceof PyClass) {
                list.add(string);
                continue;
            }
            if ((n2 & 2) == 0 || !(v2 instanceof PyFunction)) continue;
            list.add(string);
        }
    }
}

