/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.script.JebPythonPluginFactory;
import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JebPythonPluginService {
    private static final ILogger logger = GlobalLog.getLogger(JebPythonPluginService.class);
    private File pyLibDir;
    private ClassLoader cl;
    private boolean initialized;
    private long creatorThreadId;
    private PythonInterpreter singleInterpreter;
    private Set<String> syspaths = new LinkedHashSet<String>();
    private Set<String> loadedPluginFiles = new LinkedHashSet<String>();
    private Set<String> loadedPluginNames = new LinkedHashSet<String>();

    public JebPythonPluginService(File file) throws JebException {
        this(file, null);
    }

    public JebPythonPluginService(File file, ClassLoader classLoader) throws JebException {
        if (file == null || !file.isDirectory()) {
            throw new JebException(Strings.ff("Path \"%s\" is not a directory", file));
        }
        this.pyLibDir = file;
        this.cl = classLoader;
    }

    public JebPythonPluginService(String string) throws JebException {
        if (Strings.isBlank(string)) {
            throw new IllegalArgumentException("The Python plugins library path cannot be null or empty");
        }
        this.pyLibDir = new File(string);
        if (!this.pyLibDir.exists()) {
            if (!this.pyLibDir.mkdir()) {
                throw new JebException(Strings.ff("Cannot create directory \"%s\"", string));
            }
        } else if (!this.pyLibDir.isDirectory()) {
            throw new JebException(Strings.ff("Path \"%s\" is not a directory", string));
        }
    }

    private synchronized void initJython() throws JebException {
        if (this.initialized) {
            return;
        }
        logger.info("JEB Python plugins are detected: Initializing Jython...", new Object[0]);
        this.creatorThreadId = Thread.currentThread().getId();
        Properties properties = new Properties();
        properties.put("python.console.encoding", "UTF-8");
        if (SystemUtil.getMajorJavaVersion() <= 8) {
            properties.put("python.security.respectJavaAccessibility", "false");
        }
        Properties properties2 = System.getProperties();
        PythonInterpreter.initialize((Properties)properties2, (Properties)properties, (String[])new String[0]);
        this.initialized = true;
    }

    public synchronized JebPythonPluginFactory createFactory(String string) throws JebException {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            if (!file.isAbsolute()) {
                file = new File(this.pyLibDir, string);
            }
            if (!file.exists()) {
                throw new JebException("The plugin was not found: " + string);
            }
        }
        if (!(string2 = file.getName()).toLowerCase().endsWith(".py")) {
            throw new JebException("Expected a '.py' extension for Python plugin");
        }
        this.initJython();
        JebPythonPluginFactory jebPythonPluginFactory = null;
        try {
            String string3 = string2.substring(0, string2.length() - 3);
            jebPythonPluginFactory = new JebPythonPluginFactory(file.getAbsoluteFile().getParent(), string3);
            return jebPythonPluginFactory;
        }
        catch (RuntimeException runtimeException) {
            try {
                if (jebPythonPluginFactory != null) {
                    jebPythonPluginFactory.close();
                }
            }
            catch (Exception exception) {}
            throw new JebException(runtimeException.getMessage());
        }
    }

    public synchronized Class<? extends IPlugin> getPluginClass(String string) throws JebException {
        Object object;
        PySystemState pySystemState;
        File file = new File(string);
        if (!file.exists()) {
            if (!file.isAbsolute()) {
                file = new File(this.pyLibDir, string);
            }
            if (!file.exists()) {
                throw new JebException("The plugin was not found: " + string);
            }
        }
        String string2 = file.getParent();
        String string3 = file.getName().replaceFirst("\\.py", "");
        long l2 = System.currentTimeMillis();
        this.initJython();
        if (this.singleInterpreter == null) {
            JythonUtil.softCheckJavaVersion();
            pySystemState = new PySystemState();
            if (this.cl != null) {
                pySystemState.setClassLoader(this.cl);
            }
            this.singleInterpreter = new PythonInterpreter(null, pySystemState);
            object = new LogRedirectionOutputStream();
            this.singleInterpreter.setOut((Writer)object);
            this.singleInterpreter.exec("import sys");
        }
        if (!this.syspaths.contains(string2)) {
            this.syspaths.add(string2);
            this.singleInterpreter.exec(Strings.ff("sys.path.append(\"%s\")", string2.replace("\\", "\\\\")));
        }
        if (this.loadedPluginFiles.contains(string)) {
            this.singleInterpreter.exec(Strings.ff("import %s", string3));
            this.singleInterpreter.exec(Strings.ff("reload(%s)", string3));
        }
        this.singleInterpreter.exec(Strings.ff("from %s import %s", string3, string3));
        pySystemState = this.singleInterpreter.get(string3);
        object = (Class)pySystemState.__tojava__(Class.class);
        this.loadedPluginFiles.add(string);
        this.loadedPluginNames.add(string3);
        logger.info("%s: Python plugin loaded in %dms", string3, System.currentTimeMillis() - l2);
        return object;
    }

    public IPlugin createPlugin(Class<? extends IPlugin> clazz) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            if (thread.getId() != this.creatorThreadId && this.cl != null) {
                thread.setContextClassLoader(this.cl);
            }
            IPlugin iPlugin = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return iPlugin;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }
}

