/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.Writer;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JebPythonPluginFactory {
    private static final ILogger logger = GlobalLog.getLogger(JebPythonPluginFactory.class);
    private String directory;
    private String classname;
    private PythonInterpreter interpreter;
    private PyObject pluginClass;

    public JebPythonPluginFactory(String string, String string2) {
        this.directory = string;
        this.classname = string2;
        this.init();
    }

    private void init() {
        long l2 = System.currentTimeMillis();
        JythonUtil.softCheckJavaVersion();
        this.interpreter = new PythonInterpreter(null, new PySystemState());
        this.interpreter.exec("import sys");
        this.interpreter.exec(Strings.ff("sys.path.append(\"%s\")", this.directory.replace("\\", "\\\\")));
        this.interpreter.exec(Strings.ff("from %s import %s", this.classname, this.classname));
        LogRedirectionOutputStream logRedirectionOutputStream = new LogRedirectionOutputStream();
        this.interpreter.setOut((Writer)logRedirectionOutputStream);
        this.pluginClass = this.interpreter.get(this.classname);
        logger.debug("%s: Python plugin loaded in %dms", this.classname, System.currentTimeMillis() - l2);
    }

    public void close() {
        this.interpreter.cleanup();
        this.interpreter = null;
    }

    public Class<? extends IPlugin> reload() {
        this.init();
        return this.getPluginClass();
    }

    public Class<? extends IPlugin> getPluginClass() {
        if (this.interpreter == null) {
            throw new IllegalStateException("The factory was closed");
        }
        Class clazz = (Class)this.pluginClass.__tojava__(Class.class);
        return clazz;
    }
}

