/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.script;

import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.script.JythonUtil;
import com.pnfsoftware.jeb.client.script.LogRedirectionOutputStream;
import com.pnfsoftware.jeb.client.script.ScriptExecutionException;
import com.pnfsoftware.jeb.client.script.TypeInfo;
import com.pnfsoftware.jeb.client.script.TypeInfoProvider;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.base.SystemUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.AutocompletionResult;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandInterpreter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.python.core.PyException;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JebPythonInterpreter
implements ICommandInterpreter {
    private static final ILogger logger = GlobalLog.getLogger(JebPythonInterpreter.class);
    private File scriptsDir;
    private IClientContext ctx;
    private boolean allowAutoImport;
    private TypeInfoProvider typeinfoprv;
    private int status;
    private PythonInterpreter interpreter;
    private LogRedirectionOutputStream out;
    private LogRedirectionOutputStream err;
    private Set<String> autoImportedTypes = new HashSet<String>();

    public JebPythonInterpreter(File file, IClientContext iClientContext) throws JebException {
        this.scriptsDir = file;
        this.ctx = iClientContext;
    }

    public void setAllowAutoImport(boolean bl) {
        this.allowAutoImport = bl;
    }

    public boolean isAllowAutoImport() {
        return this.allowAutoImport;
    }

    public void setTypeInfoProvider(TypeInfoProvider typeInfoProvider) {
        this.typeinfoprv = typeInfoProvider;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.typeinfoprv;
    }

    public boolean addToSystemPath(File file) {
        this.interpreter.exec(Strings.ff("sys.path.append(\"%s\")", file.getAbsolutePath().replace("\\", "\\\\")));
        return true;
    }

    @Override
    public void prepare() {
        if (this.status != 0) {
            return;
        }
        this.status = -1;
        Properties properties = new Properties();
        properties.put("python.console.encoding", "UTF-8");
        if (SystemUtil.getMajorJavaVersion() <= 8) {
            properties.put("python.security.respectJavaAccessibility", "false");
        }
        Properties properties2 = System.getProperties();
        PythonInterpreter.initialize((Properties)properties2, (Properties)properties, (String[])new String[0]);
        long l2 = System.currentTimeMillis();
        JythonUtil.softCheckJavaVersion();
        this.interpreter = new PythonInterpreter(null, new PySystemState());
        (new Object[1])[0] = System.currentTimeMillis() - l2;
        this.interpreter.exec("import sys");
        if (this.scriptsDir != null) {
            this.addToSystemPath(this.scriptsDir);
        }
        this.out = new LogRedirectionOutputStream(30, true);
        this.interpreter.setOut((Writer)this.out);
        this.err = new LogRedirectionOutputStream(50, false);
        this.interpreter.setErr((Writer)this.err);
        Reader reader = new Reader(){

            @Override
            public int read(char[] cArray, int n2, int n3) throws IOException {
                logger.error("This interpreter does not accept input from stdin at the moment", new Object[0]);
                return -1;
            }

            @Override
            public void close() throws IOException {
            }
        };
        this.interpreter.setIn(reader);
        if (this.ctx != null) {
            this.interpreter.set("jeb", (Object)this.ctx);
        }
        this.status = 1;
    }

    public void injectObject(String string, Object object) throws ScriptExecutionException {
        this.interpreter.set(string, object);
    }

    @Override
    public ExecutionResult executeCommand(String string) {
        return this.executeInternal(string, this.isAllowAutoImport());
    }

    public ExecutionResult executeInternal(String string, boolean bl) {
        PyObject pyObject;
        Object object;
        if ("help".equals(string.trim())) {
            Object object2 = "";
            object2 = (String)object2 + Strings.ff("JEB Developers Portal: %s", "https://www.pnfsoftware.com/jeb/devportal");
            object2 = (String)object2 + Strings.ff("\nAPI Reference Documention: %s ", "https://www.pnfsoftware.com/jeb/apidoc");
            object2 = (String)object2 + Strings.ff("\nSample Scripts: %s", "https://github.com/pnfsoftware/jeb-samplecode/tree/master/scripts");
            return ExecutionResult.success((String)object2);
        }
        try {
            this.prepare();
        }
        catch (Exception exception) {
            return ExecutionResult.error(exception);
        }
        while (true) {
            try {
                object = this.interpreter.compile(string);
                pyObject = this.interpreter.eval((PyObject)object);
            }
            catch (PyException pyException) {
                Object object3;
                block17: {
                    object3 = pyException.toString();
                    if (bl) {
                        try {
                            TypeInfo typeInfo;
                            String string2 = pyException.value.toString();
                            String string3 = this.getUndefinedName(string2);
                            if (string3 != null && this.autoImportedTypes.add(string3) && (typeInfo = this.findCandidateJebApiType(string3)) != null) {
                                if (!typeInfo.getSimpleName().equals(string3)) {
                                    object3 = (String)object3 + "# Did you mean " + typeInfo.getSimpleName() + "?";
                                } else if (this.loadJebApiType(typeInfo.getName())) {
                                    logger.debug("# Auto-imported %s", typeInfo.getName());
                                    bl = true;
                                    continue;
                                }
                            }
                            break block17;
                        }
                        catch (Exception exception) {}
                        break block17;
                        continue;
                    }
                }
                return ExecutionResult.error((String)object3);
            }
            catch (Exception exception) {
                return ExecutionResult.error(exception);
            }
            break;
        }
        if (pyObject != null && !(pyObject instanceof PyNone)) {
            object = pyObject.toString();
            if (pyObject instanceof PyString) {
                object = "'" + (String)object + "'";
            }
        } else {
            object = this.out.pullCurrent();
        }
        return ExecutionResult.success((String)object);
    }

    public Collection<String> getAutoImportedTypes() {
        return Collections.unmodifiableSet(this.autoImportedTypes);
    }

    @Override
    public String getName() {
        return "py";
    }

    @Override
    public String getDescription() {
        return "Python Interpreter (built on Jython 2.7)";
    }

    @Override
    public String getBanner() {
        Object object = "";
        object = (String)object + "* JEB Python interpreter (EXPERIMENTAL) - uses Jython 2.7\n";
        object = (String)object + "* The current client context (type: com.pnfsoftware.jeb.client.api.IClientContext) is located in the `jeb` global variable\n";
        if (this.scriptsDir != null) {
            object = (String)object + "* The following folder was auto-added to sys.path: " + this.scriptsDir + "\n";
        }
        object = (String)object + "* Refer to the API doc (Help menu) and sample scripts and plugins to get started";
        return object;
    }

    @Override
    public boolean shouldDisplayRawResults() {
        return true;
    }

    @Override
    public AutocompletionResult autoComplete(String string) {
        Object object;
        try {
            this.prepare();
        }
        catch (Exception exception) {
            return AutocompletionResult.EMPTY;
        }
        if (string == null) {
            return AutocompletionResult.EMPTY;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return AutocompletionResult.EMPTY;
        }
        String string2 = string.substring(n2 + 1);
        String string3 = string.substring(0, n2);
        if ((n2 = string3.lastIndexOf(46)) >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        if ((n2 = string3.lastIndexOf(32)) >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        if ((n2 = string3.lastIndexOf(9)) >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        if (string3.isEmpty()) {
            return AutocompletionResult.EMPTY;
        }
        PyObject pyObject = this.interpreter.get(string3);
        if (pyObject != null && (object = pyObject.__tojava__(Object.class)) != null) {
            AutocompletionResult autocompletionResult = new AutocompletionResult(null, '.');
            if (object instanceof PyObject) {
                List<String> list = JythonUtil.retrieveMembers((PyObject)object);
                autocompletionResult.addAll(list);
            } else {
                HashSet hashSet = new HashSet();
                hashSet.add(Object.class);
                this.recordCandidates(object.getClass(), string2, autocompletionResult, hashSet);
            }
            return autocompletionResult;
        }
        return AutocompletionResult.EMPTY;
    }

    private void recordCandidates(Class<?> clazz, String string, AutocompletionResult autocompletionResult, Set<Class<?>> set) {
        Object object;
        if (!set.add(clazz)) {
            return;
        }
        if (!this.isJebPrivateType(clazz)) {
            object = clazz.getMethods();
            int n2 = ((Method[])object).length;
            for (int i = 0; i < n2; ++i) {
                Method method = object[i];
                if ((method.getModifiers() & 1) == 0) continue;
                this.attemptRecordName(method.getName(), string, autocompletionResult);
            }
        }
        if ((object = clazz.getSuperclass()) == null) {
            return;
        }
        this.recordCandidates((Class<?>)object, string, autocompletionResult, set);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.recordCandidates(clazz2, string, autocompletionResult, set);
        }
    }

    private boolean isJebPrivateType(Class<?> clazz) {
        String string = clazz.getName();
        if (string.startsWith("com.pnfsoftware.jeb.clienti")) {
            return true;
        }
        if (string.startsWith("com.pnfsoftware.jeb.corei")) {
            return true;
        }
        if (string.startsWith("com.pnfsoftware.jeb.rcpclient")) {
            return true;
        }
        return string.startsWith("com.pnfsoftware.jebglobal");
    }

    private void attemptRecordName(String string, String string2, AutocompletionResult autocompletionResult) {
        if (!string.startsWith(string2)) {
            return;
        }
        if (string.equals("this") || string.startsWith("this$")) {
            return;
        }
        autocompletionResult.add(string);
    }

    private String getUndefinedName(String string) {
        if (string.startsWith("name '") && string.endsWith("' is not defined")) {
            String string2 = string.substring(6, string.length() - 16);
            return string2;
        }
        return null;
    }

    private TypeInfo findCandidateJebApiType(String string) {
        if (this.typeinfoprv == null) {
            return null;
        }
        return this.typeinfoprv.findType(string, true);
    }

    private boolean loadJebApiType(String string) {
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        ExecutionResult executionResult = this.executeInternal("from " + string2 + " import " + string3, false);
        return executionResult.isSuccess();
    }
}

