/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client.jebio;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.jebio.JebIoObjectFile;
import com.pnfsoftware.jeb.client.jebio.JebIoObjectUser;
import com.pnfsoftware.jeb.client.jebio.SampleDetermination;
import com.pnfsoftware.jeb.client.jebio.UserCredentials;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.net.FormFileEntry;
import com.pnfsoftware.jeb.util.net.INet;
import com.pnfsoftware.jeb.util.net.UrlParametersBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.simple.parser.JSONParser;

public class JebIoApiHelper {
    public static final String BASE = "https://www.pnfsoftware.com/io/api";
    private INet net;
    private UserCredentials credentials;

    public JebIoApiHelper(INet iNet, UserCredentials userCredentials) {
        this.net = iNet;
        this.credentials = userCredentials;
    }

    public JebIoObjectUser createUser(String string, String string2) throws IOException {
        String string3 = this.net.query("https://www.pnfsoftware.com/io/api/account/create", new UrlParametersBuilder().put("email", string).put("password", string2).put("uid", "" + Licensing.user_id).put("lid", "" + Licensing.license_id).build());
        try {
            Map map = (Map)new JSONParser().parse(string3);
            return JebIoObjectUser.fromJson(map);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public JebIoObjectUser getUser() throws IOException {
        String string = this.net.query("https://www.pnfsoftware.com/io/api/account/view", new UrlParametersBuilder().put("email", this.credentials.getEmail()).put("password", this.credentials.getPassword()).build());
        try {
            Map map = (Map)new JSONParser().parse(string);
            return JebIoObjectUser.fromJson(map);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public long checkFileHash(File file) throws IOException {
        String string = Formatter.byteArrayToHexString(Hash.calculateSHA256(IO.readFile(file)));
        return this.checkFileHash(string);
    }

    public long checkFileHash(String string) throws IOException {
        String string2 = Strings.ff("%s/file/check?apikey=%s&h=%s", BASE, this.credentials.getApikey(), string);
        String string3 = this.net.query(string2);
        return JebIoApiHelper.getCode(string3);
    }

    public JebIoObjectFile getFile(String string) throws IOException {
        String string2 = Strings.ff("%s/file/check?apikey=%s&h=%s", BASE, this.credentials.getApikey(), string);
        String string3 = this.net.query(string2);
        try {
            Map map = (Map)new JSONParser().parse(string3);
            return JebIoObjectFile.fromJson(map);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public int shareFile(File file, String string, String string2, SampleDetermination sampleDetermination, boolean bl) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("comments", string2);
        hashMap.put("determination", Integer.toString(sampleDetermination.getLevel()));
        HashMap<String, FormFileEntry> hashMap2 = new HashMap<String, FormFileEntry>();
        hashMap2.put("ufile", new FormFileEntry(file, string));
        Object object = "https://www.pnfsoftware.com/io/api/file/upload";
        if (this.credentials != null && !bl) {
            object = (String)object + "?apikey=" + this.credentials.getApikey();
        }
        String string3 = this.net.postMultipart((String)object, hashMap, hashMap2);
        return JebIoApiHelper.getCode(string3);
    }

    public byte[] downloadFile(String string) throws IOException {
        String string2 = Strings.ff("%s/file/download?apikey=%s&h=%s", BASE, this.credentials.getApikey(), string);
        return this.net.queryBinary(string2);
    }

    static int getCode(String string) throws IOException {
        try {
            Object object = new JSONParser().parse(string);
            return ((Long)((Map)object).get("code")).intValue();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    static String getApiKey(String string) throws IOException {
        try {
            Object object = new JSONParser().parse(string);
            return ((Map)object).get("apikey").toString();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    static int getShareCount(String string) throws IOException {
        try {
            Object object = new JSONParser().parse(string);
            return ((Long)((Map)object).get("sharecount")).intValue();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public String queryAssistant(int n2, String string) throws IOException {
        String string2 = Strings.ff("%s/assistant/r1?apikey=%s", BASE, this.credentials == null ? "0" : this.credentials.getApikey());
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("buildkey", Licensing.buildkey);
        linkedHashMap.put("qtype", "" + n2);
        linkedHashMap.put("data", string);
        String string3 = this.net.post(string2, null, linkedHashMap, null);
        return string3;
    }
}

