/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.csv;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class SystemInformation {
    private static final ILogger logger = GlobalLog.getLogger(SystemInformation.class);
    public static final String javavendor = System.getProperty(csv.ce(new byte[]{126, 11, 23, 23, 79, 88, 19, 11, 10, 11, 29}, 1, 20), "");
    public static final String javaversion = System.getProperty(csv.ce(new byte[]{-97, 11, 23, 23, 79, 88, 19, 23, 1, 26, 6, 1}, 1, 245), "");
    public static final String osname = System.getProperty(csv.ce(new byte[]{-108, 28, 93, 64, 15, 12, 8}, 1, 251), "");
    public static final String osarch = System.getProperty(csv.ce(new byte[]{44, 28, 94, 24, 0, 10, 15}, 2, 99), "");
    public static final String osversion = System.getProperty(csv.ce(new byte[]{-70, 28, 93, 88, 19, 23, 1, 26, 6, 1}, 1, 213), "");
    public static final String username = System.getProperty(csv.ce(new byte[]{29, 6, 22, 23, 92, 64, 15, 12, 8}, 1, 104), "");
    public static final String compname;
    public static final String localeinfo;
    public static final String osfullname;

    public static String getCurrentDirectory() {
        return System.getProperty(csv.ce(new byte[]{-114, 6, 22, 23, 92, 74, 13, 27}, 1, 251));
    }

    public static String setCurrentDirectory(String string) {
        String string2 = SystemInformation.getCurrentDirectory();
        logger.debug("Setting current directory: %s", string);
        System.setProperty(csv.ce(new byte[]{54, 28, 21, 11, 92, 13, 14, 26}, 2, 213), string);
        return string2;
    }

    public static String determineLinuxOSFullname(String string) {
        try {
            File file = new File(string);
            if (file.isFile() && file.canRead()) {
                for (String string2 : IO.readLines(file)) {
                    String[] stringArray;
                    if (!(string2 = string2.trim()).startsWith("PRETTY_NAME") || (stringArray = string2.split("=")).length != 2 || !stringArray[0].trim().equals("PRETTY_NAME")) continue;
                    String string3 = stringArray[1].trim();
                    if (string3.length() >= 2 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                        string3 = string3.substring(1, string3.length() - 1).trim();
                    }
                    return string3;
                }
            }
        }
        catch (Exception exception) {}
        return "";
    }

    static {
        String string = "";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        compname = string;
        Locale locale = Locale.getDefault();
        localeinfo = locale.toString();
        osfullname = OSType.determine().isLinux() ? SystemInformation.determineLinuxOSFullname("/etc/os-release") : "";
    }
}

