/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PublicAnnouncement {
    private static final ILogger logger = GlobalLog.getLogger(PublicAnnouncement.class);
    private int id;
    private String text;
    Version jebver_lt;
    Version jebver_le;
    Version jebver_gt;
    Version jebver_ge;

    private PublicAnnouncement() {
    }

    public static PublicAnnouncement parse(String string) {
        JSONObject jSONObject = (JSONObject)JSONValue.parse((String)string);
        try {
            PublicAnnouncement publicAnnouncement = new PublicAnnouncement();
            publicAnnouncement.id = (int)((Long)jSONObject.get((Object)"id")).longValue();
            publicAnnouncement.text = (String)jSONObject.get((Object)"text");
            String string2 = (String)jSONObject.get((Object)("text_" + Licensing.buildkey));
            if (string2 != null) {
                publicAnnouncement.text = publicAnnouncement.text + string2;
            }
            if ((string2 = (String)jSONObject.get((Object)"jebver_lt")) != null) {
                publicAnnouncement.jebver_lt = Version.parseFromString(string2);
            }
            if ((string2 = (String)jSONObject.get((Object)"jebver_le")) != null) {
                publicAnnouncement.jebver_le = Version.parseFromString(string2);
            }
            if ((string2 = (String)jSONObject.get((Object)"jebver_gt")) != null) {
                publicAnnouncement.jebver_gt = Version.parseFromString(string2);
            }
            if ((string2 = (String)jSONObject.get((Object)"jebver_ge")) != null) {
                publicAnnouncement.jebver_ge = Version.parseFromString(string2);
            }
            return publicAnnouncement;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public boolean checkTests() {
        if (Strings.isBlank(this.getText())) {
            return false;
        }
        return this.checkVersion();
    }

    boolean checkVersion() {
        if (this.jebver_lt != null && AbstractContext.app_ver.compareTo(this.jebver_lt) >= 0) {
            return false;
        }
        if (this.jebver_le != null && AbstractContext.app_ver.compareTo(this.jebver_le) > 0) {
            return false;
        }
        if (this.jebver_gt != null && AbstractContext.app_ver.compareTo(this.jebver_gt) <= 0) {
            return false;
        }
        return this.jebver_ge == null || AbstractContext.app_ver.compareTo(this.jebver_ge) >= 0;
    }
}

