/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.AssetManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.URLUtil;
import com.pnfsoftware.jebglobal.csv;
import com.pnfsoftware.jebglobal.nx;
import java.io.File;

public final class Licensing {
    public static int loaded;
    private static final ILogger logger;
    private static final String LICENSE_FILENAME = "jeb-license.txt";
    public static boolean hasDecompDex;
    public static boolean hasDecompArm;
    public static boolean hasDecompX86;
    public static boolean hasDecompMips;
    public static boolean hasDecompRiscv;
    public static boolean hasDecompWasm;
    public static boolean hasDecompEvm;
    public static boolean hasDecompS7;
    public static String user_name;
    public static String user_group;
    public static String user_email;
    public static int user_id;
    public static long license_id;
    public static int user_count;
    private static int license_ts;
    private static int license_validity;
    private static int real_license_ts;
    public static String buildkey;
    public static int build_type;
    private static final int FLAG_DEBUG = 1;
    private static final int FLAG_FULL = 2;
    private static final int FLAG_FLOATING = 4;
    private static final int FLAG_AIRGAP = 8;
    private static final int FLAG_ANYCLIENT = 16;
    private static final int FLAG_COREAPI = 32;
    private static final int FLAG_PERPETUAL = 64;
    private static final int FLAG_JEB2 = 128;

    public static final void setLicenseTimestamp(int n2) {
        if (n2 > 0 && license_ts == 0) {
            real_license_ts = n2;
        }
    }

    public static final int getLicenseTimestamp() {
        return real_license_ts;
    }

    public static final int getExpirationTimestamp() {
        if (real_license_ts <= 0 || license_validity <= 0) {
            return 0;
        }
        return real_license_ts + 86400 * license_validity;
    }

    public static final int getBuildType() {
        return build_type;
    }

    public static final boolean isDebugBuild() {
        return (build_type & 1) != 0;
    }

    public static final boolean isReleaseBuild() {
        return !Licensing.isDebugBuild();
    }

    public static final boolean isFullBuild() {
        return (build_type & 2) != 0;
    }

    public static final boolean isDemoBuild() {
        return !Licensing.isFullBuild();
    }

    public static final boolean isFloatingBuild() {
        return (build_type & 4) != 0;
    }

    public static final boolean isIndividualBuild() {
        return !Licensing.isFloatingBuild();
    }

    public static final boolean isAirgapBuild() {
        return (build_type & 8) != 0;
    }

    public static final boolean isInternetRequired() {
        return !Licensing.isAirgapBuild();
    }

    public static final boolean allowAnyClient() {
        return (build_type & 0x10) != 0;
    }

    public static final boolean canUseCoreAPI() {
        return (build_type & 0x20) != 0;
    }

    public static final boolean isPerpetual() {
        return (build_type & 0x40) != 0;
    }

    public static final boolean isSubscription() {
        return !Licensing.isPerpetual();
    }

    public static final boolean isCommunityEdition() {
        return csv.ce(new byte[]{-102, 15, 7, 79, 78, 6}, 1, 240).equals(buildkey);
    }

    public static final boolean isFree() {
        return Licensing.isDemoBuild() || Licensing.isCommunityEdition();
    }

    public static final boolean isPro() {
        return buildkey != null && buildkey.startsWith("jeb-pro");
    }

    public static boolean isCommonBuild() {
        return user_id == 760781040;
    }

    public static final String getBuildTypeString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (Licensing.isReleaseBuild()) {
            stringBuilder.append(csv.ce(new byte[]{27, 23, 9, 9, 4, 18, 22, 74}, 1, 105));
        } else {
            stringBuilder.append(csv.ce(new byte[]{39, 10, 18, 12, 21, 70}, 2, 147));
        }
        if (Licensing.isFullBuild()) {
            stringBuilder.append(csv.ce(new byte[]{37, 26, 28, 21, 93}, 2, 160));
        } else {
            stringBuilder.append(csv.ce(new byte[]{39, 10, 29, 22, 93}, 2, 199));
        }
        if (Licensing.isFloatingBuild()) {
            stringBuilder.append(csv.ce(new byte[]{37, 3, 31, 24, 6, 0, 9, 15, 91}, 2, 127));
        } else {
            stringBuilder.append(csv.ce(new byte[]{42, 1, 20, 16, 4, 0, 3, 29, 21, 76, 7}, 2, 100));
        }
        if (Licensing.isAirgapBuild()) {
            stringBuilder.append(csv.ce(new byte[]{25, 8, 27, 95, 74, 6, 17, 95}, 1, 120));
        } else {
            stringBuilder.append(csv.ce(new byte[]{49, 10, 1, 84, 27, 7, 19, 13, 6, 78, 77, 23, 6}, 2, 211));
        }
        if (Licensing.allowAnyClient()) {
            stringBuilder.append(csv.ce(new byte[]{34, 1, 9, 84, 17, 5, 14, 13, 26, 84, 7}, 2, 22));
        } else {
            stringBuilder.append(csv.ce(new byte[]{44, 9, 22, 16, 17, 0, 6, 4, 89, 67, 68, 10, 76, 78, 69, 22}, 2, 114));
        }
        if (Licensing.canUseCoreAPI()) {
            stringBuilder.append(csv.ce(new byte[]{32, 0, 2, 28, 95, 8, 23, 1, 91}, 2, 41));
        } else {
            stringBuilder.append(csv.ce(new byte[]{64, 1, 66, 78, 12, 29, 23, 72, 76, 17, 25, 70}, 1, 46));
        }
        if (Licensing.isPerpetual()) {
            stringBuilder.append(csv.ce(new byte[]{-90, 21, 23, 2, 21, 17, 1, 20, 13}, 1, 214));
        } else {
            stringBuilder.append(csv.ce(new byte[]{86, 6, 23, 17, 16, 17, 27, 25, 4, 29, 6, 1}, 1, 37));
        }
        return stringBuilder.toString();
    }

    public static String getLicense() {
        byte[] byArray = AssetManager.ce("LICENSE.TXT");
        if (byArray == null) {
            return null;
        }
        return Strings.decodeUTF8(byArray);
    }

    public static String getChangeList() {
        byte[] byArray = AssetManager.ce("CHANGELIST.TXT");
        if (byArray == null) {
            return null;
        }
        return Strings.decodeUTF8(byArray);
    }

    static {
        logger = GlobalLog.getLogger(Licensing.class);
        nx.ce[4] = 95;
        int n2 = 0;
        n2 |= 0x80;
        hasDecompDex = true;
        hasDecompArm = true;
        hasDecompX86 = true;
        hasDecompMips = true;
        hasDecompRiscv = true;
        hasDecompWasm = true;
        hasDecompEvm = true;
        hasDecompS7 = true;
        File file = URLUtil.urlToFile(Licensing.class.getProtectionDomain().getCodeSource().getLocation()).getParentFile();
        nx nx2 = new nx(new File(file, LICENSE_FILENAME));
        user_name = nx2.ce();
        user_group = nx2.mm();
        user_email = nx2.fz();
        user_id = nx2.Rs();
        license_id = nx2.ok();
        user_count = nx2.mH();
        license_ts = nx2.tA();
        license_validity = nx2.hG();
        build_type = n2;
        buildkey = nx2.ZQ();
        real_license_ts = license_ts;
    }
}

