/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.events.ControllerNotification;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.csv;
import java.io.File;
import java.io.IOException;

@SerDisabled
public class HeadlessClientContext
extends AbstractClientContext
implements IClientContext {
    private static final ILogger logger = GlobalLog.getLogger(HeadlessClientContext.class);

    @Override
    public void initialize(String[] stringArray) {
        super.initialize(stringArray);
    }

    @Override
    public void start() throws JebException {
        super.start();
        this.initializeEngines();
    }

    @Override
    public void stop() {
        super.stop();
        logger.info("Done.", new Object[0]);
    }

    @Override
    public boolean displayEula(String string) {
        System.out.println(string);
        System.out.print(csv.ce(new byte[]{-30, 37, 27, 29, 17, 69, 2, 91, 28, 22, 81, 2, 84, 27, 79, 65, 6, 21, 23, 0, 73, 12, 84, 28, 13, 11, 78, 80, 2, 23, 22, 0, 83, 69, 11, 26, 17, 23, 72, 26}, 1, 181));
        String string2 = IO.readInputLineSafe();
        return string2 != null && string2.trim().equalsIgnoreCase(csv.ce(new byte[]{92, 28, 22}, 1, 37));
    }

    @Override
    public String retrieveLicenseKey(String string) {
        System.out.println("Please generate a license key to use JEB. This one-time operation will only take a few seconds.");
        System.out.println(Strings.ff(S.s(90), "https://www.pnfsoftware.com/genlk"));
        try {
            File file = new File(".jeb_license_data");
            IO.writeFile(file, string);
            System.out.format("For your reference, the license data blob was dumped to: %s\n", file.getAbsolutePath());
        }
        catch (IOException iOException) {}
        System.out.println(Strings.ff(S.s(91), string));
        System.out.print(Strings.ff("%s: ", S.s(92)));
        return IO.readInputLineSafe();
    }

    @Override
    public boolean checkUpdate() {
        return false;
    }

    @Override
    public void onUpdatedSoftware(String string, Version version) {
    }

    @Override
    public void notifySupportExpired() {
    }

    @Override
    public void displayDemoInformation(String string) {
    }

    @Override
    public boolean setupController() {
        logger.warn("[Floating] Please edit jeb-client.cfg and set up your controller interface", new Object[0]);
        return false;
    }

    @Override
    public void notifyFloatingClient(ControllerNotification controllerNotification) {
        logger.error("[Floating] The JEB controller disallowed this instance to run", new Object[0]);
    }

    static {
        GlobalLog.addDestinationStream(System.out);
    }
}

