/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.SystemInformation;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IEnginesPlugin;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDOptimizer;
import com.pnfsoftware.jeb.core.units.code.java.IJOptimizer;
import com.pnfsoftware.jeb.util.base.Env;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.base.Stacktraces;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.SizeFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class ErrorLogGenerator {
    public static final int ERRORLOG_VERSION = 2;
    public static final String KEY_URLENCODED_THREADS = "urlencoded-threads";
    private Throwable t;
    private LinkedHashMap<String, String> records = new LinkedHashMap();
    private String timestamp;

    public static String generateUrlencodedThreadsRecordValue() {
        String string = Stacktraces.formatThreadStacktraces();
        return Strings.urlencodeUTF8(string);
    }

    public ErrorLogGenerator(Throwable throwable) {
        Runtime runtime = Runtime.getRuntime();
        this.t = throwable;
        this.timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        this.addRecord("logversion", 2);
        this.addRecord("product", "JEB");
        this.addRecord("timestamp", this.timestamp);
        this.addRecord("version", AbstractClientContext.app_ver);
        this.addRecord("userid", Licensing.user_id);
        this.addRecord("licenseid", Licensing.license_id);
        this.addRecord("build", Licensing.buildkey);
        this.addRecord("system", SystemInformation.osname + " " + SystemInformation.osversion + " " + SystemInformation.osarch);
        if (SystemInformation.osfullname != null && SystemInformation.osfullname.length() > 0) {
            this.addRecord("system-fullname", SystemInformation.osfullname);
        }
        if (OSType.determine().isLinux()) {
            this.addRecord("linux-xdg-env", Strings.ff("%s; %s; %s", Env.getsafe("XDG_CURRENT_DESKTOP"), Env.getsafe("XDG_SESSION_DESKTOP"), Env.getsafe("XDG_SESSION_TYPE")));
        }
        this.addRecord("java", SystemInformation.javavendor + " " + SystemInformation.javaversion);
        this.addRecord("locale", SystemInformation.localeinfo);
        this.addRecord("memory-usage", Strings.ff("used=%s,alloc=%s,max=%s", SizeFormatter.formatByteSize(runtime.totalMemory() - runtime.freeMemory()), SizeFormatter.formatByteSize(runtime.totalMemory()), SizeFormatter.formatByteSize(runtime.maxMemory())));
        int n2 = 0;
        String string = Throwables.formatStacktrace(throwable);
        if (Strings.splitLines(Strings.trim(string)).length == 1) {
            string = Throwables.formatStacktraceAlt(throwable);
            n2 = 1;
        }
        this.addRecord("stacktrace", string);
        if (n2 != 0) {
            this.addRecord("stacktrace-type", n2);
        }
    }

    public void recordEnginesInformation(IEnginesContext iEnginesContext) {
        List<String> list = this.generatePluginsList(iEnginesContext.getPluginManager().getPlugins(IEnginesPlugin.class, false));
        this.addRecord("backend-plugins-generic", Strings.joinList(list));
        list = this.generatePluginsList(iEnginesContext.getUnitIdentifiers());
        this.addRecord("backend-plugins-parsers", Strings.joinList(list));
        list = this.generatePluginsList(iEnginesContext.getPluginManager().getPlugins(IDOptimizer.class, false));
        this.addRecord("backend-plugins-dexdec-ir", Strings.joinList(list));
        list = this.generatePluginsList(iEnginesContext.getPluginManager().getPlugins(IJOptimizer.class, false));
        this.addRecord("backend-plugins-dexdec-ast", Strings.joinList(list));
    }

    private List<String> generatePluginsList(List<? extends IPlugin> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IPlugin iPlugin : list) {
            IPluginInformation iPluginInformation = iPlugin.getPluginInformation();
            if (iPluginInformation == null) {
                arrayList.add("<unspecified-plugin>");
                continue;
            }
            if (iPluginInformation.getVersion() == null) {
                arrayList.add(Strings.safe(iPluginInformation.getName(), "<no-name>"));
                continue;
            }
            arrayList.add(Strings.ff("%s:%s", Strings.safe(iPluginInformation.getName(), "<no-name>"), Strings.safe(iPluginInformation.getVersion(), "no-version")));
        }
        return arrayList;
    }

    public LinkedHashMap<String, String> getRecords() {
        return this.records;
    }

    public String addRecord(String string, Object object) {
        return this.addRecord(string, object, true);
    }

    public String addRecord(String string, Object object, boolean bl) {
        int n2 = 0;
        Object object2 = string;
        while (this.records.containsKey(object2)) {
            if (!bl) {
                return null;
            }
            object2 = string + "-" + ++n2;
        }
        this.records.put((String)object2, Strings.toString(object));
        return object2;
    }

    public boolean setRecord(String string, Object object) {
        return this.records.put(string, Strings.toString(object)) == null;
    }

    public boolean removeRecord(String string) {
        return this.records.remove(string) != null;
    }

    public Throwable getThrowable() {
        return this.t;
    }

    public String getLog() {
        return this.getLog(null, false);
    }

    public String getLog(Collection<String> collection, boolean bl) {
        if (collection == null) {
            collection = this.records.keySet();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            String string2 = this.records.get(string);
            if (string2 == null) continue;
            this.writeEntry(stringBuilder, string, string2, bl);
        }
        return stringBuilder.toString();
    }

    private void writeEntry(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (bl) {
            string = Strings.urlencodeUTF8(string);
            string2 = Strings.urlencodeUTF8(string2);
        }
        Strings.ff(stringBuilder, "%s: %s\n", string, string2);
    }

    public String toString() {
        return this.getLog();
    }

    public String dumpTo(String string) {
        return this.dumpTo(string, null, false);
    }

    public String dumpTo(String string, String string2, boolean bl) {
        if (string2 == null) {
            string2 = Strings.ff("jeb_errorlog_%s.txt", this.timestamp);
        }
        File file = new File(string, string2);
        try {
            IO.writeFile(file, Strings.encodeUTF8(this.getLog(null, bl)));
            return IO.abs(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

