/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.client;

import com.pnfsoftware.jeb.AssetManager;
import com.pnfsoftware.jeb.client.AbstractContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.PublicAnnouncement;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.SoftwareBuildInfo;
import com.pnfsoftware.jeb.client.SystemInformation;
import com.pnfsoftware.jeb.client.api.IClientContext;
import com.pnfsoftware.jeb.client.telemetry.ITelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.MootTelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.StandardTelemetryDatabase;
import com.pnfsoftware.jeb.client.telemetry.StandardTelemetryEndpoint;
import com.pnfsoftware.jeb.client.telemetry.TelemetryException;
import com.pnfsoftware.jeb.core.Artifact;
import com.pnfsoftware.jeb.core.CoreOptions;
import com.pnfsoftware.jeb.core.ICoreContext;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.JebClientInformation;
import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.dao.impl.DataProvider;
import com.pnfsoftware.jeb.core.dao.impl.JDB2Manager;
import com.pnfsoftware.jeb.core.dao.impl.SimpleFSFileStore;
import com.pnfsoftware.jeb.core.events.ControllerNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.PropertyChangeNotification;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.CommonsConfigurationWrapper;
import com.pnfsoftware.jeb.core.properties.impl.PropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypePath;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeString;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.SizeFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import com.pnfsoftware.jebglobal.Hl;
import com.pnfsoftware.jebglobal.Kh;
import com.pnfsoftware.jebglobal.UB;
import com.pnfsoftware.jebglobal.csv;
import com.pnfsoftware.jebglobal.jC;
import com.pnfsoftware.jebglobal.mo;
import com.pnfsoftware.jebglobal.nM;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;

@SerDisabled
public abstract class AbstractClientContext
extends AbstractContext
implements IClientContext {
    private static final ILogger logger = GlobalLog.getLogger(AbstractClientContext.class);
    public static final String defaultClientConfigPath = "jeb-client.cfg";
    public static final String defaultEnginesConfigPath = "jeb-engines.cfg";
    public static final String defaultTelemetryDatabasePath = "jt.db";
    public static final String defaultScriptsFolderName = "scripts";
    public static final String defaultPluginsFolderName = "coreplugins";
    private static final String UPDATE_FILENAME = csv.ce(new byte[]{48, 5, 20, 5, 21, 17, 75, 84, 19, 25}, 1, 69);
    private static final String UPDATE_PASS_FILENAME = csv.ce(new byte[]{54, 31, 20, 24, 6, 12, 73, 24, 3, 68}, 2, 43);
    protected CoreOptions coreOptions = CoreOptions.getDefault();
    protected String[] args = new String[0];
    private String configpath;
    private String engconfigpath;
    protected String scriptpath;
    protected String inputpath;
    private boolean shouldInitEngines;
    protected boolean basicChecksPassed;
    protected String ugerrstr;
    private IPropertyDefinitionManager pdm;
    private IPropertyManager pm;
    private PropertiesConfiguration cfg;
    private String teledbpath;
    private ITelemetryDatabase teledb;
    private static Net net;
    private static jC pinger;
    public static final String CLIENT_RUNNING_FILENAME_PREFIX = ".jebc_ts";
    public static final String INSTALLER_LOCK_FILENAME = ".jebi_lock";
    private ICoreContext corectx;
    private IEnginesContext engctx;
    private ConcurrentHashMap<Object, Object> transientStore = new ConcurrentHashMap();

    protected AbstractClientContext() {
    }

    private boolean checkRunningClients() {
        boolean bl = false;
        String string = this.getBaseDirectory();
        for (String string2 : new File(string).list()) {
            if (!string2.startsWith(CLIENT_RUNNING_FILENAME_PREFIX)) continue;
            File file = new File(string, string2);
            if (System.currentTimeMillis() - file.lastModified() <= 3000L) {
                bl = true;
                continue;
            }
            file.delete();
        }
        return bl;
    }

    public boolean checkRunningInstaller() {
        File file = new File(this.getBaseDirectory(), INSTALLER_LOCK_FILENAME);
        if (!file.exists()) {
            return false;
        }
        if (System.currentTimeMillis() - file.lastModified() <= 3000L) {
            return true;
        }
        file.delete();
        return false;
    }

    public void initialize(String[] stringArray) {
        Object object;
        Object object2;
        boolean bl = this.checkRunningClients();
        boolean bl2 = this.checkRunningInstaller();
        if (bl2) {
            if (!bl) {
                object2 = new File(this.getBaseDirectory(), INSTALLER_LOCK_FILENAME);
                System.out.println("The JEB installer is locking execution!");
                System.out.println("An update may be about to be installed. Please wait a few seconds, JEB will attempt to start again automatically.");
                System.out.println("If you wish to bypass the lock, delete the following file: " + (File)object2);
                System.exit(-1);
            }
        } else {
            try {
                object2 = new File(this.getAppDirectory(), "jebi.jar.new");
                if (((File)object2).isFile()) {
                    File file = new File(this.getAppDirectory(), "jebi.jar");
                    IO.renameFile((File)object2, file, 1);
                }
            }
            catch (Exception exception) {}
        }
        ThreadUtil.start("GUI Lockfile Watcher", new Runnable(){

            @Override
            public void run() {
                File file;
                String string = AbstractClientContext.this.getBaseDirectory() + File.separatorChar + AbstractClientContext.CLIENT_RUNNING_FILENAME_PREFIX;
                int n2 = 0;
                String string2 = string;
                while ((file = new File(string2)).exists()) {
                    string2 = string + "_" + ++n2;
                }
                try {
                    file.createNewFile();
                    file.deleteOnExit();
                }
                catch (IOException iOException) {
                    return;
                }
                while (true) {
                    file.setLastModified(System.currentTimeMillis());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
        });
        this.assignCommandlineArguments(stringArray);
        if (this.configpath == null) {
            this.configpath = Strings.ff("%s/%s", this.getProgramDirectory(), defaultClientConfigPath);
        }
        this.cfg = this.createPropertiesConfiguration(this.configpath);
        this.pdm = new PropertyDefinitionManager();
        this.pdm.addInternalDefinition(".Uuid", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".FirstRun", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".LastRun", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".RunCount", PropertyTypeInteger.createPositiveOrZero(0));
        this.pdm.addInternalDefinition(".LastVersionRun", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".EulaAccepted", PropertyTypeBoolean.create(false));
        this.pdm.addInternalDefinition(".LicenseKey", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".SupportExpired", PropertyTypeBoolean.create());
        this.pdm.addInternalDefinition(".PreferredLanguage", PropertyTypeString.create(""));
        this.pdm.addInternalDefinition(".DebugEnabled", PropertyTypeBoolean.create(false));
        this.pdm.addInternalDefinition(".CheckMOTD", PropertyTypeBoolean.create(true));
        this.pdm.addInternalDefinition(".LastMOTDId", PropertyTypeInteger.create());
        this.pdm.addInternalDefinition(".TelemetryReporting", PropertyTypeBoolean.create(true));
        this.pdm.addInternalDefinition(".LatestAvailableUpdate", PropertyTypeString.create());
        this.pdm.addInternalDefinition(".WriteUpdateToDiskOnlyIfValid", PropertyTypeBoolean.create(false));
        this.pdm.addInternalDefinition(".UploadErrorFiles", PropertyTypeBoolean.create(true));
        this.pdm.addInternalDefinition(".IncludeExtraDataInErrorLogs", PropertyTypeBoolean.create(Licensing.isDemoBuild()));
        this.pdm.addDefinition(".NetworkProxy", PropertyTypeString.create(), "Proxy settings for JEB front-end components. The format of this property is:\n'type|hostname|port|user|pass|whitelist'\n- type can be direct (no proxy), http, or socks\n- hostname and port are mandatory for non-direct proxy types\n- user and password are optional (needed only if your proxy requires authentication)\n- whitelist is an optional list of domains/IPs (with support for the wildcard character *) for which no proxy connection should be used (always direct connect)", 8);
        this.pdm.addDefinition(".CheckUpdates", PropertyTypeBoolean.create(true), "Let JEB automatically check for software updates (requires an Internet connection)");
        this.pdm.addDefinition(".UpdateChannel", PropertyTypeSelection.Builder.create().addEntry(0, "Release", "Release builds only").addEntry(1, "Beta", "Release and Beta builds").addEntry(2, "Alpha", "All builds (stable and unstable)").setDefault(Licensing.isDemoBuild() || Licensing.isDebugBuild() ? 2 : app_ver.getChannel()).build(), "Channel from which software updates are pulled from");
        this.pdm.addDefinition(".UploadErrorLogs", PropertyTypeBoolean.create(true), "Securely upload error logs to PNF Software error server");
        this.pdm.addDefinition(".DevelopmentMode", PropertyTypeBoolean.create(false), "Recommended when developing JEB extensions (scripts, plugins). Increase logger levels separately via the `LogLevel` property.");
        this.pdm.addDefinition(".LogLevel", PropertyTypeSelection.Builder.create().addEntry(0, "ALL", null).addEntry(10, "TRACE", null).addEntry(20, "DEBUG", null).addEntry(30, "INFO", null).addEntry(40, "WARN", null).addEntry(50, "ERROR", null).addEntry(60, "CATCHING", null).setDefault(GlobalLog.STANDARD_CUTOFF_LEVEL).build(), "Set the global cutoff level for loggers, which will control what gets output in the 'Logger' view.\nIf `DevelopmentMode` is enabled, this value is disregarded and assumed to be ALL (log everything).", 8);
        object2 = new File(this.getBaseDirectory(), defaultScriptsFolderName).getAbsolutePath();
        this.pdm.addDefinition(".ScriptsFolder", PropertyTypePath.create((String)object2), "Folder containing JEB client scripts written in Python", 8);
        this.pm = new PropertyManager(this.pdm, new CommonsConfigurationWrapper((Configuration)this.cfg));
        this.pm.addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent iEvent) {
                if (iEvent instanceof JebEvent && iEvent.getType() == J.PropertyChange && iEvent.getData() instanceof PropertyChangeNotification) {
                    String string;
                    PropertyChangeNotification propertyChangeNotification = (PropertyChangeNotification)iEvent.getData();
                    if (propertyChangeNotification.has(".NetworkProxy")) {
                        string = AbstractClientContext.this.getProxyString();
                        try {
                            Net.setGlobalProxyInformation(NetProxyInfo.parse(string));
                        }
                        catch (Exception exception) {
                            logger.catching(exception);
                        }
                    }
                    if (propertyChangeNotification.has(".LogLevel")) {
                        AbstractClientContext.this.checkLogLevel();
                    }
                    if (propertyChangeNotification.has(".DevelopmentMode")) {
                        string = "The property .DevelopmentMode was modified.\n\nPlease restart JEB to apply this change.";
                        logger.info(string, new Object[0]);
                    }
                }
            }
        });
        long l2 = this.getUuid();
        if (l2 == 0L) {
            object = new SecureRandom();
            l2 = ((Random)object).nextLong() & Long.MAX_VALUE;
            this.pm.setString(".Uuid", Long.toString(l2));
        }
        this.checkLogLevel();
        if (this.isDevelopmentMode()) {
            logger.info("Development mode is ON", new Object[0]);
        }
        net = AbstractClientContext.initNetworkUtility(this.getProxyString());
        pinger = new jC(net);
        object = this.getPreferredLanguage();
        if (object != null && !((String)object).isEmpty()) {
            S.setLanguage((String)object);
        }
        logger.trace("Current language: %s (default: %s)", S.getLanguage(), S.getDefaultLanguage());
        if (this.teledbpath == null) {
            this.teledbpath = Strings.ff("%s/%s", this.getProgramDirectory(), defaultTelemetryDatabasePath);
        }
        if (!Licensing.isDebugBuild() && this.pm.getBoolean(".TelemetryReporting")) {
            try {
                StandardTelemetryDatabase standardTelemetryDatabase = new StandardTelemetryDatabase(this.teledbpath, new StandardTelemetryEndpoint(net, l2));
                standardTelemetryDatabase.startDumperThread();
                this.teledb = standardTelemetryDatabase;
            }
            catch (Exception exception) {
                this.teledb = new MootTelemetryDatabase();
                logger.catchingSilent(exception);
            }
        } else {
            this.teledb = new MootTelemetryDatabase();
        }
        this.coreOptions.setDevelopmentMode(this.isDevelopmentMode());
        this.coreOptions.setStandardProxyInfo(NetProxyInfo.parse(this.getProxyString()));
        this.coreOptions.setJebClassesLocation(this.getJebClassesLocation());
    }

    private boolean checkLogLevel() {
        int n2 = this.getLogLevel();
        GlobalLog.setCutoffLevel(n2);
        return true;
    }

    public void start() throws JebException {
        CharSequence charSequence;
        logger.info("%s %s (%s) is starting...", "JEB", app_ver.toString(), Licensing.buildkey);
        logger.info("%s: %s", S.s(226), this.getCurrentDirectory());
        logger.info("%s: %s", S.s(98), this.getBaseDirectory());
        logger.debug("%s: %s", S.s(654), this.getProgramDirectory());
        logger.info("System: %s %s (%s) %s", SystemInformation.osname, SystemInformation.osversion, SystemInformation.osarch, SystemInformation.localeinfo);
        logger.info("Java: %s %s", SystemInformation.javavendor, SystemInformation.javaversion);
        this.logMemoryUsage();
        Version version = Version.parseFromString(this.pm.getString(".LastVersionRun"));
        if (!this.pm.getBoolean(".EulaAccepted")) {
            charSequence = Licensing.getLicense();
            if (!this.displayEula((String)charSequence)) {
                logger.info(S.s(315), new Object[0]);
                this.pm.setBoolean(".EulaAccepted", false);
                AbstractClientContext.terminate();
            }
            this.pm.setBoolean(".EulaAccepted", true);
        }
        if (this.pm.getInteger(".FirstRun") == 0) {
            this.pm.setInteger(".FirstRun", this.getStartTimestamp());
        }
        this.pm.setInteger(".LastRun", this.getStartTimestamp());
        this.pm.setInteger(".RunCount", this.pm.getInteger(".RunCount") + 1);
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("This software is a limited demonstration build of JEB.\n\n");
        ((StringBuilder)charSequence).append("Limitations of the demo version include:\n");
        ((StringBuilder)charSequence).append("- Decompilation is limited to a subset of code\n");
        ((StringBuilder)charSequence).append("- Android: Generic string decryption via emulation is limited\n");
        ((StringBuilder)charSequence).append("- Saving or loading projects is disabled\n");
        ((StringBuilder)charSequence).append("- Usage of the clipboard is disallowed\n");
        ((StringBuilder)charSequence).append("- Running time of a session is limited\n");
        if (!Licensing.isAirgapBuild()) {
            ((StringBuilder)charSequence).append("- Requires the Internet connection\n");
        }
        if (!Licensing.canUseCoreAPI()) {
            ((StringBuilder)charSequence).append("- Usage of third-party back-end plugins is disabled\n");
        }
        if (!Licensing.allowAnyClient()) {
            ((StringBuilder)charSequence).append("- Usage of third-party clients is disabled\n");
        }
        this.displayDemoInformation(((StringBuilder)charSequence).toString());
        this.pm.setBoolean(".CheckUpdates", true);
        this.pm.setBoolean(".UploadErrorLogs", true);
        if (version == null || version.compareTo(app_ver) < 0) {
            this.just_updated = true;
            String string = Strings.decodeUTF8(AssetManager.ce("CHANGELIST.TXT"));
            this.onUpdatedSoftware(string, version);
        } else if (this.integrity_failed) {
            this.pm.setBoolean(".CheckUpdates", true);
        }
        this.pm.setString(".LastVersionRun", app_ver.toString());
        boolean bl = this instanceof Hl;
        boolean bl2 = Licensing.isFloatingBuild();
        if (bl && !bl2) {
            throw new RuntimeException();
        }
        this.prepareCheckLicenseKey();
        if (this.integrity_failed) {
            AbstractClientContext.terminate();
        }
        String string = this.pm.getString(".LicenseKey");
        this.corectx = JebCoreService.getInstance(string, this.coreOptions);
        this.shouldInitEngines = !bl;
        this.basicChecksPassed = true;
    }

    public void stop() {
        try {
            if (this.teledb != null) {
                this.teledb.close();
            }
        }
        catch (TelemetryException telemetryException) {
            logger.catchingSilent(telemetryException);
        }
        try {
            if (this.corectx != null) {
                this.corectx.close();
            }
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
        }
    }

    protected void assignCommandlineArguments(String[] stringArray) {
        for (String string : stringArray) {
            (new Object[1])[0] = string;
        }
        int n2 = 0;
        for (String string : stringArray) {
            if (string.equals("--")) {
                ++n2;
                break;
            }
            if (!string.startsWith("-")) break;
            if (string.startsWith("--config=")) {
                this.configpath = string.substring(string.indexOf(61) + 1);
            } else if (string.startsWith("--engconfig=")) {
                this.engconfigpath = string.substring(string.indexOf(61) + 1);
            } else if (string.startsWith("--cd=")) {
                String string2 = string.substring(string.indexOf(61) + 1);
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                SystemInformation.setCurrentDirectory(string2);
            } else if (string.startsWith("--script=")) {
                this.scriptpath = string.substring(string.indexOf(61) + 1);
            }
            ++n2;
        }
        this.args = new String[stringArray.length - n2];
        for (int i = n2; i < stringArray.length; ++i) {
            this.args[i - n2] = stringArray[i];
        }
        if (this.args.length > 0) {
            this.inputpath = this.args[0];
        }
    }

    private PropertiesConfiguration createPropertiesConfiguration(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Cannot create JEB properties file: " + file, iOException);
            }
        }
        Parameters parameters = new Parameters();
        FileBasedConfigurationBuilder fileBasedConfigurationBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)parameters.properties().setFileName(string)});
        fileBasedConfigurationBuilder.setAutoSave(true);
        try {
            return (PropertiesConfiguration)fileBasedConfigurationBuilder.getConfiguration();
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
    }

    @Override
    public String[] getArguments() {
        return this.args;
    }

    public String getInputpath() {
        return this.inputpath;
    }

    public String getScriptpath() {
        return this.scriptpath;
    }

    public Net getNetworkUtility() {
        return net;
    }

    public IPropertyDefinitionManager getPropertyDefinitionManager() {
        return this.pdm;
    }

    public IPropertyManager getPropertyManager() {
        return this.pm;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    jC getPinger() {
        return pinger;
    }

    public ITelemetryDatabase getTelemetry() {
        return this.teledb;
    }

    public boolean isDevelopmentMode() {
        return this.pm.getBoolean(".DevelopmentMode");
    }

    public void setDevelopmentMode(boolean bl) {
        this.pm.setBoolean(".DevelopmentMode", bl);
    }

    public int getLogLevel() {
        return this.pm.getInteger(".LogLevel");
    }

    public void setLogLevel(int n2) {
        this.pm.setInteger(".LogLevel", n2);
    }

    public final long getUuid() {
        try {
            return Long.parseLong(this.pm.getString(".Uuid"));
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public final String getPreferredLanguage() {
        return this.pm.getString(".PreferredLanguage");
    }

    public final void setPreferredLanguage(String string) {
        this.pm.setString(".PreferredLanguage", string);
    }

    public final boolean shouldCheckUpdates() {
        return !Licensing.isDebugBuild() && (Licensing.isDemoBuild() || this.pm.getBoolean(".CheckUpdates"));
    }

    public final int getUpdateChannel() {
        return this.pm.getInteger(".UpdateChannel");
    }

    public final void setUpdateChannel(int n2) {
        this.pm.setInteger(".UpdateChannel", n2);
    }

    public final Version getLatestAvailableUpdate() {
        return Version.parseFromString(this.pm.getString(".LatestAvailableUpdate"));
    }

    public final void setLatestAvailableUpdate(Version version) {
        this.pm.setString(".LatestAvailableUpdate", version.toString());
    }

    public final boolean shouldCheckPublicAnnouncements() {
        return !Licensing.isDebugBuild() && (Licensing.isDemoBuild() || this.pm.getBoolean(".CheckMOTD"));
    }

    public final String getProxyString() {
        return this.pm.getString(".NetworkProxy");
    }

    public final void setProxyString(String string) {
        this.pm.setString(".NetworkProxy", string);
    }

    public final int getLastPublicAnnouncementId() {
        return this.pm.getInteger(".LastMOTDId");
    }

    public final void setLastPublicAnnouncementId(int n2) {
        this.pm.setInteger(".LastMOTDId", n2);
    }

    public boolean isHeadless() {
        return true;
    }

    public abstract boolean checkUpdate();

    public abstract boolean displayEula(String var1);

    public abstract void displayDemoInformation(String var1);

    public abstract void onUpdatedSoftware(String var1, Version var2);

    public abstract String retrieveLicenseKey(String var1);

    public abstract void notifySupportExpired();

    public abstract boolean setupController();

    public abstract void notifyFloatingClient(ControllerNotification var1);

    private void prepareCheckLicenseKey() {
        mo.ce();
        String string = this.pm.getString(".LicenseKey");
        int[] nArray = new int[1];
        boolean bl = false;
        if (!Strings.isBlank(string)) {
            long[] lArray;
            for (long l2 : lArray = UB.fz()) {
                nM nM2 = new nM(l2);
                if (!nM2.ce(string, nArray)) continue;
                bl = true;
                break;
            }
            this.ugerrstr = UB.Rs();
        }
        if (!bl) {
            mo.mm();
            long l3 = UB.mm();
            nM nM3 = new nM(l3);
            String string2 = nM3.ce();
            string = this.retrieveLicenseKey(string2);
            mo.ce();
            if (!nM3.ce(string, nArray)) {
                logger.info(S.s(437), new Object[0]);
                AbstractClientContext.terminate();
            }
            this.pm.setString(".LicenseKey", string.trim());
        }
        Licensing.setLicenseTimestamp(nArray[0]);
        int n2 = Licensing.getExpirationTimestamp();
        if (n2 != 0) {
            if (n2 < 0 || this.getStartTimestamp() >= n2) {
                this.pm.setBoolean(".SupportExpired", true);
                this.notifySupportExpired();
            } else if (this.pm.getBoolean(".SupportExpired")) {
                this.pm.setBoolean(".SupportExpired", false);
            }
        }
    }

    public static final String generateLicenseInformation() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        Strings.ff(stringBuilder, "JEB %s", app_ver);
        if (!Licensing.isCommonBuild()) {
            Strings.ff(stringBuilder, "\n", new Object[0]);
            Strings.ff(stringBuilder, S.s(434), Strings.ff("%s (%s)", Licensing.user_name, Licensing.user_group));
            Strings.ff(stringBuilder, "\n%s: %s", S.s(286), Licensing.user_email);
        }
        Strings.ff(stringBuilder, "\n%s: %d\n%s: %d", S.s(812), Licensing.user_id, S.s(435), Licensing.license_id);
        int n3 = Licensing.user_count;
        if (n3 >= 1) {
            String string = PluralFormatter.countS(n3, Licensing.isFloatingBuild() ? "floating seat" : "user");
            Strings.ff(stringBuilder, "\nValid for %d %s", n3, string);
        }
        Strings.ff(stringBuilder, "\n%s: %s\n(%s)", S.s(103), Licensing.buildkey, Licensing.getBuildTypeString());
        if ((Licensing.isSubscription() || !Licensing.isFree()) && (n2 = Licensing.getExpirationTimestamp()) > 0) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.setTime(new Date(1000L * (long)n2));
            String string = Strings.ff("%04d-%02d-%02d", calendar.get(1), 1 + calendar.get(2), calendar.get(5));
            if (Licensing.isSubscription()) {
                Strings.ff(stringBuilder, "\n%s: %s", S.s(758), string);
            } else {
                Strings.ff(stringBuilder, "\nReceiving updates until: %s", string);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int ping(int n2, int n3, SoftwareBuildInfo softwareBuildInfo, IProgressCallback iProgressCallback, boolean bl) {
        Object object;
        File file;
        boolean bl2;
        byte[] byArray;
        Kh kh;
        if (bl) {
            logger.info(S.s(797), new Object[0]);
        }
        if ((kh = pinger.ce(n3)) == null) {
            Object object2 = S.s(803);
            boolean bl3 = Net.isConnectedToInternet();
            if (!bl3) {
                object2 = (String)object2 + " (no internet?)";
            }
            logger.error((String)object2, new Object[0]);
            return -1;
        }
        Version version = kh.fz().ce();
        int n4 = kh.fz().mm();
        int n5 = kh.fz().mH();
        if (softwareBuildInfo != null) {
            softwareBuildInfo.setVersion(version);
            softwareBuildInfo.setChannel(n4);
            softwareBuildInfo.setFlags(n5);
        }
        if ((n5 & 1) != 0) {
            if (!bl) return 0;
            logger.info("JEB %d is available. This major update needs to be installed separately. Please check your registered email for download details.", version.getMajor());
            if (Strings.isBlank(kh.fz().fz())) return 0;
            Object object3 = String.format("Alternatively, you may download that update manually here: %s", kh.fz().fz());
            if (!Strings.isBlank(kh.fz().ok())) {
                object3 = (String)object3 + String.format(" (installation password: %s)", kh.fz().ok());
            }
            logger.info((String)object3, new Object[0]);
            return 0;
        }
        if (version.compareTo(app_ver) == 0) {
            if (!bl) return 0;
            logger.info(S.s(808), new Object[0]);
            return 0;
        }
        if (version.compareTo(app_ver) < 0) {
            if (!bl) return 0;
            logger.info("It looks like your version of JEB is more recent than the latest available build on your current channel.\nDowngrading must be done manually.", new Object[0]);
            return 0;
        }
        if (n4 > n3) {
            if (!bl) return 0;
            logger.info("A software update is available on the %s channel!\nYou currently accept updates on the %s channel%s. If you wish to install the update, update your client settings.", Version.getChannelName(n4), Version.getChannelName(n3), n3 == 0 ? "" : " and above");
            return 0;
        }
        if (n2 == 0) {
            logger.warn(S.s(806), new Object[0]);
            return 1;
        }
        if (n2 == 1 && app_ver.getMajor() < version.getMajor()) {
            return 3;
        }
        File file4 = new File(this.getBaseDirectory(), UPDATE_FILENAME);
        if (file4.exists()) {
            try {
                byArray = IO.readFile(file4);
                if (Arrays.equals(kh.fz().Rs(), Hash.calculateSHA256(byArray))) {
                    logger.info(S.s(804), new Object[0]);
                    return 2;
                }
            }
            catch (IOException iOException) {}
        }
        if (bl2 = this.pm.getBoolean(".WriteUpdateToDiskOnlyIfValid")) {
            logger.info(S.s(802), version);
            try {
                byArray = net.queryBinary(kh.fz().fz(), null, null, iProgressCallback);
            }
            catch (IOException iOException) {
                logger.catching(iOException, S.s(801));
                return -2;
            }
            if (!Arrays.equals(kh.fz().Rs(), Hash.calculateSHA256(byArray))) {
                logger.error(S.s(799), new Object[0]);
                if (!this.pm.getBoolean(".DebugEnabled")) return -2;
                try {
                    IO.writeFile(file4, byArray, false);
                    return -2;
                }
                catch (IOException iOException) {
                    logger.catching(iOException);
                }
                return -2;
            }
            String string = kh.fz().ok();
            try {
                this.dumpUpdateToDisk(byArray, string);
            }
            catch (Exception exception) {
                logger.error(S.s(800), new Object[0]);
                return -2;
            }
        }
        File file3 = new File(this.getBaseDirectory(), UPDATE_FILENAME);
        File file2 = new File(this.getBaseDirectory(), UPDATE_PASS_FILENAME);
        logger.info(S.s(802), version);
        try {
            file = File.createTempFile("jeb-update-", ".zip");
            file.setReadable(true);
            file.setWritable(true);
            net.downloadBinary(file, kh.fz().fz(), null, null, iProgressCallback);
        }
        catch (IOException iOException) {
            logger.catching(iOException, S.s(801));
            return -2;
        }
        try {
            object = new FileInputStream(file);
            try {
                if (!Arrays.equals(kh.fz().Rs(), HashCalculator.sha256((InputStream)object))) {
                    logger.error(S.s(799), new Object[0]);
                    int n6 = -2;
                    return n6;
                }
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            logger.catching(iOException, "Cannot read the update archive %s", file);
            return -2;
        }
        if (file3.exists() && !IO.deleteFile(file3)) {
            logger.error("Update attempt may fail as an older software archive cannot be removed: %s", file3);
        }
        if (!file.renameTo(file3)) {
            try {
                Files.move(file.toPath(), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                logger.catching(iOException, "Unable to move %s to %s", file, file3);
                try {
                    Files.copy(file.toPath(), file3.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException2) {
                    logger.catching(iOException2, "Unable to copy %s to %s", file, file3);
                    logger.error("Cannot drop JEB update in base folder", new Object[0]);
                    return -2;
                }
            }
        }
        try {
            object = kh.fz().ok();
            if (object != null && ((String)object).length() > 0) {
                IO.writeFile(file2, Strings.encodeUTF8((String)object), false);
            }
        }
        catch (Exception exception) {
            logger.catching(exception, S.s(800));
            return -2;
        }
        logger.info(S.s(807), new Object[0]);
        return 2;
    }

    public final void dumpUpdateToDisk(byte[] byArray, String string) throws IOException {
        IO.writeFile(new File(this.getBaseDirectory(), UPDATE_FILENAME), byArray, false);
        if (string != null && string.length() > 0) {
            IO.writeFile(new File(this.getBaseDirectory(), UPDATE_PASS_FILENAME), Strings.encodeUTF8(string), false);
        }
    }

    public final PublicAnnouncement retrieveLatestPublicAnnouncement() {
        byte[] byArray;
        try {
            byArray = net.queryBinary("https://www.pnfsoftware.com/jeb/motd");
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
        try {
            return PublicAnnouncement.parse(Strings.decodeUTF8(byArray));
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return null;
        }
    }

    public final String getScriptsDirectory() {
        String string = this.pm.getString(".ScriptsFolder");
        if (string == null) {
            string = new File(this.getBaseDirectory(), defaultScriptsFolderName).getAbsolutePath();
        }
        return string;
    }

    public final File getScriptsDirfile() {
        String string = this.getScriptsDirectory();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Illegal script directory: %s" + file);
        }
        return file;
    }

    public final void setScriptsDirectory(String string) {
        this.pm.setString(".ScriptsFolder", string);
    }

    @Override
    public long getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    @Override
    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Override
    public long getProcessId() {
        return ProcessHandle.current().pid();
    }

    public final void logMemoryUsage() {
        logger.info("%s", AbstractClientContext.formatMemoryUsage());
    }

    public static String formatMemoryUsage() {
        return AbstractClientContext.formatProcessInfo(false, true, false, false);
    }

    public static String formatProcessInfo(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Optional<Object> optional;
        Object object;
        Object object2 = "";
        ProcessHandle processHandle = ProcessHandle.current();
        ProcessHandle.Info info = processHandle.info();
        if (bl) {
            object = "N/A";
            optional = info.user();
            if (optional.isPresent()) {
                object = optional.get();
            }
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + "\n";
            }
            object2 = (String)object2 + Strings.ff("Process ID: %d (User: %s)", processHandle.pid(), object);
        }
        if (bl2) {
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + "\n";
            }
            object = Runtime.getRuntime();
            long l2 = ((Runtime)object).maxMemory();
            long l3 = ((Runtime)object).totalMemory();
            long l4 = ((Runtime)object).freeMemory();
            long l5 = l3 - l4;
            object2 = (String)object2 + Strings.ff("%s: %s used (%s free, %s max)", S.s(456), SizeFormatter.formatByteSize(l5), SizeFormatter.formatByteSize(l4), SizeFormatter.formatByteSize(l2));
        }
        if (bl3) {
            object = "N/A";
            optional = info.totalCpuDuration();
            if (optional.isPresent()) {
                long l6 = ((Duration)optional.get()).getSeconds() * 1000L;
                object = TimeFormatter.formatTimestampDelta(l6);
            }
            String string = "N/A";
            Optional<Instant> optional2 = info.startInstant();
            if (optional2.isPresent()) {
                long l7 = optional2.get().getEpochSecond() * 1000L;
                string = TimeFormatter.formatTimestampLocal(l7);
            }
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + "\n";
            }
            object2 = (String)object2 + Strings.ff("Start time: %s (CPU time: %s)", string, object);
        }
        if (bl4) {
            object = "N/A";
            optional = info.commandLine();
            if (optional.isPresent()) {
                object = (String)optional.get();
            }
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + "\n";
            }
            object2 = (String)object2 + Strings.ff("Command-line: %s", object);
        }
        return object2;
    }

    protected final void initializeEngines() throws JebException {
        if (!this.shouldInitEngines) {
            return;
        }
        long l2 = System.currentTimeMillis();
        String string = this.getBaseDirectory();
        SimpleFSFileStore simpleFSFileStore = new SimpleFSFileStore(string);
        SimpleFSFileStore simpleFSFileStore2 = new SimpleFSFileStore(string + File.separator + defaultPluginsFolderName);
        JDB2Manager jDB2Manager = new JDB2Manager(string);
        if (this.engconfigpath == null) {
            this.engconfigpath = this.getProgramDirectory() + File.separator + defaultEnginesConfigPath;
        }
        PropertiesConfiguration propertiesConfiguration = this.createPropertiesConfiguration(this.engconfigpath);
        CommonsConfigurationWrapper commonsConfigurationWrapper = new CommonsConfigurationWrapper((Configuration)propertiesConfiguration);
        DataProvider dataProvider = new DataProvider(null, jDB2Manager, simpleFSFileStore, simpleFSFileStore2, null, commonsConfigurationWrapper);
        JebClientInformation jebClientInformation = new JebClientInformation(csv.ce(new byte[]{81, 30, 8, 102, 115, 60, 9, 18, 3, 22, 19, 23, 69, 13, 13, 106, 15, 7, 98, 111, 41, 0, 15, 10, 10, 8, 13, 76, 99, 47, 5, 12, 11, 26}, 1, 1));
        this.engctx = this.corectx.createEnginesContext(dataProvider, jebClientInformation);
        long l3 = System.currentTimeMillis() - l2;
        logger.debug("Engines initialization took %d ms", l3);
    }

    public final ICoreContext getCoreContext() {
        return this.corectx;
    }

    @Override
    public final IEnginesContext getEnginesContext() {
        return this.engctx;
    }

    public final boolean hasOpenedProject() {
        return this.getOpenedProject() != null;
    }

    public final IRuntimeProject getOpenedProject() {
        IEnginesContext iEnginesContext = this.getEnginesContext();
        if (iEnginesContext == null || CollectionUtils.isEmpty(iEnginesContext.getProjects())) {
            return null;
        }
        return iEnginesContext.getProjects().get(0);
    }

    public final boolean closeOpenedProject() {
        IRuntimeProject iRuntimeProject = this.getOpenedProject();
        if (iRuntimeProject == null) {
            return false;
        }
        return this.getEnginesContext().unloadProject(iRuntimeProject.getKey());
    }

    @Override
    public IRuntimeProject getMainProject() {
        return this.getOpenedProject();
    }

    @Override
    public boolean closeMainProject() {
        return this.closeOpenedProject();
    }

    @Override
    public IUnit open(String string) throws IOException {
        File file = new File(string);
        if (file.getName().endsWith(".jdb2")) {
            if (this.hasOpenedProject()) {
                throw new IllegalStateException("A project is already loaded");
            }
            IRuntimeProject iRuntimeProject = this.engctx.loadProject(file.getAbsolutePath());
            return iRuntimeProject.getLiveArtifact(0).getMainUnit();
        }
        IRuntimeProject iRuntimeProject = this.getMainProject();
        if (iRuntimeProject == null) {
            iRuntimeProject = this.engctx.loadProject(file.getName());
        }
        Artifact artifact = new Artifact(file.getName(), new FileInput(file));
        return iRuntimeProject.processArtifact(artifact).getMainUnit();
    }

    @Override
    public Map<Object, Object> getTransientStore() {
        return this.transientStore;
    }

    public String getControllerInterface() {
        return this.pm.getString(".ControllerInterface");
    }

    public void setControllerInterface(String string) {
        this.pm.setString(".ControllerInterface", string);
    }

    public int getControllerPort() {
        return this.pm.getInteger(".ControllerPort");
    }

    public void setControllerPort(int n2) {
        this.pm.setInteger(".ControllerPort", n2);
    }

    public int getControllerProtocol() {
        return this.pm.getInteger(".ControllerProtocol");
    }

    public void setControllerProtocol(int n2) {
        this.pm.setInteger(".ControllerProtocol", n2);
    }

    public String getControllerMessage() {
        return this.pm.getString(".ControllerMessage");
    }

    private InetSocketAddress getFloatingControllerAddress() {
        if (this.getControllerInterface().isEmpty() && !this.setupController()) {
            logger.info(S.s(398), new Object[0]);
            AbstractClientContext.terminate();
        }
        return new InetSocketAddress(this.getControllerInterface(), this.getControllerPort());
    }
}

