/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.Formatter;
import com.pnfsoftware.jeb.installer.Logger;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Util {
    public static String getCurrentJarDirectory() {
        try {
            File prg = new File(Util.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (prg.isFile() && prg.getName().endsWith(".jar")) {
                return prg.getParent();
            }
        }
        catch (Exception e) {
            Logger.logd(e);
        }
        System.err.println("Cannot retrieve the directory containing the JEB Installer");
        return null;
    }

    public static byte[] calculateSHA256(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSHA256Hexdigest(byte[] data) {
        return Formatter.byteArrayToHexString(Util.calculateSHA256(data)).toLowerCase();
    }
}

