/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.Logger;

public enum OSType {
    UNKNOWN(null),
    LINUX32("lin32"),
    OSX32("osx32"),
    WIN32("win32"),
    LINUX64("lin64"),
    OSX64("osx64"),
    WIN64("win64"),
    LINUX_ARM64("lin_arm64"),
    OSX_ARM64("osx_arm64"),
    WIN_ARM64("win_arm64");

    private final String foldername;

    private OSType(String foldername) {
        this.foldername = foldername;
    }

    public String getFolderName() {
        return this.foldername;
    }

    public static OSType determine() {
        boolean arm;
        String osarch = System.getProperty("os.arch", "");
        String osname = System.getProperty("os.name", "");
        boolean is64 = osarch.contains("64");
        boolean bl = arm = osarch.contains("aarch") || osarch.contains("arm");
        if (osname.startsWith("Windows")) {
            if (is64) {
                return arm ? WIN_ARM64 : WIN64;
            }
            return WIN32;
        }
        if (osname.startsWith("Mac")) {
            if (is64) {
                return arm ? OSX_ARM64 : OSX64;
            }
            return OSX32;
        }
        if (osname.startsWith("Linux")) {
            if (is64) {
                return arm ? LINUX_ARM64 : LINUX64;
            }
            return LINUX32;
        }
        Logger.logd("Unknown VM/OS info: os.arch='%s' os.name='%s'", osarch, osname);
        return UNKNOWN;
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public boolean isWindows() {
        return this == WIN32 || this == WIN64 || this == WIN_ARM64;
    }

    public boolean isMac() {
        return this == OSX32 || this == OSX64 || this == OSX_ARM64;
    }

    public boolean isLinux() {
        return this == LINUX32 || this == LINUX64 || this == LINUX_ARM64;
    }

    public boolean is32bit() {
        return this == WIN32 || this == OSX32 || this == LINUX32;
    }

    public boolean is64bit() {
        return this == WIN64 || this == OSX64 || this == LINUX64 || this == WIN_ARM64 || this == OSX_ARM64 || this == LINUX_ARM64;
    }
}

