/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    static boolean logToTempFolder;
    private static File logfile;
    private static DateFormat dateFormatter;

    private static void log(boolean visibleOnConsole, String format, Object ... params) {
        String s = Strings.ff(format, params);
        if (visibleOnConsole) {
            System.out.println(s);
        }
        if (logToTempFolder) {
            try {
                if (logfile == null) {
                    logfile = File.createTempFile("jebi-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "-", ".log");
                }
                s = Strings.ff("[%s] %s%n", dateFormatter.format(new Date()), s);
                Files.write(Paths.get(logfile.getAbsolutePath(), new String[0]), s.getBytes(Charset.defaultCharset()), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                System.err.println("Error: " + e);
            }
        }
    }

    public static void log(String format, Object ... params) {
        Logger.log(true, format, params);
    }

    public static void logd(String format, Object ... params) {
        Logger.log(false, format, params);
    }

    public static void logd(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        t.printStackTrace(out);
        Logger.logd("Exception: %s", ((Object)writer).toString());
    }

    static {
        dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }
}

