/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.InstallerContext;
import com.pnfsoftware.jeb.installer.Logger;
import com.pnfsoftware.jeb.installer.OSType;
import com.pnfsoftware.jeb.installer.ZipUnpacker;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class LibraryInstaller {
    String basedir;
    String prgdir;
    String appdir;
    InstallerContext ctx;
    boolean fullInstall;
    OSType ostype;

    public LibraryInstaller(String basedir, String prgdir, String appdir, InstallerContext ctx) {
        this.basedir = basedir;
        this.prgdir = prgdir;
        this.appdir = appdir;
        this.ctx = ctx;
        this.ostype = OSType.determine();
        if (!this.ostype.isKnown()) {
            throw new RuntimeException("Unsupported operating system");
        }
        if (!this.ostype.is64bit()) {
            throw new RuntimeException("Detected " + this.ostype + " - Support for non 64-bit environments was dropped with JEB3!");
        }
    }

    public void setFullInstall(boolean fullInstall) {
        this.fullInstall = fullInstall;
    }

    public boolean start() {
        boolean success = true;
        int retcode = this.dropPlatformSpecificComponent(true, this.appdir, ".swt", "swt.jar", false);
        if (retcode != 0) {
            Logger.log("Cannot install UI library (error code: %d)", retcode);
            success = false;
        }
        if ((retcode = this.dropPlatformSpecificComponent(false, this.prgdir, ".launchers", "launcher.zip", true)) < 0) {
            Logger.log("Cannot install launcher (error code: %d)", retcode);
            success = false;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int dropPlatformSpecificComponent(boolean mandatory, String outdir, String foldername, String filename, boolean unzip) {
        long size1;
        long size0;
        File file0 = new File(outdir, foldername + "/" + this.ostype.getFolderName() + "/" + filename);
        if (!file0.exists()) {
            Logger.logd("File not found: %s", file0);
            return 1;
        }
        File file1 = new File(outdir, filename);
        if (!this.fullInstall && file1.exists() && (size0 = file0.length()) == (size1 = file1.length())) {
            String relpath;
            boolean forceDrop = false;
            if (this.ctx != null && (relpath = this.ctx.relpath(file1)) != null && !this.ctx.getOriginalEntries().containsKey(relpath)) {
                forceDrop = true;
            }
            if (!forceDrop) {
                return 0;
            }
        }
        try {
            if (this.ctx != null) {
                this.ctx.copyFile(file0, file1);
            } else {
                IO.copyFile(file0, file1, true);
            }
        }
        catch (IOException e) {
            Logger.log("Failed to copy file %s to %s", file0, file1);
            Logger.logd(e);
            return -1;
        }
        if (!unzip) return 0;
        try (ZipFile zip = new ZipFile(file1);){
            if (new ZipUnpacker(zip, outdir, this.ctx).unzip()) return 0;
            int n = -2;
            return n;
        }
        catch (IOException e) {
            Logger.log("Exception when unzipping file %s", file1, e);
            Logger.logd(e);
            return -3;
        }
    }
}

