/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.IniFileEditor;
import com.pnfsoftware.jeb.installer.InstallerContext;
import com.pnfsoftware.jeb.installer.LibraryInstaller;
import com.pnfsoftware.jeb.installer.Logger;
import com.pnfsoftware.jeb.installer.OSType;
import com.pnfsoftware.jeb.installer.SoftwareUpdater;
import com.pnfsoftware.jeb.installer.Strings;
import com.pnfsoftware.jeb.installer.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Launcher {
    static String appdir;
    static String prgdir;
    static String basedir;
    static final String[] genOptions;
    static final String macosOpt1 = "-XstartOnFirstThread";
    static final String macosOpt2 = "-Dorg.eclipse.swt.internal.carbon.smallFonts";
    static final String[] macosOptions;

    static void usage() {
        System.out.println("JEB Installer & Runner (c) PNF Software, Inc.");
        System.out.println("Usage:");
        System.out.println("  java -jar jebi.jar [options] [-- JEB_options]");
        System.out.println("Options:");
        System.out.println("  --di           : install platform-specific client dependencies (UI libraries)");
        System.out.println("  --up           : install software update if one is found (update.zip, update.pwd)");
        System.out.println("  --start-client : start the JEB UI client after the installation task is done");
        System.out.println("  --force        : force a run attempt of the installer, even if another installer is already running");
        System.out.println("  --timeout=N    : wait at most N seconds for all JEB instances to terminate before attempting to run the installer (default: no timeout)");
        Launcher.exit(-2);
    }

    public static void main(String[] argv) {
        File file;
        if (argv.length <= 0) {
            Launcher.usage();
        }
        Logger.logToTempFolder = true;
        ArrayList<Integer> installOrders = new ArrayList<Integer>();
        Long waitTimeout = null;
        boolean forceRun = false;
        boolean startClient = false;
        boolean testing = false;
        boolean forceInstallSameOrOlderVersion = false;
        int jebOptPos = -1;
        int i = 0;
        for (String arg : argv) {
            if (arg.equals("--di")) {
                installOrders.add(0, 0);
            } else if (arg.equals("--up")) {
                installOrders.add(1);
            } else if (arg.startsWith("--timeout=")) {
                waitTimeout = 1000L * (long)Integer.parseInt(arg.substring(10));
            } else if (arg.equals("--force")) {
                forceRun = true;
            } else if (arg.equals("--start-client")) {
                startClient = true;
            } else if (arg.equals("--test")) {
                testing = true;
            } else if (arg.equals("--force-install")) {
                forceInstallSameOrOlderVersion = true;
            } else {
                if (arg.equals("--")) {
                    jebOptPos = i + 1;
                    break;
                }
                Logger.log("Error: invalid argument: \"%s\"", arg);
                Launcher.usage();
            }
            ++i;
        }
        if (startClient) {
            Logger.logd("The UI client will be started after the following orders are executed: %s", installOrders);
        }
        if ((appdir = testing ? new File(System.getProperty("user.dir"), "bin\\app").getAbsolutePath() : Util.getCurrentJarDirectory()) == null) {
            Logger.log("Cannot determine application directory", new Object[0]);
            Launcher.exit(0);
        }
        prgdir = new File(appdir).getParent();
        basedir = new File(prgdir).getParent();
        boolean headless = false;
        if (jebOptPos >= 0) {
            for (int j = jebOptPos; j < argv.length; ++j) {
                String arg = argv[j];
                if (!arg.equals("-c")) continue;
                headless = true;
            }
        }
        boolean updateJebCfg = false;
        if (!installOrders.isEmpty()) {
            long ts0 = System.currentTimeMillis();
            final File fu = new File(basedir, ".jebi_lock");
            try {
                if (!fu.createNewFile() && !forceRun && System.currentTimeMillis() - fu.lastModified() <= 3000L) {
                    Logger.log("The JEB installer is already running", new Object[0]);
                    installOrders.clear();
                } else {
                    fu.deleteOnExit();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                fu.setLastModified(System.currentTimeMillis());
                            } while (Launcher.sleep(1000L, false));
                        }
                    });
                    t.setDaemon(true);
                    t.start();
                    boolean proceed = Launcher.checkNoJebRunning(basedir, ts0, waitTimeout);
                    if (!proceed) {
                        Logger.logd("Timeout exceeded: client lock files remain, indicating that some JEB instances may still be running", new Object[0]);
                        if (new File(basedir, "update.zip").isFile()) {
                            Logger.log("An update was found but will not be installed until all instances of JEB are closed.", new Object[0]);
                        }
                    } else {
                        boolean doDepInstall = installOrders.contains(0) && !headless;
                        boolean doInstall = installOrders.contains(1) && SoftwareUpdater.needsUpdate(basedir);
                        InstallerContext ctx = new InstallerContext(basedir);
                        if (doDepInstall) {
                            LibraryInstaller libinst = new LibraryInstaller(basedir, prgdir, appdir, ctx);
                            libinst.setFullInstall(doInstall);
                            if (!libinst.start()) {
                                Logger.log("The JEB library installer reported errors", new Object[0]);
                                Launcher.exit(-1);
                            }
                            if (ctx.getChangeCount() > 0) {
                                ctx.merge();
                            }
                            updateJebCfg = true;
                        }
                        SoftwareUpdater updater = new SoftwareUpdater(basedir, prgdir, appdir, ctx);
                        if (doInstall) {
                            updater.setForceInstallSameOrOlderVersion(forceInstallSameOrOlderVersion);
                            if (!updater.start()) {
                                Logger.log("The JEB updater reported errors", new Object[0]);
                                Launcher.exit(-1);
                            }
                            if (ctx.getChangeCount() > 0) {
                                ctx.update();
                            }
                        } else {
                            updater.decryptMainJar();
                        }
                    }
                }
            }
            catch (IOException e) {
                Logger.log("The JEB installer reported errors: %s", e);
                Logger.logd(e);
                Launcher.exit(-1);
            }
        }
        List<String> jvmoptlist = Launcher.readJvmOptions(basedir, true);
        if (updateJebCfg) {
            try {
                IniFileEditor jebini = new IniFileEditor(Launcher.getJebIni(basedir));
                jebini.setSectionContents("JVMOptions", jvmoptlist);
                String javaBase = Launcher.getJavaBase();
                if (javaBase != null) {
                    jebini.setValue("Application", "app.runtime", javaBase);
                }
                jebini.update();
            }
            catch (Exception ex) {
                Logger.logd(ex);
            }
        }
        if (!(file = new File(appdir, "jeb.jar")).isFile()) {
            Logger.log("Warning! %s is missing. You will not be able to start JEB", file);
            Launcher.exit(-1);
        }
        if (startClient) {
            file = new File(appdir, "jebc.jar");
            if (!file.isFile()) {
                Logger.log("JEB cannot be launched! File is missing: %s", file);
                Launcher.exit(-1);
            }
            Logger.log("Starting JEB UI Client...", new Object[0]);
            ArrayList<String> command = new ArrayList<String>();
            String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            command.add(javaBin);
            command.addAll(jvmoptlist);
            command.add("-jar");
            command.add(appdir + File.separator + "jebc.jar");
            if (jebOptPos >= 0) {
                command.addAll(Arrays.asList(argv).subList(jebOptPos, argv.length));
            }
            File errorfile = new File(basedir, "launcher_errors.log");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.directory(new File(basedir));
            builder.redirectError(errorfile);
            Logger.log("Command: %s", Arrays.toString(command.toArray()));
            Logger.log("Errorlog: %s", errorfile);
            try {
                builder.start();
            }
            catch (IOException e) {
                Logger.log("The UI client could not be started: %s", e);
                Launcher.exit(-1);
            }
        }
        Launcher.exit(0);
    }

    static void exit(int code) {
        System.exit(code);
    }

    static List<String> readJvmOptions(String basedir, boolean addOSSpecificOptions) {
        ArrayList<String> jvmoptlist = new ArrayList<String>();
        try {
            File file = new File(basedir, "jvmopt.txt");
            if (file.isFile() && file.canRead()) {
                for (String line : Strings.splitLines(new String(IO.readFile(file), Charset.defaultCharset()))) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    for (String opt : line.split("\\s+")) {
                        if ((opt = opt.trim()).isEmpty()) continue;
                        jvmoptlist.add(opt);
                    }
                }
            }
            if (addOSSpecificOptions && OSType.determine().isMac()) {
                for (String opt : macosOptions) {
                    if (jvmoptlist.contains(opt)) continue;
                    jvmoptlist.add(opt);
                }
            }
            for (String opt : genOptions) {
                if (jvmoptlist.contains(opt)) continue;
                jvmoptlist.add(opt);
            }
        }
        catch (Exception ex) {
            Logger.logd(ex);
        }
        return jvmoptlist;
    }

    static File getJebIni(String basedir) {
        String path = "bin/app";
        if (OSType.determine().isMac()) {
            path = "bin/jeb.app/Contents/Java";
        }
        return new File(basedir, path + "/jeb.cfg");
    }

    static String getJavaBase() {
        String base = System.getProperty("java.home");
        if (base == null) {
            return null;
        }
        if (base.endsWith("/jre") || base.endsWith("\\jre")) {
            base = base.substring(0, base.length() - 4);
        }
        if (OSType.determine().isMac() && base.endsWith("/Contents/Home")) {
            base = base.substring(0, base.length() - 14);
        }
        return base;
    }

    private static boolean sleep(long millis, boolean terminateOnInterruption) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            if (terminateOnInterruption) {
                Launcher.exit(-1);
            }
            return false;
        }
        return true;
    }

    private static boolean checkNoJebRunning(String basedir, long ts0, Long waitTimeout) {
        int clearcnt;
        File dir = new File(basedir);
        do {
            clearcnt = 0;
            for (String name : dir.list()) {
                if (!name.startsWith(".jebc_ts")) continue;
                File fc = new File(dir, name);
                while (fc.exists()) {
                    long modTs = fc.lastModified();
                    if (modTs == 0L) {
                        fc.delete();
                        break;
                    }
                    long ts = System.currentTimeMillis();
                    long delta = ts - modTs;
                    if (delta >= 3000L) {
                        Launcher.sleep(1500L, true);
                        modTs = fc.lastModified();
                        if (modTs == 0L) {
                            fc.delete();
                            break;
                        }
                        ts = System.currentTimeMillis();
                        delta = ts - modTs;
                        if (delta >= 3000L) {
                            fc.delete();
                            break;
                        }
                    }
                    if (waitTimeout != null && ts - ts0 >= waitTimeout) {
                        return false;
                    }
                    Launcher.sleep(1000L, true);
                }
                ++clearcnt;
            }
        } while (clearcnt != 0);
        return true;
    }

    static {
        genOptions = new String[0];
        macosOptions = new String[]{macosOpt1, macosOpt2};
    }
}

