/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.IO;
import com.pnfsoftware.jeb.installer.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class InstallerContext {
    static final String FILELIST = "filelist.txt";
    private File base;
    private Map<String, String> blacklist = new HashMap<String, String>();
    private Map<String, Entry> entries0;
    private Map<String, Entry> entries = new TreeMap<String, Entry>();

    public InstallerContext(String basedir) throws IOException {
        if (basedir == null) {
            throw new IllegalArgumentException();
        }
        this.base = new File(basedir);
        if (!this.base.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.entries0 = this.load();
    }

    public void addToBlacklist(File file) {
        this.addToBlacklist(file, null);
    }

    public void addToBlacklist(File file, File optWriteFile) {
        String relpath = this.relpath(file);
        if (relpath != null) {
            String relpathDst = relpath;
            if (optWriteFile != null) {
                relpathDst = this.relpath(optWriteFile);
            }
            this.blacklist.put(relpath, relpathDst);
        }
    }

    public Map<String, Entry> getOriginalEntries() {
        return Collections.unmodifiableMap(this.entries0);
    }

    public Map<String, Entry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public int getChangeCount() {
        return this.entries.size();
    }

    public Map<String, Entry> load() throws IOException {
        TreeMap<String, Entry> entries = new TreeMap<String, Entry>();
        File file = new File(this.base, FILELIST);
        if (file.exists() && file.isFile() && file.canRead()) {
            List<String> lines = IO.readLines(file, Charset.forName("UTF-8"));
            for (String line : lines) {
                String[] elts;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (elts = line.split(",")).length != 3) continue;
                Entry e = new Entry(elts[0], Long.parseLong(elts[1]), elts[2]);
                entries.put(e.relpath, e);
            }
        }
        return entries;
    }

    public void dump(Map<String, Entry> entries) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Entry e : entries.values()) {
            sb.append(String.format("%s,%d,%s\n", e.relpath, e.filesize, e.sha256.toLowerCase()));
        }
        String s = sb.toString();
        File file = new File(this.base, FILELIST);
        IO.writeFile(file, s.getBytes("UTF-8"), false);
    }

    public void merge() throws IOException {
        this.merge(false);
    }

    public void merge(boolean clearEntries) throws IOException {
        if (this.entries.isEmpty()) {
            return;
        }
        this.entries0.putAll(this.entries);
        this.dump(this.entries0);
        if (clearEntries) {
            this.entries.clear();
        }
    }

    public void update() throws IOException {
        this.update(true, null);
    }

    public void update(boolean deleteStaleEntries, List<String> deletedRelpaths) throws IOException {
        this.dump(this.entries);
        if (deleteStaleEntries) {
            List<String> paths = IO.listFiles(this.base.getPath());
            for (String path : paths) {
                Entry e;
                File file = new File(path);
                String relpath = this.relpath(new File(path));
                if (this.entries.get(relpath) != null || (e = this.entries0.get(relpath)) == null) continue;
                boolean keep = false;
                if (file.length() != e.filesize) {
                    keep = true;
                } else {
                    String curhash = Util.getSHA256Hexdigest(IO.readFile(file));
                    if (!e.sha256.equals(curhash)) {
                        keep = true;
                    }
                }
                if (keep) continue;
                file.delete();
                if (deletedRelpaths == null) continue;
                deletedRelpaths.add(relpath);
            }
        }
    }

    public void copyFile(File src, File dst) throws IOException {
        byte[] data = IO.readFile(src);
        this.writeFile(dst, data);
    }

    public void writeFile(File file, byte[] data) throws IOException {
        String relpathDst;
        String relpath = this.relpath(file);
        if (relpath == null || relpath.equals(FILELIST)) {
            IO.writeFile(new File(this.base, relpath), data, true);
        }
        if ((relpathDst = this.blacklist.get(relpath)) != null) {
            IO.writeFile(new File(this.base, relpathDst), data, true);
            return;
        }
        String datahash = null;
        if (file.isFile()) {
            String curhash = null;
            if (file.length() == (long)data.length && (curhash = Util.getSHA256Hexdigest(IO.readFile(file))).equals(datahash = Util.getSHA256Hexdigest(data))) {
                this.addEntry(file, data, datahash);
                return;
            }
            boolean backup = false;
            Entry e = this.entries0.get(relpath);
            if (e == null) {
                backup = true;
            } else if (file.length() != e.filesize) {
                backup = true;
            } else {
                if (curhash == null) {
                    curhash = Util.getSHA256Hexdigest(IO.readFile(file));
                }
                if (!e.sha256.equals(curhash)) {
                    backup = true;
                }
            }
            if (backup) {
                IO.renameFile(file, new File(file.getPath() + ".bak"), 1);
            }
        }
        IO.writeFile(file, data, true);
        this.addEntry(file, data, datahash);
    }

    private void addEntry(File file, byte[] data, String sha256) throws IOException {
        String relpath = this.relpath(file);
        if (data == null) {
            data = IO.readFile(file);
        }
        if (sha256 == null) {
            sha256 = Util.getSHA256Hexdigest(data);
        }
        this.record(relpath, data.length, sha256);
    }

    private void record(String relpath, long filesize, String sha256) {
        Entry e = new Entry(relpath, filesize, sha256);
        this.entries.put(e.relpath, e);
    }

    public String relpath(File file) {
        try {
            return IO.getRelativePath(file, this.base).replace('\\', '/').trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void verifyEntries() {
        for (Entry e : this.entries.values()) {
            byte[] data;
            File file = new File(this.base, e.relpath);
            if (!file.isFile()) {
                throw new IllegalArgumentException("Bad entry: " + file);
            }
            if (file.length() != e.filesize) {
                throw new IllegalArgumentException("Bad entry: " + file);
            }
            try {
                data = IO.readFile(file);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Bad entry: " + file, ex);
            }
            if (Util.getSHA256Hexdigest(data).equals(e.sha256)) continue;
            throw new IllegalArgumentException("Bad entry: " + file);
        }
    }

    public static class Entry {
        String relpath;
        long filesize;
        String sha256;

        public Entry(String relpath, long filesize, String sha256) {
            if (relpath == null || relpath.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.relpath = relpath;
            this.filesize = filesize;
            this.sha256 = sha256.toLowerCase();
        }

        public String toString() {
            return this.relpath;
        }
    }
}

