/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.installer;

import com.pnfsoftware.jeb.installer.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IO {
    public static boolean isFile(String path) {
        File f = new File(path);
        return f.exists() && f.isFile();
    }

    public static boolean createDirectory(String path) {
        File f = new File(path);
        try {
            return f.mkdir();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean deleteDirectory(String path) {
        return IO.deleteDirectory(new File(path));
    }

    public static boolean deleteDirectory(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IO.deleteDirectory(f);
                    continue;
                }
                if (f.delete()) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(File file) {
        file.setWritable(true);
        return file.delete();
    }

    public static boolean renameFile(File src, File dst, int mode) {
        boolean success = src.renameTo(dst);
        if (success) {
            return true;
        }
        if (mode == 0 || !src.exists() || !dst.exists()) {
            return false;
        }
        if (mode == 1) {
            return IO.deleteFile(dst) && src.renameTo(dst);
        }
        if (mode == 2) {
            return IO.deleteFile(src);
        }
        throw new IllegalArgumentException();
    }

    public static List<String> listFiles(String path) {
        ArrayList<String> list = new ArrayList<String>();
        IO.listFilesRecurse(new File(path), list);
        return list;
    }

    private static void listFilesRecurse(File base, List<String> list) {
        if (base.isDirectory()) {
            for (String name : base.list()) {
                IO.listFilesRecurse(new File(base, name), list);
            }
        } else if (base.isFile()) {
            list.add(base.getAbsolutePath());
        }
    }

    public static File createTempFolder(String name) throws IOException {
        File f = File.createTempFile("jebgettemp", null);
        File folder = new File(f.getParent(), name);
        f.delete();
        folder.mkdir();
        return folder;
    }

    public static void deleteFolderOnExit(File dir) {
        dir.deleteOnExit();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IO.deleteFolderOnExit(f);
                    continue;
                }
                f.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data, boolean createDirs) throws IOException {
        File parent;
        if (createDirs && (parent = file.getAbsoluteFile().getParentFile()) != null) {
            parent.mkdirs();
        }
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new FileOutputStream(file));
            out.write(data);
        }
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        IO.writeFile(file, data, false);
    }

    public static boolean writeFileSafe(File file, byte[] data, boolean createDirs) {
        try {
            IO.writeFile(file, data, createDirs);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file, long maxAllowedSize) throws IOException {
        long size = file.length();
        if (maxAllowedSize >= 0L && size > maxAllowedSize) {
            throw new IOException();
        }
        try (FilterInputStream in = null;){
            in = new DataInputStream(new FileInputStream(file));
            byte[] data = new byte[(int)size];
            ((DataInputStream)in).readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    public static byte[] readFile(File file) throws IOException {
        return IO.readFile(file, -1L);
    }

    public static byte[] readFile(String path) throws IOException {
        return IO.readFile(new File(path), -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileSafe(File file) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            byte[] data = new byte[(int)file.length()];
            ((DataInputStream)in).readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((n = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, n);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isZIPFile(String path) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(new File(path)));
            boolean bl = in.read() == 80 && in.read() == 75 && in.read() == 3 && in.read() == 4;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressFolder(String folderPath, String zipfilePath) {
        File folder = new File(folderPath);
        if (!folder.isDirectory()) {
            return false;
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(new File(zipfilePath)));
            IO.compressFolderRecurse(out, folder, "/");
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void compressFolderRecurse(ZipOutputStream out, File base, String rpath) throws IOException {
        File f = new File(base, rpath);
        if (f.isFile()) {
            ZipEntry e = new ZipEntry(rpath);
            out.putNextEntry(e);
            byte[] data = IO.readFile(f.getAbsolutePath());
            out.write(data);
            out.closeEntry();
        } else if (f.isDirectory()) {
            for (String name : f.list()) {
                IO.compressFolderRecurse(out, base, new File(rpath, name).getPath());
            }
        }
    }

    public static void extractToFolder(File inputZipFile, File outputFolder) throws IOException {
        try (ZipFile zip = new ZipFile(inputZipFile);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                InputStream in = zip.getInputStream(entry);
                try {
                    byte[] data = IO.readInputStream(in);
                    File f = new File(outputFolder, entry.getName());
                    IO.writeFile(f, data, true);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    public static List<String> readLines(File file, Charset encoding) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            List<String> list = IO.readLines(in, encoding);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(InputStream input, Charset encoding) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = new InputStreamReader(input, encoding);
            br = new BufferedReader(isr);
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            } else if (isr != null) {
                isr.close();
            }
        }
    }

    public static void writeLines(File file, List<String> lines, Charset encoding) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            IO.writeLines(out, lines, encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(OutputStream output, List<String> lines, Charset encoding) throws IOException {
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(output, encoding);
            bw = new BufferedWriter(osw);
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            } else if (osw != null) {
                osw.close();
            }
        }
    }

    public static void copyFile(File src, File dst, boolean overwrite) throws IOException {
        if (!src.isFile()) {
            throw new FileNotFoundException("Source file not found: " + src);
        }
        if (dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        if (dst.exists() && !overwrite) {
            throw new FileAlreadyExistsException("Copy would overwrite an existing file: " + dst);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));){
            IO.copyStream(in, out, new byte[4096]);
        }
    }

    public static long copyStream(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String getRelativePath(File file, File base) throws IOException {
        String basename;
        String filename = file.getCanonicalPath();
        if (!filename.startsWith(basename = base.getCanonicalPath())) {
            return null;
        }
        String r = filename.substring(basename.length());
        r = Strings.ltrim(r, '/');
        r = Strings.ltrim(r, '\\');
        return r;
    }
}

