/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat;

import com.pnf.plugin.oat.KeyValueStoreDocument;
import com.pnf.plugin.oat.internal.DexFile;
import com.pnf.plugin.oat.internal.OATFile;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AbstractTransientUnitRepresentation;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractInteractiveBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.InputStream;

@Ser
public class OATUnit
extends AbstractInteractiveBinaryUnit {
    private static final ILogger logger = GlobalLog.getLogger(OATUnit.class);
    @SerId(value=1)
    private OATFile oat;

    public OATUnit(String name, IInput input, IUnitProcessor unitProcessor, IUnitCreator parent, IPropertyDefinitionManager pdm) {
        super(null, input, "OAT", name, unitProcessor, parent, pdm);
    }

    public boolean isProcessed() {
        return this.oat != null;
    }

    public boolean process() {
        if (this.isProcessed()) {
            return true;
        }
        try (InputStream stream = this.getInput().getStream();){
            byte[] data = IO.readInputStream((InputStream)stream);
            this.oat = new OATFile(data);
            for (DexFile dex : this.oat.getDexFiles()) {
                String loc = dex.getLocation();
                if (Strings.isBlank((CharSequence)loc)) continue;
                this.addChild(this.getUnitProcessor().process(loc, (IInput)new BytesInput(dex.getBytes(false)), (IUnitCreator)this));
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
            return false;
        }
        this.setProcessed(true);
        return true;
    }

    public String getDescription() {
        Object output = super.getDescription();
        output = (String)output + "\nOAT information:\n";
        output = (String)output + "- Version: " + this.oat.getVersion() + "\n";
        output = (String)output + "- Target ISA: " + this.oat.getISAString() + "\n";
        output = (String)output + "- Dex file count: " + this.oat.getDexFileCount() + "\n";
        output = (String)output + "- Dex paths:\n";
        for (DexFile dex : this.oat.getDexFiles()) {
            output = (String)output + "   - " + dex.getLocation() + "\n";
        }
        return output;
    }

    public IUnitFormatter getFormatter() {
        IUnitFormatter formatter = super.getFormatter();
        if (UnitFormatterUtil.getPresentationByIdentifier((IUnitFormatter)formatter, (long)1L) == null) {
            formatter.addPresentation((IUnitDocumentPresentation)new AbstractTransientUnitRepresentation(1L, "OAT KV-Store", true){

                public IGenericDocument createDocument() {
                    return new KeyValueStoreDocument(OATUnit.this.oat);
                }
            }, false);
        }
        return formatter;
    }
}

