/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat;

import com.pnf.plugin.oat.OATUnit;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import java.nio.ByteBuffer;

public class OATPlugin
extends AbstractUnitIdentifier {
    static final String TYPE = "OAT";

    public OATPlugin() {
        super(TYPE, 0.0);
    }

    public PluginInformation getPluginInformation() {
        return new PluginInformation("OAT File Unit", "Plugin to extract Dex files embedded in compiled OAT files that are generated by the ART", "PNF Software", Version.create((int)1, (int)0, (int)13));
    }

    public void initialize(IPropertyDefinitionManager parent) {
        super.initialize(parent);
    }

    public boolean canIdentify(IInput input, IUnitCreator parent) {
        ByteBuffer hdr = input.getHeader();
        if (hdr == null) {
            return false;
        }
        if (input.getCurrentSize() < 32L) {
            return false;
        }
        if (!OATPlugin.checkBytes((IInput)input, (int)0, (byte[])new byte[]{111, 97, 116, 10})) {
            return false;
        }
        if (hdr.get(7) != 0) {
            return false;
        }
        byte v1 = hdr.get(4);
        byte v2 = hdr.get(5);
        byte v3 = hdr.get(6);
        return v1 >= 48 && v1 <= 57 && v2 >= 48 && v2 <= 57 && v3 >= 48 && v3 <= 57;
    }

    public IUnit prepare(String name, IInput input, IUnitProcessor unitProcessor, IUnitCreator parent) {
        OATUnit unit = new OATUnit(name, input, unitProcessor, parent, this.pdm);
        return unit;
    }
}

