/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.oat;

import com.pnf.plugin.oat.KeyValueStoreDocumentPart;
import com.pnf.plugin.oat.internal.OATFile;
import com.pnfsoftware.jeb.core.events.JebEventSource;
import com.pnfsoftware.jeb.core.output.table.ICellCoordinates;
import com.pnfsoftware.jeb.core.output.table.ITableDocument;
import com.pnfsoftware.jeb.core.output.table.ITableDocumentPart;
import com.pnfsoftware.jeb.core.output.table.impl.Cell;
import com.pnfsoftware.jeb.core.output.table.impl.TableRow;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import java.util.ArrayList;
import java.util.List;

public class KeyValueStoreDocument
extends JebEventSource
implements ITableDocument {
    List<TableRow> rows;
    OATFile oat;

    public KeyValueStoreDocument(OATFile oat) {
        this.oat = oat;
        this.rows = new ArrayList<TableRow>();
        String[] keyValueStore = oat.getKeyValueStore().split("\u0000");
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int index = 0; index < keyValueStore.length / 2; ++index) {
            cells = new ArrayList();
            String key = keyValueStore[index * 2];
            String value = keyValueStore[index * 2 + 1];
            cells.add(new Cell(key));
            cells.add(new Cell(value));
            this.rows.add(new TableRow(cells));
        }
    }

    public List<String> getColumnLabels() {
        ArrayList<String> output = new ArrayList<String>();
        output.add("Key");
        output.add("Value");
        return output;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public ITableDocumentPart getTable() {
        return this.getTablePart(0, this.rows.size());
    }

    public ITableDocumentPart getTablePart(int start, int count) {
        return new KeyValueStoreDocumentPart(start, this.rows.subList(start, start + count));
    }

    public ICellCoordinates addressToCoordinates(String address) {
        return null;
    }

    public String coordinatesToAddress(ICellCoordinates coordinates) {
        return null;
    }

    public void dispose() {
    }

    public IPropertyManager getPropertyManager() {
        return null;
    }
}

