/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.gen;

import com.pnf.androsig.common.SignatureHandler;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexCodeItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DexProcessor {
    private static final ILogger logger = GlobalLog.getLogger(DexProcessor.class);
    private String classnameFilter;
    private int methodCount = 0;
    private Map<Integer, Map<Integer, Integer>> allCallerLists = new HashMap<Integer, Map<Integer, Integer>>();
    private Map<Integer, String> sigMap = new HashMap<Integer, String>();
    private Map<Integer, String> hierarchyMap = new HashMap<Integer, String>();

    public DexProcessor(String classnameFilter) {
        this.classnameFilter = classnameFilter;
    }

    public boolean processDex(IDexUnit dex) {
        if (!dex.isProcessed() && !dex.process()) {
            return false;
        }
        List classes = dex.getClasses();
        if (classes == null || classes.size() == 0) {
            logger.info("No classes in current project", new Object[0]);
            return false;
        }
        Pattern p = null;
        if (!Strings.isBlank((CharSequence)this.classnameFilter)) {
            p = Pattern.compile(this.classnameFilter);
        }
        for (IDexClass eClass : classes) {
            List methods = eClass.getMethods();
            if (methods == null || methods.size() == 0) continue;
            String classname = eClass.getClassType().getSignature(true);
            if (p != null && !p.matcher(classname).matches()) continue;
            for (IDexMethod m : methods) {
                IDexMethodData md;
                if (!m.isInternal() || (md = m.getData()) == null) continue;
                String mhash_tight = new String();
                Object mhash_loose = new String();
                int opcount = 0;
                IDexCodeItem ci = md.getCodeItem();
                if (ci == null) {
                    mhash_tight = "";
                    mhash_loose = "";
                } else {
                    mhash_tight = SignatureHandler.generateTightHashcode(ci);
                    mhash_loose = SignatureHandler.generateLooseHashcode(ci);
                    SignatureHandler.loadCallerList(dex, this.allCallerLists, ci, m);
                    opcount = ci.getInstructions().size();
                }
                if (mhash_tight == null || mhash_loose == null) continue;
                StringBuilder s = new StringBuilder();
                s.append(classname).append(',');
                s.append(m.getName(true)).append(',');
                IDexPrototype proto = dex.getPrototype(m.getPrototypeIndex());
                s.append(proto.getShorty()).append(',');
                s.append(proto.generate(false)).append(',');
                s.append(opcount).append(',');
                s.append(mhash_tight).append(',');
                s.append((String)mhash_loose);
                this.sigMap.put(m.getIndex(), s.toString());
                ++this.methodCount;
            }
            List superTypes = eClass.getSupertypes();
            List interfaces = eClass.getImplementedInterfaces();
            StringBuilder s = new StringBuilder();
            s.append(classname).append(",<parent>,,,0,,,");
            StringBuilder ss = new StringBuilder();
            if (!(superTypes == null || superTypes.isEmpty() || superTypes.size() == 1 && ((ICodeType)superTypes.get(0)).getSignature(true).equals("Ljava/lang/Object;"))) {
                for (ICodeType su : superTypes) {
                    ss.append(su.getSignature(true)).append('|');
                }
                ss.deleteCharAt(ss.length() - 1);
            }
            StringBuilder si = new StringBuilder();
            if (interfaces != null && !interfaces.isEmpty()) {
                for (ICodeType su : interfaces) {
                    si.append(su.getSignature(true)).append('|');
                }
                si.deleteCharAt(si.length() - 1);
            }
            if (ss.length() != 0 || si.length() != 0) {
                s.append((CharSequence)ss).append("||").append((CharSequence)si);
            }
            this.hierarchyMap.put(eClass.getIndex(), s.toString());
        }
        return true;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public Map<Integer, Map<Integer, Integer>> getAllCallerLists() {
        return this.allCallerLists;
    }

    public Map<Integer, String> getSigMap() {
        return this.sigMap;
    }

    public Map<Integer, String> getHierarchyMap() {
        return this.hierarchyMap;
    }
}

