/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.gen;

import com.pnf.androsig.common.AndroSigCommon;
import com.pnf.androsig.common.SignatureHandler;
import com.pnf.androsig.gen.LibraryGenerator;
import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.OptionDefinition;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AndroidSigGenPlugin
extends AbstractEnginesPlugin {
    private static final ILogger logger = GlobalLog.getLogger(AndroidSigGenPlugin.class);

    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Android Code Signature Generator", "Generate generic signatures to identify Android libraries", "PNF Software", AndroSigCommon.VERSION);
    }

    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return Arrays.asList(new OptionDefinition("libname", "Library name"), new OptionDefinition("filter", "Classname regular expression "));
    }

    public void dispose() {
    }

    public void load(IEnginesContext arg0) {
    }

    public void execute(IEnginesContext context) {
        this.execute(context, null);
    }

    public void execute(IEnginesContext engctx, Map<String, String> executionOptions) {
        String filter;
        File sigFolder;
        IRuntimeProject prj = engctx.getProject(0);
        if (prj == null) {
            logger.info("There is no opened project", new Object[0]);
            return;
        }
        try {
            sigFolder = SignatureHandler.getSignaturesFolder(engctx);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String libname = executionOptions.get("libname");
        if (Strings.isBlank((CharSequence)libname)) {
            libname = prj.getName();
        }
        if (!Strings.isBlank((CharSequence)(filter = executionOptions.get("filter"))) && !filter.startsWith("L")) {
            logger.error("Classname Regular expression is invalid. Expected format: 'Landroid/support/v4/.*'", new Object[0]);
            return;
        }
        LibraryGenerator.generate(prj, sigFolder, libname, filter);
    }
}

