/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.util;

import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.LibraryInfo;
import com.pnf.androsig.apply.model.StructureInfo;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReportHandler {
    private static final ILogger logger = GlobalLog.getLogger(ReportHandler.class);

    public static void generateRecord(IDexUnit unit, StructureInfo struInfo, DatabaseReference ref) {
        Object libLine;
        Map<Integer, String> matchedClasses = struInfo.getDbMatcher().getMatchedClasses();
        Map<Integer, String> matchedMethods = struInfo.getDbMatcher().getMatchedMethods();
        DecimalFormat df = new DecimalFormat("#.00");
        File mapping = new File(System.getProperty("java.io.tmpdir"), "androsig-mapping.txt");
        File mappingMini = new File(System.getProperty("java.io.tmpdir"), "androsig-mapping-mini.txt");
        File mappingTiny = new File(System.getProperty("java.io.tmpdir"), "androsig-mapping-tiny.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(mapping));
             BufferedWriter writerMini = new BufferedWriter(new FileWriter(mappingMini));
             BufferedWriter writerTiny = new BufferedWriter(new FileWriter(mappingTiny));){
            List classes = unit.getClasses();
            if (classes == null || classes.size() == 0) {
                return;
            }
            TreeMap<String, IDexClass> classesMapped = new TreeMap<String, IDexClass>();
            for (IDexClass iDexClass : classes) {
                String classPath = matchedClasses.get(iDexClass.getIndex());
                if (classPath == null) continue;
                classesMapped.put(classPath, iDexClass);
            }
            for (Map.Entry entry : classesMapped.entrySet()) {
                List methods;
                boolean classDifferent;
                String eClassSigFalse = ((IDexClass)entry.getValue()).getSignature(false);
                String classMapping = eClassSigFalse + " -> " + (String)entry.getKey() + "\n";
                writer.write(classMapping);
                boolean classWritten = false;
                boolean tinyClassWritten = false;
                boolean bl = classDifferent = !eClassSigFalse.equals(entry.getKey());
                if (classDifferent) {
                    classWritten = true;
                    writerMini.write(classMapping);
                    if (!ReportHandler.isSamePackage(eClassSigFalse, (String)entry.getKey(), 2)) {
                        tinyClassWritten = true;
                        writerTiny.write(classMapping);
                    }
                }
                if ((methods = ((IDexClass)entry.getValue()).getMethods()) == null || methods.size() == 0) continue;
                double total = 0.0;
                double matched = 0.0;
                for (IDexMethod iDexMethod : methods) {
                    if (!iDexMethod.isInternal()) continue;
                    List inst = iDexMethod.getInstructions();
                    String methodPath = matchedMethods.get(iDexMethod.getIndex());
                    String eMethodSigFalse = iDexMethod.getSignature(false);
                    int instSize = inst == null ? 0 : inst.size();
                    total += (double)instSize;
                    if (methodPath == null) continue;
                    matched += (double)instSize;
                    String mMethodName = eMethodSigFalse.split("->")[1];
                    String mNewMethodName = iDexMethod.getSignature(true).split("->")[1];
                    String mMapping = "\t(" + instSize + ")" + mMethodName + " -> " + mNewMethodName + "\n";
                    writer.write(mMapping);
                    if (!classDifferent && mMethodName.equals(mNewMethodName)) continue;
                    if (!classWritten) {
                        classWritten = true;
                        writerMini.write(classMapping);
                    }
                    writerMini.write(mMapping);
                    if (!tinyClassWritten) continue;
                    writerTiny.write(mMapping);
                }
                String coverage = df.format(total == 0.0 ? 0.0 : matched / total) + "\n";
                writer.write(coverage);
                if (classWritten) {
                    writerMini.write(coverage);
                }
                if (!tinyClassWritten) continue;
                writerTiny.write(coverage);
            }
        }
        catch (IOException e) {
            logger.error(e.toString(), new Object[0]);
        }
        int allSignatureFileCount = ref.getAllSignatureFileCount();
        int allSignatureCount = struInfo.getDbMatcher().getSignatureMetrics().getAllSignatureCount();
        int allUsedSignatureFileCount = struInfo.getDbMatcher().getSignatureMetrics().getAllUsedSignatureFileCount();
        int allClassCount = unit.getClasses().size();
        int allMatchedClassCount = struInfo.getDbMatcher().getMatchedClasses().size();
        String matchedClassCountP = df.format((double)allMatchedClassCount * 100.0 / (double)allClassCount);
        int n = struInfo.getDbMatcher().getMatchedMethods().size();
        int allInterfaceAndEmptyClassCount = ReportHandler.getInterfaceAndEmptyClassCount(unit);
        String interfaceAndEmptyClassCountP = df.format((double)allInterfaceAndEmptyClassCount * 100.0 / (double)allClassCount);
        int allUnmatchedClassCount = allClassCount - allMatchedClassCount - allInterfaceAndEmptyClassCount;
        String unmatchedClassCountP = df.format((double)allUnmatchedClassCount * 100.0 / (double)allClassCount);
        Map<String, LibraryInfo> libraryInfos = struInfo.getDbMatcher().getSignatureMetrics().getAllLibraryInfos();
        HashMap<LibraryInfo, Integer> libraryMap = new HashMap<LibraryInfo, Integer>();
        for (String s : matchedClasses.values()) {
            LibraryInfo lib = libraryInfos.get(s);
            if (lib == null) continue;
            Integer count = (Integer)libraryMap.get(lib);
            if (count == null) {
                count = 0;
            }
            libraryMap.put(lib, count + 1);
        }
        ArrayList pairs = new ArrayList(libraryMap.entrySet());
        Collections.sort(pairs, new Comparator<Map.Entry<LibraryInfo, Integer>>(){

            @Override
            public int compare(Map.Entry<LibraryInfo, Integer> a, Map.Entry<LibraryInfo, Integer> b) {
                return Integer.parseInt(b.getValue().toString()) - Integer.parseInt(a.getValue().toString());
            }
        });
        StringBuilder stb = new StringBuilder();
        stb.append("*************** Summary ***************\n");
        stb.append("Total number of signature files: ").append(allSignatureFileCount).append("\n");
        stb.append("Total number of signatures: ").append(allSignatureCount).append("\n");
        stb.append("Total number of used signature files: ").append(allUsedSignatureFileCount).append("\n");
        stb.append("Total number of classes in app: ").append(allClassCount).append("\n");
        stb.append("*************** Details ***************\n");
        stb.append("Total number of matched classes: ").append(allMatchedClassCount).append(" (").append(matchedClassCountP).append("%)\n");
        stb.append("Total number of matched methods: ").append(n).append("\n");
        stb.append("Total number of interfaces and empty classes: ").append(allInterfaceAndEmptyClassCount).append(" (").append(interfaceAndEmptyClassCountP).append("%)\n");
        stb.append("Total number of unmatched classes: ").append(allUnmatchedClassCount).append(" (").append(unmatchedClassCountP).append("%)\n");
        stb.append("*************** Library Distribution ***************\n");
        ArrayList<Object> pairsUnVersionned = new ArrayList<Object>();
        int maxLength = 0;
        for (Map.Entry entry : pairs) {
            libLine = ((LibraryInfo)entry.getKey()).getLibName() + ": " + entry.getValue() + " (" + df.format((double)((Integer)entry.getValue()).intValue() * 100.0 / (double)allClassCount) + "%)";
            maxLength = ((String)libLine).length() > maxLength ? ((String)libLine).length() : maxLength;
            pairsUnVersionned.add(libLine);
        }
        for (int i = 0; i < pairs.size(); ++i) {
            Map.Entry entry = (Map.Entry)pairs.get(i);
            libLine = (String)pairsUnVersionned.get(i);
            stb.append((String)libLine);
            Set<String> versionSet = ((LibraryInfo)entry.getKey()).getVersions();
            if (versionSet != null && !versionSet.isEmpty()) {
                stb.append(Strings.spaces((int)(maxLength - ((String)libLine).length() + 4)));
                stb.append("versions: ").append(Strings.join((String)", ", versionSet));
            }
            stb.append("\n");
        }
        String reportContent = stb.toString();
        File file = new File(System.getProperty("java.io.tmpdir"), "androsig-report.txt");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(reportContent);
        }
        catch (IOException e) {
            logger.error(e.toString(), new Object[0]);
        }
        logger.info(reportContent, new Object[0]);
    }

    private static boolean isSamePackage(String c1, String c2, int depth) {
        String[] c2Array;
        String[] c1Array = c1.split("/");
        if (c1Array.length == (c2Array = c2.split("/")).length && c1Array.length > 1 && c1Array.length <= depth) {
            depth = c1Array.length - 1;
        }
        if (c1Array.length > depth && c2Array.length > depth) {
            for (int i = 0; i < depth; ++i) {
                if (c1Array[i].equals(c2Array[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int getInterfaceAndEmptyClassCount(IDexUnit dex) {
        int count = 0;
        for (IDexClass each : dex.getClasses()) {
            if (each.getMethods() == null || each.getMethods().size() == 0) {
                ++count;
                continue;
            }
            boolean flag = true;
            for (IDexMethod eMethod : each.getMethods()) {
                if (eMethod.getInstructions() == null || eMethod.getInstructions().size() == 0) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            ++count;
        }
        return count;
    }
}

