/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.util;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.util.base.JavaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DexUtilLocal {
    public static boolean isInnerClass(String signature) {
        return signature.contains("$");
    }

    public static String getParentSignature(String signature) {
        return signature.substring(0, signature.lastIndexOf("$")) + ";";
    }

    public static IDexClass getParentClass(IDexUnit dex, String signature) {
        return dex.getClass(DexUtilLocal.getParentSignature(signature));
    }

    public static int getInnerClassLevel(String signature) {
        int level = 0;
        for (int i = 0; i < signature.length(); ++i) {
            if (signature.charAt(i) != '$') continue;
            ++level;
        }
        return level;
    }

    public static boolean isAnonymous(IDexClass eClass) {
        return (eClass.getGenericFlags() & 0x200000) != 0;
    }

    public static boolean isAnonymous(String signature) {
        int from;
        for (int i = from = signature.lastIndexOf("$") + 1; i < signature.length() - 1; ++i) {
            if (Character.isDigit(signature.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isMethodCompatible(String name1, String name2) {
        return "<init>".equals(name1) == "<init>".equals(name2) && "<clinit>".equals(name1) == "<clinit>".equals(name2);
    }

    public static boolean isMethodCompatibleWithSignatures(String name1, String sig1, String name2, String sig2) {
        String params1 = DexUtilLocal.extractParamsFromSignature(sig1);
        String params2 = DexUtilLocal.extractParamsFromSignature(sig2);
        return DexUtilLocal.isMethodCompatibleWithParams(name1, params1, name2, params2);
    }

    public static boolean isMethodCompatibleWithParams(String name1, String params1, String name2, String params2) {
        if (!DexUtilLocal.isMethodCompatible(name1, name2)) {
            return false;
        }
        return DexUtilLocal.compareMethodWithoutParameter("toString", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithParameters("equals", "Ljava/lang/Object;", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("finalize", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("getClass", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("hashCode", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("notify", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("notifyAll", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithoutParameter("wait", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithParameters("wait", "J", name1, params1, name2, params2) && DexUtilLocal.compareMethodWithParameters("wait", "JI", name1, params1, name2, params2);
    }

    public static boolean isObjectInheritedMethod(String methodName, String prototype) {
        return DexUtilLocal.isMethodEquals("toString", "()Ljava/lang/String;", methodName, prototype) || DexUtilLocal.isMethodEquals("equals", "(Ljava/lang/Object;)Z", methodName, prototype) || DexUtilLocal.isMethodEquals("finalize", "()Z", methodName, prototype) || DexUtilLocal.isMethodEquals("getClass", "()Ljava/lang/Class;", methodName, prototype) || DexUtilLocal.isMethodEquals("hashCode", "()I", methodName, prototype) || DexUtilLocal.isMethodEquals("notify", "()V", methodName, prototype) || DexUtilLocal.isMethodEquals("notifyAll", "()V", methodName, prototype) || DexUtilLocal.isMethodEquals("wait", "()V", methodName, prototype) || DexUtilLocal.isMethodEquals("wait", "(J)V", methodName, prototype) || DexUtilLocal.isMethodEquals("wait", "(JI)V", methodName, prototype);
    }

    private static boolean isMethodEquals(String methodName1, String prototype1, String methodName2, String prototype2) {
        return methodName1.equals(methodName2) && prototype1.equals(prototype2);
    }

    public static String extractParamsFromSignature(String sig) {
        int start = sig.indexOf("(");
        int end = sig.indexOf(")");
        if (start < 0 || end < 0 || start >= end) {
            throw new IllegalArgumentException("Illegal signature " + sig);
        }
        return sig.substring(start + 1, end);
    }

    public static String extractReturnValueFromSignature(String sig) {
        return sig.substring(sig.indexOf(")") + 1);
    }

    private static boolean compareMethodWithoutParameter(String methodName, String name1, String params1, String name2, String params2) {
        return (methodName.equals(name1) && params1.length() == 0) == (methodName.equals(name2) && params2.length() == 0);
    }

    private static boolean compareMethodWithParameters(String methodName, String methodParams, String name1, String params1, String name2, String params2) {
        return (methodName.equals(name1) && methodParams.equals(params1)) == (methodName.equals(name2) && methodParams.equals(params2));
    }

    public static List<String> parseSignatureParameters(String parameters) {
        ArrayList<String> params = new ArrayList<String>();
        int i = 0;
        while (i < parameters.length()) {
            int begin = i;
            while (parameters.charAt(i) == '[') {
                ++i;
            }
            char type = parameters.charAt(i);
            if (type == 'L') {
                int end = parameters.indexOf(59, i);
                if (end < 0) {
                    return null;
                }
                params.add(parameters.substring(begin, end + 1));
                i = end + 1;
                continue;
            }
            if (JavaUtil.letterToPrimitive((String)("" + type)) != null) {
                params.add(parameters.substring(begin, i + 1));
                ++i;
                continue;
            }
            return null;
        }
        return params;
    }

    public static List<IDexClass> getSortedClasses(IDexUnit unit) {
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return null;
        }
        ArrayList<IDexClass> sortedClasses = new ArrayList<IDexClass>(classes);
        Collections.sort(sortedClasses, new Comparator<IDexClass>(){

            @Override
            public int compare(IDexClass o1, IDexClass o2) {
                String sig1 = o1.getSignature(false);
                String sig2 = o2.getSignature(false);
                if (sig1.length() == sig2.length()) {
                    return sig1.compareTo(sig2);
                }
                return Integer.compare(sig1.length(), sig2.length());
            }
        });
        Collections.reverse(sortedClasses);
        return sortedClasses;
    }

    public static boolean isCompatibleClasses(String unstable, String original) {
        if (unstable.equals(original)) {
            return true;
        }
        while (true) {
            boolean array2;
            boolean array1;
            if ((array1 = unstable.startsWith("[")) != (array2 = original.startsWith("["))) {
                return false;
            }
            if (!array1) break;
            unstable = unstable.substring(1);
            original = original.substring(1);
        }
        if (unstable.charAt(0) != original.charAt(0)) {
            return false;
        }
        if (unstable.charAt(0) != 'L') {
            return true;
        }
        return !DexUtilLocal.isJavaPlatformClass(original) && !DexUtilLocal.isAndroidPlatformClass(original) && !DexUtilLocal.isJavaPlatformClass(unstable) && !DexUtilLocal.isAndroidPlatformClass(unstable);
    }

    public static boolean isJavaPlatformClass(String original) {
        return original.startsWith("Ljava/");
    }

    public static boolean isAndroidPlatformClass(String original) {
        if (!original.startsWith("Landroid/")) {
            return false;
        }
        return !original.startsWith("Landroid/support/") && !original.startsWith("Landroid/arch/") && !original.startsWith("Landroid/databinding/") && !original.startsWith("Landroid/car/");
    }
}

