/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.modules;

import com.pnf.androsig.apply.matcher.ContextMatches;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.matcher.FileMatches;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.modules.AbstractModule;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnf.androsig.common.SignatureHandler;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApkCallerModule
extends AbstractModule {
    private Map<Integer, Map<Integer, Integer>> apkCallerLists = null;

    public ApkCallerModule(ContextMatches contextMatches, FileMatches fileMatches, DatabaseReference ref) {
        super(contextMatches, fileMatches, ref);
    }

    @Override
    public void initNewPass(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        this.apkCallerLists = new HashMap<Integer, Map<Integer, Integer>>();
    }

    @Override
    public Map<Integer, String> postProcessRenameMethods(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        if (this.apkCallerLists.isEmpty()) {
            SignatureHandler.loadAllCallerLists(unit, this.apkCallerLists);
        }
        for (Map.Entry<Integer, MethodSignature> match : this.fileMatches.entrySetMatchedSigMethods()) {
            Map<String, Integer> expectedCallers;
            Map<Integer, Integer> callers = this.apkCallerLists.get(match.getKey());
            HashMap<String, Integer> calls = new HashMap<String, Integer>();
            if (callers != null) {
                for (Map.Entry<Integer, Integer> caller : callers.entrySet()) {
                    IDexMethod m = unit.getMethod(caller.getKey().intValue());
                    Integer count = caller.getValue();
                    calls.put(m.getSignature(true), count);
                }
            }
            if ((expectedCallers = match.getValue().getTargetCaller()).isEmpty() && calls.isEmpty() || expectedCallers.isEmpty() && ((expectedCallers = this.getBestCallers(unit, match.getValue())) == null || expectedCallers.isEmpty())) continue;
            if (expectedCallers.size() == 1 && calls.size() == 1) {
                String expected = expectedCallers.keySet().iterator().next();
                String current = (String)calls.keySet().iterator().next();
                if (expectedCallers.get(expected).intValue() != ((Integer)calls.get(current)).intValue()) continue;
                this.saveCallerMatching(unit, expected, current);
                continue;
            }
            this.saveCallerMatchings(unit, expectedCallers, calls);
        }
        return new HashMap<Integer, String>();
    }

    @Override
    public Map<Integer, String> postProcessRenameClasses(IDexUnit dex, DexHashcodeList dexHashCodeList, boolean firstRound) {
        if (this.apkCallerLists.isEmpty()) {
            SignatureHandler.loadAllCallerLists(dex, this.apkCallerLists);
        }
        return new HashMap<Integer, String>();
    }

    private Map<String, Integer> getBestCallers(IDexUnit unit, MethodSignature value) {
        IDexClass cl = unit.getClass(value.getCname());
        if (cl == null) {
            return null;
        }
        DatabaseReferenceFile f = this.getFileFromClass(unit, cl);
        if (f != null) {
            ArrayList<MethodSignature> candidates = new ArrayList<MethodSignature>();
            List<MethodSignature> compatibleSignatures = this.getSignaturesForClassname(f, value.getCname());
            for (MethodSignature sig : compatibleSignatures) {
                if (!sig.getMname().equals(value.getMname()) || !sig.getPrototype().equals(value.getPrototype()) || !sig.hasCaller()) continue;
                candidates.add(sig);
            }
            if (candidates.isEmpty()) {
                return null;
            }
            if (candidates.size() == 1) {
                return ((MethodSignature)candidates.get(0)).getTargetCaller();
            }
            Map<String, Integer> targetCaller = null;
            for (MethodSignature sig : candidates) {
                if (targetCaller == null) {
                    targetCaller = sig.getTargetCaller();
                    continue;
                }
                Map<String, Integer> concurrentTargetCaller = sig.getTargetCaller();
                if (targetCaller.equals(concurrentTargetCaller)) continue;
                targetCaller = null;
                break;
            }
            return targetCaller;
        }
        return null;
    }

    public void saveCallerMatching(IDexUnit unit, String expected, String current) {
        List<String> currentParams;
        IDexMethod m = unit.getMethod(current);
        if (m == null) {
            return;
        }
        String[] expectedTokens = expected.split("->|\\(|\\)");
        String[] currentTokens = current.split("->|\\(|\\)");
        if (expected.equals(current)) {
            this.saveMethodMatch(m.getIndex(), expectedTokens[1]);
            return;
        }
        List<String> expectedParams = DexUtilLocal.parseSignatureParameters(expectedTokens[2]);
        if (!(this.areParamsSignatureCompatibles(unit, expectedParams, currentParams = DexUtilLocal.parseSignatureParameters(currentTokens[2])) && DexUtilLocal.isMethodCompatibleWithParams(expectedTokens[1], expectedTokens[2], currentTokens[1], currentTokens[2]) && this.isSignatureCompatible(unit, expectedTokens[0], currentTokens[0]) && this.isSignatureCompatible(unit, expectedTokens[3], currentTokens[3]))) {
            return;
        }
        this.applyClassMatching(expectedTokens, currentTokens, m.getIndex());
        this.applyMethodMatching(m, expectedTokens[0], expectedTokens[1], expectedParams, currentParams);
    }

    private void applyClassMatching(String[] expectedTokens, String[] currentTokens, Integer eMethodIndex) {
        this.saveClassMatch(currentTokens[0], expectedTokens[0], expectedTokens[0], eMethodIndex, expectedTokens[1]);
        this.saveClassMatch(currentTokens[3], expectedTokens[3], expectedTokens[0], eMethodIndex, expectedTokens[1]);
    }

    private void applyMethodMatching(IDexMethod m, String cname, String name, List<String> expectedParams, List<String> currentParams) {
        this.saveMethodMatch(m.getIndex(), name);
        for (int i = 0; i < expectedParams.size(); ++i) {
            this.saveClassMatch(currentParams.get(i), expectedParams.get(i), cname, m.getIndex(), name);
        }
    }

    public void saveCallerMatchings(IDexUnit unit, Map<String, Integer> expectedCallers, Map<String, Integer> currents) {
        List expectedParams;
        String[] expectedTokens;
        HashMap<String, String[]> currentsSplits = new HashMap<String, String[]>();
        HashMap<String, List<String>> currentsParams = new HashMap<String, List<String>>();
        for (String current : currents.keySet()) {
            String[] currentTokens = current.split("->|\\(|\\)");
            currentsSplits.put(current, currentTokens);
            List<String> currentParams = DexUtilLocal.parseSignatureParameters((String)currentTokens[2]);
            currentsParams.put(current, currentParams);
        }
        HashMap<String, String[]> expectedsSplits = new HashMap<String, String[]>();
        HashMap<String, List<String>> expectedsParams = new HashMap<String, List<String>>();
        for (String expected : expectedCallers.keySet()) {
            String[] expectedTokens2 = expected.split("->|\\(|\\)");
            expectedsSplits.put(expected, expectedTokens2);
            List<String> list = DexUtilLocal.parseSignatureParameters(expectedTokens2[2]);
            expectedsParams.put(expected, list);
        }
        HashMap matchings = new HashMap();
        HashMap<String, String> resolved = new HashMap<String, String>();
        for (Map.Entry<String, Integer> entry : expectedCallers.entrySet()) {
            expectedTokens = (String[])expectedsSplits.get(entry.getKey());
            expectedParams = (List)expectedsParams.get(entry.getKey());
            ArrayList<String> candidates = new ArrayList<String>();
            for (Map.Entry<String, Integer> current : currents.entrySet()) {
                if (current.getValue().intValue() != entry.getValue().intValue()) continue;
                if (entry.getKey().equals(current.getKey())) {
                    candidates.clear();
                    candidates.add(current.getKey());
                    break;
                }
                List currentParams = (List)currentsParams.get(current.getKey());
                String[] currentTokens = (String[])currentsSplits.get(current.getKey());
                if (!this.areParamsSignatureCompatibles(unit, expectedParams, currentParams) || !DexUtilLocal.isMethodCompatibleWithParams(expectedTokens[1], expectedTokens[2], currentTokens[1], currentTokens[2]) || !this.isSignatureCompatible(unit, expectedTokens[0], currentTokens[0]) || !this.isSignatureCompatible(unit, expectedTokens[3], currentTokens[3])) continue;
                candidates.add(current.getKey());
            }
            if (candidates.isEmpty()) {
                return;
            }
            if (candidates.size() == 1) {
                resolved.put(entry.getKey(), (String)candidates.get(0));
                continue;
            }
            matchings.put(entry.getKey(), candidates);
        }
        for (Map.Entry<String, Integer> entry : resolved.entrySet()) {
            expectedTokens = (String[])expectedsSplits.get(entry.getKey());
            expectedParams = (List)expectedsParams.get(entry.getKey());
            List currentParams = (List)currentsParams.get(entry.getValue());
            String[] currentTokens = (String[])currentsSplits.get(entry.getValue());
            this.applyClassMatching(expectedTokens, currentTokens, null);
            IDexMethod m = unit.getMethod((String)((Object)entry.getValue()));
            if (m == null) continue;
            this.applyMethodMatching(m, expectedTokens[0], expectedTokens[1], expectedParams, currentParams);
        }
        for (Map.Entry<String, Integer> entry : matchings.entrySet()) {
            expectedTokens = (String[])expectedsSplits.get(entry.getKey());
            expectedParams = (List)expectedsParams.get(entry.getKey());
            ArrayList<String> mergedParams = new ArrayList<String>();
            String[] mergedTokens = new String[expectedTokens.length];
            for (String candidate : (List)((Object)entry.getValue())) {
                List currentParams = (List)currentsParams.get(candidate);
                String[] currentTokens = (String[])currentsSplits.get(candidate);
                if (mergedParams.isEmpty()) {
                    mergedParams.addAll(currentParams);
                    mergedTokens[0] = currentTokens[0];
                    mergedTokens[3] = currentTokens[3];
                    continue;
                }
                for (int i = 0; i < mergedParams.size(); ++i) {
                    mergedParams.set(i, this.merge((String)mergedParams.get(i), (String)currentParams.get(i)));
                }
                mergedTokens[0] = this.merge(mergedTokens[0], currentTokens[0]);
                mergedTokens[3] = this.merge(mergedTokens[3], currentTokens[3]);
            }
            for (int i = 0; i < mergedParams.size(); ++i) {
                if (Strings.isBlank((CharSequence)((CharSequence)mergedParams.get(i)))) continue;
                this.saveClassMatch((String)mergedParams.get(i), (String)expectedParams.get(i), expectedTokens[0], null, expectedTokens[1]);
            }
            if (!Strings.isBlank((CharSequence)mergedTokens[0])) {
                this.saveClassMatch(mergedTokens[0], expectedTokens[0], expectedTokens[0], null, expectedTokens[1]);
            }
            if (Strings.isBlank((CharSequence)mergedTokens[3])) continue;
            this.saveClassMatch(mergedTokens[3], expectedTokens[3], expectedTokens[0], null, expectedTokens[1]);
        }
    }

    private String merge(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equals(string2)) {
            return string;
        }
        int idx1 = string.lastIndexOf("$");
        int idx2 = string2.lastIndexOf("$");
        if (idx1 > 0 && idx2 > 0) {
            return this.merge(string.substring(0, idx1) + ";", string2.substring(0, idx2) + ";");
        }
        return null;
    }

    private boolean areParamsSignatureCompatibles(IDexUnit unit, List<String> expectedParams, List<String> currentParams) {
        if (expectedParams.size() != currentParams.size()) {
            return false;
        }
        for (int i = 0; i < expectedParams.size(); ++i) {
            if (this.isSignatureCompatible(unit, expectedParams.get(i), currentParams.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSignatureCompatible(IDexUnit unit, String expected, String current) {
        if (expected.equals(current)) {
            return true;
        }
        int typeChar = 0;
        while (expected.charAt(typeChar) == '[' && current.charAt(typeChar) == '[') {
            ++typeChar;
        }
        if (expected.charAt(typeChar) != current.charAt(typeChar)) {
            return false;
        }
        current = current.substring(typeChar);
        IDexClass cl = unit.getClass(current);
        expected = expected.substring(typeChar);
        IDexClass clExp = unit.getClass(expected);
        if (cl != null) {
            if (clExp != null) {
                return false;
            }
            int currentIdx = current.indexOf("$");
            int expectedIdx = expected.indexOf("$");
            while (currentIdx > 0 || expectedIdx > 0) {
                String currentParentName;
                if (currentIdx < 0 || expectedIdx < 0) {
                    return false;
                }
                String expectedParentName = expected.substring(0, expectedIdx) + ";";
                if (!expectedParentName.equals(currentParentName = current.substring(0, currentIdx) + ";")) {
                    IDexClass clParentExp = unit.getClass(expectedParentName);
                    IDexClass clParent = unit.getClass(currentParentName);
                    if (clParentExp != null) {
                        return false;
                    }
                    if (this.hasMatchedClass(clParent.getIndex())) {
                        return false;
                    }
                }
                currentIdx = current.indexOf("$", currentIdx + 1);
                expectedIdx = expected.indexOf("$", expectedIdx + 1);
            }
            return !this.hasMatchedClass(cl.getIndex());
        }
        return false;
    }

    @Override
    public Set<MethodSignature> filterList(IDexUnit dex, IDexMethod eMethod, List<MethodSignature> results) {
        if (this.apkCallerLists.isEmpty()) {
            return null;
        }
        Map<Integer, Integer> callers = this.apkCallerLists.get(eMethod.getIndex());
        if (callers == null) {
            return null;
        }
        HashSet<MethodSignature> filtered = new HashSet<MethodSignature>();
        block0: for (MethodSignature sig : results) {
            HashMap<String, Integer> targets = new HashMap<String, Integer>(sig.getTargetCaller());
            if (targets.isEmpty()) continue;
            for (Map.Entry<Integer, Integer> c : callers.entrySet()) {
                IDexMethod cMethod = dex.getMethod(c.getKey().intValue());
                Integer occ = (Integer)targets.remove(cMethod.getSignature(true));
                if (occ != null && occ == c.getValue()) continue;
                continue block0;
            }
            filtered.add(sig);
        }
        return filtered;
    }
}

