/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.matcher.DatabaseMatcherFactory;
import com.pnf.androsig.apply.matcher.IDatabaseMatcher;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.IStructureResult;
import com.pnf.androsig.apply.model.StructureResult;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnf.androsig.apply.util.MetadataGroupHandler;
import com.pnf.androsig.apply.util.StructureHandler;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructureInfo {
    private final ILogger logger = GlobalLog.getLogger(StructureInfo.class);
    private Set<Integer> modifiedClasses = new HashSet<Integer>();
    private StructureResult structureResult = new StructureResult();
    private IDatabaseMatcher dbMatcher;

    public StructureInfo(Map<String, String> executionOptions, DatabaseReference ref) {
        this.dbMatcher = DatabaseMatcherFactory.build(executionOptions, ref);
    }

    public void rebuildStructure(IDexUnit unit, DexHashcodeList dexHashCodeList) {
        this.logger.info("methodSizeBar " + this.dbMatcher.getParameters().methodSizeBar, new Object[0]);
        this.logger.info("matchedInstusPercentageBar " + this.dbMatcher.getParameters().matchedInstusPercentageBar, new Object[0]);
        this.logger.info("Signature matching 1 start...", new Object[0]);
        long startTime = System.currentTimeMillis();
        this.matchingVerOne(unit, dexHashCodeList);
        long endTime = System.currentTimeMillis();
        this.logger.info("Signature matching 1 start completed! (Execution Time: " + (endTime - startTime) / 1000L + "s)", new Object[0]);
        this.logger.info("******************************************************************", new Object[0]);
        this.logger.info("Signature matching 2 start...", new Object[0]);
        long startTime1 = System.currentTimeMillis();
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.matchingVerTwo(unit, dexHashCodeList);
        long endTime1 = System.currentTimeMillis();
        this.logger.info("Signature matching 2 start completed! (Execution Time: " + (endTime1 - startTime1) / 1000L + "s)", new Object[0]);
        if (this.logger.getEnabledLevel() >= 20) {
            ArrayList<String> mapped = new ArrayList<String>(this.dbMatcher.getMatchedClasses().values());
            Collections.sort(mapped);
            for (String cl : mapped) {
                this.logger.debug("Mapped class: %s", new Object[]{cl});
            }
        }
        this.moveExceptionalClasses(unit);
        this.structureResult.storeAllMatchedMethods_new_orgPath(unit, this.dbMatcher.getMatchedMethods());
        this.structureResult.storeAllMatchedClasses_new_orgPath(unit, this.dbMatcher.getMatchedClasses());
    }

    private void matchingVerOne(IDexUnit unit, DexHashcodeList dexHashCodeList) {
        this.dbMatcher.storeMatchedClassesAndMethods(unit, dexHashCodeList, true);
        this.renameMatchedClassesAndMethods(unit);
        this.renameMatchedPackages(unit);
        Map<Integer, String> newClasses = this.dbMatcher.postProcessRenameClasses(unit, dexHashCodeList, true);
        Map<Integer, String> newMethods = this.dbMatcher.postProcessRenameMethods(unit, dexHashCodeList, true);
        this.postProcess(unit, newClasses, newMethods);
    }

    private void matchingVerTwo(IDexUnit unit, DexHashcodeList dexHashCodeList) {
        int matchedClassCount = this.dbMatcher.getMatchedClasses().size();
        this.logger.info("After matching ver 1 SIZE: " + this.dbMatcher.getMatchedClasses().size(), new Object[0]);
        while (true) {
            this.dbMatcher.storeMatchedClassesAndMethods(unit, dexHashCodeList, false);
            this.renameMatchedClassesAndMethods(unit);
            this.renameMatchedPackages(unit);
            Map<Integer, String> newClasses = this.dbMatcher.postProcessRenameClasses(unit, dexHashCodeList, false);
            Map<Integer, String> newMethods = this.dbMatcher.postProcessRenameMethods(unit, dexHashCodeList, false);
            this.postProcess(unit, newClasses, newMethods);
            this.logger.info("SIZE: " + this.dbMatcher.getMatchedClasses().size(), new Object[0]);
            if (this.dbMatcher.getMatchedClasses().size() == matchedClassCount) break;
            matchedClassCount = this.dbMatcher.getMatchedClasses().size();
        }
    }

    private void postProcess(IDexUnit unit, Map<Integer, String> newClasses, Map<Integer, String> newMethods) {
        for (Map.Entry<Integer, String> each : newClasses.entrySet()) {
            IDexClass eClass = unit.getClass(each.getKey().intValue());
            StructureHandler.rename(unit, each.getValue(), eClass.getItemId());
            MetadataGroupHandler.getCodeGroupClass((ICodeUnit)unit).setData(eClass.getSignature(false), (Object)ItemClassIdentifiers.CODE_ROUTINE.getId());
        }
        for (Map.Entry<Integer, String> each : newMethods.entrySet()) {
            IDexMethod method = unit.getMethod(each.getKey().intValue());
            String temp = each.getValue();
            if (temp == null || method.getName(true).equals(temp)) continue;
            StructureHandler.rename(unit, each.getValue(), method.getItemId());
            MetadataGroupHandler.getCodeGroupMethod((ICodeUnit)unit).setData(method.getSignature(false), (Object)ItemClassIdentifiers.CODE_LIBRARY.getId());
        }
    }

    private void renameMatchedClassesAndMethods(IDexUnit unit) {
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (IDexClass eClass : classes) {
            List methods;
            if (!this.dbMatcher.getMatchedClasses().containsKey(eClass.getIndex())) continue;
            if (!this.modifiedClasses.contains(eClass.getIndex())) {
                String classPath_sig = this.dbMatcher.getMatchedClasses().get(eClass.getIndex());
                String className = classPath_sig.substring(classPath_sig.lastIndexOf("/") + 1, classPath_sig.length() - 1);
                int innerClassStartName = className.lastIndexOf("$");
                if (innerClassStartName >= 0) {
                    className = className.substring(innerClassStartName + 1);
                }
                if (innerClassStartName < 0 || !DexUtilLocal.isAnonymous(eClass)) {
                    StructureHandler.rename(unit, className, eClass.getItemId());
                }
                MetadataGroupHandler.getCodeGroupClass((ICodeUnit)unit).setData(eClass.getSignature(false), (Object)ItemClassIdentifiers.CODE_ROUTINE.getId());
                this.modifiedClasses.add(eClass.getIndex());
            }
            if ((methods = eClass.getMethods()) == null || methods.size() == 0 || this.dbMatcher.getMatchedMethods() == null || this.dbMatcher.getMatchedMethods().size() == 0) continue;
            for (IDexMethod eMethod : methods) {
                String temp = this.dbMatcher.getMatchedMethods().get(eMethod.getIndex());
                if (temp == null || eMethod.getName(true).equals(temp)) continue;
                StructureHandler.rename(unit, temp, eMethod.getItemId());
                MetadataGroupHandler.getCodeGroupMethod((ICodeUnit)unit).setData(eMethod.getSignature(false), (Object)ItemClassIdentifiers.CODE_LIBRARY.getId());
            }
        }
    }

    private void renameMatchedPackages(IDexUnit unit) {
        if (this.dbMatcher.getMatchedClasses() == null || this.dbMatcher.getMatchedClasses().size() == 0) {
            return;
        }
        for (Map.Entry<Integer, String> eClass : this.dbMatcher.getMatchedClasses().entrySet()) {
            int lastSlash = eClass.getValue().lastIndexOf("/");
            if (lastSlash < 0 || eClass.getValue().contains("$")) continue;
            String packagePath = eClass.getValue().substring(0, lastSlash) + ";";
            StructureHandler.createPackage(unit, packagePath);
            StructureHandler.moveClass(unit, packagePath, unit.getClass(eClass.getKey().intValue()).getItemId());
        }
    }

    private void moveExceptionalClasses(IDexUnit unit) {
        List classes = unit.getClasses();
        if (classes == null || classes.size() == 0) {
            return;
        }
        for (IDexClass eClass : classes) {
            String classSigPath;
            int classIndex = eClass.getIndex();
            if (!this.dbMatcher.getMatchedClasses().containsKey(classIndex) || (classSigPath = this.dbMatcher.getMatchedClasses().get(classIndex)).equals(eClass.getSignature(true)) || classSigPath.contains("$")) continue;
            String packageSigPath = classSigPath.substring(0, classSigPath.lastIndexOf("/")) + ";";
            StructureHandler.createPackage(unit, packageSigPath);
            StructureHandler.moveClass(unit, packageSigPath, eClass.getItemId());
        }
    }

    public IDatabaseMatcher getDbMatcher() {
        return this.dbMatcher;
    }

    public IStructureResult getStructureResult() {
        return this.structureResult;
    }
}

