/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.model;

import com.pnf.androsig.apply.model.ISignatureFile;
import com.pnf.androsig.apply.model.LibraryInfo;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexedSignatureFile
implements ISignatureFile {
    private static final int CURRENT_INDEX_VERSION = 2;
    private static final boolean FORCE_GENERATION = false;
    private static final ILogger logger = GlobalLog.getLogger(IndexedSignatureFile.class);
    private Map<String, List<Integer>> tightSignaturesIdx = new HashMap<String, List<Integer>>();
    private Map<String, List<Integer>> looseSignaturesIdx = new HashMap<String, List<Integer>>();
    private Map<String, List<Integer>> signaturesByClassnameIdx = new HashMap<String, List<Integer>>();
    private Map<String, List<Integer>> signaturesByMethodsIdx = new HashMap<String, List<Integer>>();
    private Map<String, List<MethodSignature>> tightSignatures = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> looseSignatures = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> signaturesByClassname = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> signaturesByMethod = new HashMap<String, List<MethodSignature>>();
    private Map<String, List<MethodSignature>> metaByClassname = new HashMap<String, List<MethodSignature>>();
    private LibraryInfo libraryInfo;
    private int allSignatureCount = 0;
    private File sigFile;
    private RandomAccessFile f = null;

    public boolean loadSignatures(File sigFile) {
        if (this.sigFile != null) {
            throw new RuntimeException("Can only load one signature file");
        }
        this.sigFile = sigFile;
        File indexFile = IndexedSignatureFile.getIndexFile(sigFile);
        if (!indexFile.exists()) {
            return false;
        }
        Charset utf8 = Charset.forName("UTF-8");
        this.libraryInfo = this.getLibraryInfo(sigFile, utf8);
        try {
            byte[] data = Files.readAllBytes(indexFile.toPath());
            int startIndex = 0;
            int index = IndexedSignatureFile.validateHeader(sigFile, indexFile, data);
            if (index < 0) {
                if (!IndexedSignatureFile.buildIndexFile(sigFile, indexFile)) {
                    return false;
                }
                data = Files.readAllBytes(indexFile.toPath());
                index = IndexedSignatureFile.validateHeader(sigFile, indexFile, data);
                if (index < 0) {
                    return false;
                }
            }
            Map<String, List<Integer>> currentList = this.tightSignaturesIdx;
            while (index < data.length) {
                if (IndexLine.isSeparator(data[index])) {
                    IndexLine line = IndexLine.parseLine(data, startIndex, index, utf8, false);
                    currentList.put(line.mhash, line.indexes);
                    startIndex = index = line.index;
                    if (currentList == this.signaturesByClassnameIdx) {
                        this.allSignatureCount += line.nb;
                    }
                    if (index < data.length) {
                        if (!IndexLine.isSectionSeparator(data[index])) continue;
                        startIndex = ++index;
                        if (currentList == this.tightSignaturesIdx) {
                            currentList = this.looseSignaturesIdx;
                            continue;
                        }
                        if (currentList == this.looseSignaturesIdx) {
                            currentList = this.signaturesByClassnameIdx;
                            continue;
                        }
                        if (currentList == this.signaturesByClassnameIdx) {
                            currentList = this.signaturesByMethodsIdx;
                            continue;
                        }
                    }
                    break;
                }
                ++index;
            }
        }
        catch (IOException e) {
            logger.catchingSilent((Throwable)e);
            return false;
        }
        return true;
    }

    private LibraryInfo getLibraryInfo(File sigFile, Charset encoding) {
        int version = 0;
        String libname = "Unknown library code";
        String author = "Unknown author";
        LibraryInfo libraryInfo = new LibraryInfo();
        libraryInfo.setLibName(libname);
        libraryInfo.setAuthor(author);
        try (FileInputStream input = new FileInputStream(sigFile);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input, encoding));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(";")) {
                    String value = this.checkMarker(line = line.substring(1), "version");
                    if (value != null) {
                        version = Conversion.stringToInt((String)value);
                        libraryInfo.setVersion(version);
                    }
                    if ((value = this.checkMarker(line, "libname")) != null) {
                        libname = value;
                        libraryInfo.setLibName(libname);
                    }
                    if ((value = this.checkMarker(line, "author")) == null) continue;
                    author = value;
                    libraryInfo.setAuthor(author);
                    continue;
                }
                if (line.isEmpty()) continue;
                break;
            }
        }
        catch (IOException e) {
            logger.catchingSilent((Throwable)e);
        }
        return libraryInfo;
    }

    private String checkMarker(String line, String marker) {
        if (line.startsWith(marker + "=")) {
            return line.substring(marker.length() + 1).trim();
        }
        return null;
    }

    private static int readInt(byte[] data, int offset) {
        return EndianUtil.bigEndianBytesToInt((byte[])data, (int)offset);
    }

    @Override
    public LibraryInfo getLibraryInfos() {
        return this.libraryInfo;
    }

    @Override
    public List<MethodSignature> getTightSignatures(String hashcode) {
        List<MethodSignature> res = this.tightSignatures.get(hashcode);
        if (res == null) {
            res = this.load(this.tightSignaturesIdx, hashcode, this.tightSignatures);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    private List<MethodSignature> load(Map<String, List<Integer>> mapIdx, String hashcode, Map<String, List<MethodSignature>> map) {
        List<MethodSignature> signatures = this.load(mapIdx, hashcode, map, null);
        this.mergeSignatures(signatures);
        return signatures;
    }

    private void mergeSignatures(List<MethodSignature> signatures) {
        this.mergeSignatures(signatures, null);
    }

    private void mergeSignatures(List<MethodSignature> signatures, List<MethodSignature> allMethods) {
        if (signatures == null) {
            return;
        }
        boolean refreshClassname = allMethods == null;
        for (int i = 0; i < signatures.size(); ++i) {
            MethodSignature ref = signatures.get(i);
            for (int j = i + 1; j < signatures.size(); ++j) {
                MethodSignature current = signatures.get(j);
                if (!MethodSignature.equalsClassMethodSig(ref, current)) continue;
                signatures.remove(j);
                --j;
            }
            boolean shared = false;
            if (refreshClassname) {
                String key = ref.getCname() + "->" + ref.getMname();
                List<Integer> sameMethods = this.signaturesByMethodsIdx.get(key);
                if (sameMethods == null || sameMethods.size() == 2) continue;
                allMethods = this.signaturesByClassname.get(ref.getCname());
                if (allMethods == null) {
                    allMethods = this.load(this.signaturesByMethodsIdx, key, this.signaturesByMethod, null);
                } else {
                    shared = true;
                }
            }
            if (allMethods.size() == 1) continue;
            for (MethodSignature m : allMethods) {
                if (m == ref || !MethodSignature.equalsMethodSig(ref, m)) continue;
                if (shared) {
                    signatures.set(i, m);
                    continue;
                }
                ref.addRevision(m.getOwnRevision());
            }
        }
    }

    private List<MethodSignature> load(Map<String, List<Integer>> mapIdx, String hashcode, Map<String, List<MethodSignature>> map, Map<String, List<MethodSignature>> mapmeta) {
        ArrayList<MethodSignature> sigs = new ArrayList<MethodSignature>();
        ArrayList<MethodSignature> metaSigs = new ArrayList<MethodSignature>();
        map.put(hashcode, sigs);
        try {
            List<Integer> indexes;
            if (this.f == null) {
                this.f = new RandomAccessFile(this.sigFile, "r");
            }
            if ((indexes = mapIdx.get(hashcode)) == null) {
                return sigs;
            }
            for (int i = 0; i < indexes.size(); i += 2) {
                int start = indexes.get(i);
                int end = indexes.get(i + 1);
                this.f.seek(start);
                byte[] lineBytes = new byte[end - start];
                this.f.read(lineBytes);
                String line = new String(lineBytes);
                MethodSignature m = MethodSignature.parse(line);
                if (m != null) {
                    sigs.add(m);
                    continue;
                }
                if (mapmeta == null || (m = MethodSignature.parse(line, false)) == null) continue;
                metaSigs.add(m);
                mapmeta.put(hashcode, metaSigs);
            }
            return sigs;
        }
        catch (IOException e) {
            logger.error("Can not read %s", new Object[]{this.sigFile});
            return sigs;
        }
    }

    @Override
    public List<MethodSignature> getLooseSignatures(String hashcode) {
        List<MethodSignature> res = this.looseSignatures.get(hashcode);
        if (res == null) {
            res = this.load(this.looseSignaturesIdx, hashcode, this.looseSignatures);
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean hasSignaturesForClassname(String className) {
        return this.signaturesByClassnameIdx.get(className) != null;
    }

    @Override
    public List<MethodSignature> getSignaturesForClassname(String className, boolean exactName) {
        ArrayList<MethodSignature> compatibleSignatures = new ArrayList<MethodSignature>();
        if (exactName) {
            List<MethodSignature> res = this.signaturesByClassname.get(className);
            if (res == null) {
                res = this.load(this.signaturesByClassnameIdx, className, this.signaturesByClassname, this.metaByClassname);
                ArrayList<MethodSignature> ref = new ArrayList<MethodSignature>(res);
                this.mergeSignatures(res, ref);
                List<MethodSignature> metas = this.metaByClassname.get(className);
                this.mergeSignatures(metas, (List<MethodSignature>)(metas == null ? null : new ArrayList<MethodSignature>(metas)));
            }
            return res;
        }
        for (Map.Entry<String, List<Integer>> entry : this.signaturesByClassnameIdx.entrySet()) {
            List<MethodSignature> ms;
            if (!entry.getKey().startsWith(className) || (ms = this.getSignaturesForClassname(entry.getKey(), true)) == null) continue;
            compatibleSignatures.addAll(ms);
        }
        return compatibleSignatures;
    }

    @Override
    public List<MethodSignature> getParent(String className) {
        this.getSignaturesForClassname(className, true);
        return this.metaByClassname.get(className);
    }

    @Override
    public int getAllSignatureCount() {
        return this.allSignatureCount;
    }

    public static boolean buildIndexFile(File sigFile, File indexFile) {
        long fileSize = sigFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new RuntimeException("Signature file is too big. Is it really a signature file? If so, split it.");
        }
        Charset utf8 = Charset.forName("UTF-8");
        HashMap<String, List<Integer>> tightHashcodes = new HashMap<String, List<Integer>>();
        HashMap<String, List<Integer>> looseHashcodes = new HashMap<String, List<Integer>>();
        HashMap<String, List<Integer>> classes = new HashMap<String, List<Integer>>();
        HashMap<String, List<Integer>> methods = new HashMap<String, List<Integer>>();
        try {
            byte[] data = Files.readAllBytes(sigFile.toPath());
            int startIndex = 0;
            int endIndex = 0;
            while ((endIndex = IndexedSignatureFile.getNextLine(data, startIndex)) != -1) {
                String className;
                String mhash_loose;
                if (data[startIndex] == 59) {
                    startIndex = endIndex + 1;
                    continue;
                }
                String[] subLines = MethodSignature.parseNative(data, startIndex, endIndex);
                if (subLines == null) {
                    logger.warn("Invalid parameter signature line at index " + startIndex + " in file " + sigFile, new Object[0]);
                    startIndex = endIndex + 1;
                    continue;
                }
                String mhash_tight = MethodSignature.getTightSignature(subLines);
                if (mhash_tight != null && !mhash_tight.isEmpty() && !mhash_tight.equals("null")) {
                    ArrayList<Integer> files = (ArrayList<Integer>)tightHashcodes.get(mhash_tight);
                    if (files == null) {
                        files = new ArrayList<Integer>();
                        tightHashcodes.put(mhash_tight, files);
                    }
                    files.add(startIndex);
                    files.add(endIndex);
                }
                if ((mhash_loose = MethodSignature.getLooseSignature(subLines)) != null && !mhash_loose.isEmpty() && !mhash_loose.equals("null")) {
                    ArrayList<Integer> files = (ArrayList<Integer>)looseHashcodes.get(mhash_loose);
                    if (files == null) {
                        files = new ArrayList<Integer>();
                        looseHashcodes.put(mhash_loose, files);
                    }
                    files.add(startIndex);
                    files.add(endIndex);
                }
                if ((className = MethodSignature.getClassname(subLines)) != null && !className.isEmpty()) {
                    ArrayList<Integer> files = (ArrayList<Integer>)classes.get(className);
                    if (files == null) {
                        files = new ArrayList<Integer>();
                        classes.put(className, files);
                    }
                    files.add(startIndex);
                    files.add(endIndex);
                    String methodName = MethodSignature.getMethodName(subLines);
                    if (methodName != null && !methodName.isEmpty()) {
                        String key = className + "->" + methodName;
                        ArrayList<Integer> filesM = (ArrayList<Integer>)methods.get(key);
                        if (filesM == null) {
                            filesM = new ArrayList<Integer>();
                            methods.put(key, filesM);
                        }
                        filesM.add(startIndex);
                        filesM.add(endIndex);
                    }
                }
                startIndex = endIndex + 1;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffInt = new byte[4];
            IndexedSignatureFile.writeInt(buffInt, 2, bos);
            IndexedSignatureFile.writeInt(buffInt, (int)fileSize, bos);
            bos.write(10);
            bos.write(10);
            IndexedSignatureFile.writeSection(bos, utf8, buffInt, tightHashcodes);
            bos.write(10);
            IndexedSignatureFile.writeSection(bos, utf8, buffInt, looseHashcodes);
            bos.write(10);
            IndexedSignatureFile.writeSection(bos, utf8, buffInt, classes);
            bos.write(10);
            IndexedSignatureFile.writeMethodSection(bos, utf8, buffInt, methods);
            IO.writeFile((File)indexFile, (byte[])bos.toByteArray());
        }
        catch (IOException e) {
            logger.catching((Throwable)e);
            return false;
        }
        return true;
    }

    private static void writeSection(ByteArrayOutputStream bos, Charset utf8, byte[] buffInt, Map<String, List<Integer>> classes) throws IOException {
        for (Map.Entry<String, List<Integer>> entry : classes.entrySet()) {
            bos.write(entry.getKey().getBytes(utf8));
            bos.write(61);
            IndexedSignatureFile.writeInt(buffInt, entry.getValue().size(), bos);
            for (Integer address : entry.getValue()) {
                IndexedSignatureFile.writeInt(buffInt, address, bos);
            }
            bos.write(10);
        }
    }

    private static void writeMethodSection(ByteArrayOutputStream bos, Charset utf8, byte[] buffInt, Map<String, List<Integer>> classes) throws IOException {
        for (Map.Entry<String, List<Integer>> entry : classes.entrySet()) {
            if (entry.getValue().size() == 2) continue;
            bos.write(entry.getKey().getBytes(utf8));
            bos.write(61);
            IndexedSignatureFile.writeInt(buffInt, entry.getValue().size(), bos);
            for (Integer address : entry.getValue()) {
                IndexedSignatureFile.writeInt(buffInt, address, bos);
            }
            bos.write(10);
        }
    }

    private static void writeInt(byte[] buffInt, int val, ByteArrayOutputStream bos) throws IOException {
        EndianUtil.intToBEBytes((int)val, (byte[])buffInt);
        bos.write(buffInt);
    }

    private static int getNextLine(byte[] data, int startIndex) {
        if (startIndex == data.length) {
            return -1;
        }
        int index = startIndex;
        while (data[index] != 10) {
            if (++index != data.length) continue;
            return -1;
        }
        return index;
    }

    public static File getIndexFile(File sigFile) {
        if (!sigFile.getName().endsWith(".sig")) {
            return null;
        }
        return new File(sigFile.getParentFile(), sigFile.getName().substring(0, sigFile.getName().length() - 4) + ".idx");
    }

    public static boolean populate(File sigFile, Map<String, Set<String>> allTightHashcodes, Map<String, Set<String>> allLooseHashcodes, Map<String, Set<String>> allClasses) {
        File indexFile = IndexedSignatureFile.getIndexFile(sigFile);
        if (indexFile == null) {
            logger.error("Can not determine index file name. Is Signature extension is correct for %s?", new Object[]{sigFile});
            return false;
        }
        if (!indexFile.exists() && !IndexedSignatureFile.buildIndexFile(sigFile, indexFile)) {
            return false;
        }
        Charset utf8 = Charset.forName("UTF-8");
        try {
            byte[] data = Files.readAllBytes(indexFile.toPath());
            int startIndex = 0;
            int index = IndexedSignatureFile.validateHeader(sigFile, indexFile, data);
            if (index < 0) {
                if (!IndexedSignatureFile.buildIndexFile(sigFile, indexFile)) {
                    return false;
                }
                data = Files.readAllBytes(indexFile.toPath());
                index = IndexedSignatureFile.validateHeader(sigFile, indexFile, data);
                if (index < 0) {
                    return false;
                }
            }
            Map<String, Set<String>> currentList = allTightHashcodes;
            while (index < data.length) {
                if (IndexLine.isSeparator(data[index])) {
                    IndexLine line = IndexLine.parseLine(data, startIndex, index, utf8, true);
                    Set<String> files = currentList.get(line.mhash);
                    if (files == null) {
                        files = new LinkedHashSet<String>();
                        currentList.put(line.mhash, files);
                    }
                    files.add(sigFile.getAbsolutePath());
                    startIndex = index = line.index;
                    if (index < data.length) {
                        if (!IndexLine.isSectionSeparator(data[index])) continue;
                        startIndex = ++index;
                        if (currentList == allTightHashcodes) {
                            currentList = allLooseHashcodes;
                            continue;
                        }
                        if (currentList == allLooseHashcodes) {
                            currentList = allClasses;
                            continue;
                        }
                    }
                    break;
                }
                ++index;
            }
        }
        catch (IOException e) {
            logger.catching((Throwable)e);
            return false;
        }
        return true;
    }

    private static int validateHeader(File sigFile, File indexFile, byte[] data) {
        int index = 0;
        if (data.length < 10) {
            return -1;
        }
        int version = IndexedSignatureFile.readInt(data, index);
        index += 4;
        if (version != 2) {
            return -1;
        }
        int expectedSize = IndexedSignatureFile.readInt(data, index);
        index += 4;
        if ((long)expectedSize != sigFile.length()) {
            return -1;
        }
        return index += 2;
    }

    @Override
    public void close() throws IOException {
        if (this.f != null) {
            this.f.close();
        }
    }

    private static class IndexLine {
        String mhash;
        int index = 0;
        int nb = 0;
        List<Integer> indexes;

        public IndexLine(int endIndex) {
            this.index = endIndex;
        }

        static IndexLine parseLine(byte[] data, int startIndex, int endIndex, Charset utf8, boolean skip) {
            IndexLine line = new IndexLine(endIndex);
            line.mhash = new String(data, startIndex, line.index - startIndex, utf8);
            ++line.index;
            line.nb = IndexedSignatureFile.readInt(data, line.index);
            line.index += 4;
            if (skip) {
                line.index += line.nb * 4;
            } else {
                line.indexes = new ArrayList<Integer>();
                for (int i = 0; i < line.nb; ++i) {
                    line.indexes.add(IndexedSignatureFile.readInt(data, line.index));
                    line.index += 4;
                }
            }
            ++line.index;
            return line;
        }

        static boolean isSeparator(byte b) {
            return b == 61;
        }

        static boolean isSectionSeparator(byte b) {
            return b == 10;
        }
    }
}

