/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.List;
import java.util.stream.Collectors;

public class HierarchyMatcher {
    private String origin;
    private List<String> interfaces;

    public HierarchyMatcher(IDexClass eClass) {
        this.origin = ((ICodeType)eClass.getSupertypes().get(0)).getSignature(true);
        this.interfaces = eClass.getImplementedInterfaces().stream().map(c -> c.getSignature(true)).collect(Collectors.toList());
    }

    public String getSuperType() {
        return this.origin;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public boolean isCompatible(DatabaseReference ref, DatabaseReferenceFile file, String className) {
        boolean voidInterfacesTest;
        Couple<String, List<String>> hierarchy = ref.getParentForClassname(file, className);
        if (hierarchy == null) {
            return true;
        }
        String supertype = (String)hierarchy.getFirst();
        if (supertype != null && !this.isCompatibleSuperType(supertype)) {
            return false;
        }
        List interfacesTest = (List)hierarchy.getSecond();
        boolean voidInterfaces = this.interfaces == null || this.interfaces.isEmpty();
        boolean bl = voidInterfacesTest = interfacesTest == null || interfacesTest.isEmpty();
        if (voidInterfaces && voidInterfacesTest) {
            return true;
        }
        if (voidInterfacesTest) {
            return false;
        }
        if (voidInterfaces != voidInterfacesTest) {
            return false;
        }
        if (interfacesTest.size() == 1 && this.interfaces.size() == 1) {
            return this.isCompatibleClass((String)interfacesTest.get(0), this.interfaces.get(0));
        }
        for (String inter : this.interfaces) {
            boolean found = false;
            for (String interTest : interfacesTest) {
                if (!this.isCompatibleClass(interTest, inter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatibleSuperType(String supertype) {
        return this.isCompatibleClass(supertype, this.origin);
    }

    private boolean isCompatibleClass(String unstable, String original) {
        if (Strings.isBlank((CharSequence)original)) {
            if (Strings.isBlank((CharSequence)unstable)) {
                // empty if block
            }
        } else if (!Strings.isBlank((CharSequence)unstable) && !DexUtilLocal.isCompatibleClasses(original, unstable)) {
            return false;
        }
        return true;
    }
}

