/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.matcher.ContextMatches;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexPrototype;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileMatches {
    private final ILogger logger = GlobalLog.getLogger(FileMatches.class);
    private ContextMatches contextMatches;
    private Map<Integer, DatabaseReferenceFile> matchedClassesFile = new HashMap<Integer, DatabaseReferenceFile>();
    private Map<String, DatabaseReferenceFile> usedSigFiles = new HashMap<String, DatabaseReferenceFile>();
    private Map<String, DatabaseReferenceFile> tempSigFiles = new HashMap<String, DatabaseReferenceFile>();
    private Map<Integer, String> matchedClasses = new LinkedHashMap<Integer, String>();
    private Map<Integer, String> matchedMethods = new LinkedHashMap<Integer, String>();
    private Map<Integer, MethodSignature> matchedSigMethods = new HashMap<Integer, MethodSignature>();
    private Map<Integer, Set<DatabaseReferenceFile>> candidateMatchedClassesFile = new HashMap<Integer, Set<DatabaseReferenceFile>>();

    public FileMatches(ContextMatches contextMatches) {
        this.contextMatches = contextMatches;
    }

    public Set<String> getSignatureFileUsed() {
        return this.usedSigFiles.keySet();
    }

    public boolean isSignatureFileUsed(String f) {
        return this.usedSigFiles.containsKey(f);
    }

    public DatabaseReferenceFile getFileFromClass(IDexUnit dex, IDexClass dexClass) {
        String signature;
        if (dexClass == null) {
            return null;
        }
        DatabaseReferenceFile refFile = this.getFileFromClassId(dexClass.getIndex());
        if (refFile == null && DexUtilLocal.isInnerClass(signature = dexClass.getSignature(true)) && (refFile = this.getFileFromClass(dex, DexUtilLocal.getParentClass(dex, signature))) != null) {
            this.matchedClassesFile.put(dexClass.getIndex(), refFile);
        }
        return refFile;
    }

    public DatabaseReferenceFile getFileFromClassId(int index) {
        return this.matchedClassesFile.get(index);
    }

    public Set<DatabaseReferenceFile> getCandidateFilesFromClass(IDexUnit dex, IDexClass dexClass) {
        String signature;
        if (dexClass == null) {
            return null;
        }
        Set<DatabaseReferenceFile> refFiles = this.candidateMatchedClassesFile.get(dexClass.getIndex());
        if (refFiles == null && DexUtilLocal.isInnerClass(signature = dexClass.getSignature(true)) && (refFiles = this.getCandidateFilesFromClass(dex, DexUtilLocal.getParentClass(dex, signature))) != null) {
            this.candidateMatchedClassesFile.put(dexClass.getIndex(), refFiles);
        }
        if (refFiles != null) {
            refFiles = new HashSet<DatabaseReferenceFile>(refFiles);
        }
        return refFiles;
    }

    private void addMatchedClassFiles(IDexClass dexClass, String file) {
        this.addMatchedClassFiles(dexClass.getIndex(), file);
    }

    private void addMatchedClassFiles(int dexClassIndex, String file) {
        DatabaseReferenceFile refFile = this.usedSigFiles.get(file);
        if (refFile == null) {
            refFile = new DatabaseReferenceFile(file, null);
            this.usedSigFiles.put(file, refFile);
        }
        this.matchedClassesFile.put(dexClassIndex, refFile);
        this.processNewReferenceFile(refFile);
    }

    private void addMatchedClassFiles(int dexClassIndex, DatabaseReferenceFile refFile, boolean recurse) {
        this.usedSigFiles.put(refFile.file, refFile);
        this.matchedClassesFile.put(dexClassIndex, refFile);
        if (recurse) {
            this.processNewReferenceFile(refFile);
        }
    }

    public DatabaseReferenceFile removeClassFiles(IDexClass dexClass) {
        return this.matchedClassesFile.remove(dexClass.getIndex());
    }

    private void addCandidates(IDexClass eClass, List<String> files) {
        for (String file : files) {
            Integer key;
            Set<DatabaseReferenceFile> val;
            DatabaseReferenceFile refFile = this.usedSigFiles.get(file);
            if (refFile == null && (refFile = this.tempSigFiles.get(file)) == null) {
                refFile = new DatabaseReferenceFile(file, null);
                this.tempSigFiles.put(file, refFile);
            }
            if ((val = this.candidateMatchedClassesFile.get(key = Integer.valueOf(eClass.getIndex()))) == null) {
                val = new HashSet<DatabaseReferenceFile>();
                this.candidateMatchedClassesFile.put(key, val);
            }
            val.add(refFile);
        }
    }

    public void removeCandidateFile(DatabaseReferenceFile r) {
        HashMap<Integer, DatabaseReferenceFile> stableElements = new HashMap<Integer, DatabaseReferenceFile>();
        this.tempSigFiles.remove(r.file);
        for (Map.Entry<Integer, Set<DatabaseReferenceFile>> entry : this.candidateMatchedClassesFile.entrySet()) {
            if (!entry.getValue().remove(r) || entry.getValue().size() != 1) continue;
            stableElements.put(entry.getKey(), entry.getValue().iterator().next());
        }
        for (Map.Entry<Integer, Set<DatabaseReferenceFile>> entry : stableElements.entrySet()) {
            this.candidateMatchedClassesFile.remove(entry.getKey());
            this.addMatchedClassFiles(entry.getKey(), (DatabaseReferenceFile)((Object)entry.getValue()), true);
        }
    }

    private void processNewReferenceFile(DatabaseReferenceFile refFile) {
        HashMap<Integer, DatabaseReferenceFile> stableElements = new HashMap<Integer, DatabaseReferenceFile>();
        block0: for (Map.Entry<Integer, Set<DatabaseReferenceFile>> entry : this.candidateMatchedClassesFile.entrySet()) {
            for (DatabaseReferenceFile f : entry.getValue()) {
                if (!f.file.equals(refFile.file)) continue;
                stableElements.put(entry.getKey(), refFile);
                continue block0;
            }
        }
        for (Map.Entry<Integer, Set<DatabaseReferenceFile>> entry : stableElements.entrySet()) {
            this.candidateMatchedClassesFile.remove(entry.getKey());
            this.addMatchedClassFiles(entry.getKey(), (DatabaseReferenceFile)((Object)entry.getValue()), false);
        }
    }

    private boolean saveFileVersions(String file, Collection<MethodSignature> values) {
        DatabaseReferenceFile refFile = this.usedSigFiles.get(file);
        if (refFile == null) {
            refFile = new DatabaseReferenceFile(file, null);
            this.usedSigFiles.put(file, refFile);
        }
        refFile.mergeVersions(values);
        return true;
    }

    private void saveCandidateFileVersions(List<String> files, Collection<MethodSignature> values) {
        for (String file : files) {
            DatabaseReferenceFile refFile = this.usedSigFiles.get(file);
            if (refFile == null) {
                refFile = new DatabaseReferenceFile(file, null);
                this.tempSigFiles.put(file, refFile);
            }
            refFile.mergeVersions(values);
        }
    }

    public DatabaseReferenceFile getMatchedClassFile(IDexUnit dex, IDexClass cl, String className, DatabaseReference ref) {
        DatabaseReferenceFile refFile = this.getFileFromClass(dex, cl);
        if (refFile != null) {
            return refFile;
        }
        if (this.candidateMatchedClassesFile.containsKey(cl.getIndex())) {
            return null;
        }
        String f = null;
        List<String> fs = ref.getFilesContainingClass(className);
        if (fs == null || fs.isEmpty()) {
            return null;
        }
        if (fs.size() == 1) {
            f = fs.get(0);
            if (!this.usedSigFiles.containsKey(f)) {
                this.usedSigFiles.put(f, null);
            }
            this.addMatchedClassFiles(cl, f);
            return this.usedSigFiles.get(f);
        }
        this.addCandidates(cl, fs);
        return null;
    }

    public List<MethodSignature> getSignatureLines(DatabaseReference ref, String file, String hashcode, boolean tight) {
        if (!this.usedSigFiles.containsKey(file)) {
            return ref.getSignatureLines(file, hashcode, tight);
        }
        DatabaseReferenceFile refFile = this.usedSigFiles.get(file);
        return ref.getSignatureLines(refFile, hashcode, tight);
    }

    public void addMatchedClass(IDexClass cl, String classname, List<String> files, Collection<MethodSignature> usedMethodSignatures) {
        if (this.matchedClasses.get(cl.getIndex()) != null) {
            this.logger.error("Conflict: Try to replace class %s", new Object[]{this.matchedClasses.get(cl.getIndex())});
            return;
        }
        if (this.matchedClasses.containsValue(classname)) {
            this.logger.error("Conflict: Try to bind class %s to %s which is already bind to ", new Object[]{classname, cl.getSignature(false), cl.getSignature(true)});
            return;
        }
        this.matchedClasses.put(cl.getIndex(), classname);
        this.removeClassFiles(cl);
        if (files != null && !files.isEmpty()) {
            if (files.size() == 1) {
                String file = files.get(0);
                this.saveFileVersions(file, usedMethodSignatures);
                this.addMatchedClassFiles(cl, file);
            } else {
                this.saveCandidateFileVersions(files, usedMethodSignatures);
                this.addCandidates(cl, files);
            }
        }
    }

    public void removeMatchedClass(int index) {
        this.matchedClasses.remove(index);
        this.matchedClassesFile.remove(index);
    }

    public String getMatchedClass(IDexClass cl) {
        return this.getMatchedClass(cl.getIndex());
    }

    public String getMatchedClass(int index) {
        return this.matchedClasses.get(index);
    }

    public boolean containsMatchedClass(IDexClass cl) {
        return this.containsMatchedClass(cl.getIndex());
    }

    public boolean containsMatchedClass(int index) {
        return this.matchedClasses.containsKey(index);
    }

    public boolean containsMatchedClassValue(String className) {
        return this.matchedClasses.containsValue(className);
    }

    public Map<Integer, String> getMatchedClasses() {
        return this.matchedClasses;
    }

    public Set<Map.Entry<Integer, String>> entrySetMatchedClasses() {
        return this.matchedClasses.entrySet();
    }

    public void addMatchedMethod(IDexUnit unit, int index, MethodSignature sig) {
        this.addMatchedMethod(index, sig);
        IDexMethod m = unit.getMethod(index);
        this.bindMatchedSigMethod(unit, m, sig);
    }

    private void addMatchedMethod(int index, MethodSignature sig) {
        if (this.matchedMethods.get(index) != null) {
            this.logger.error("Conflict: Try to replace method %s", new Object[]{index});
            return;
        }
        this.matchedMethods.put(index, sig.getMname());
    }

    public void bindMatchedSigMethod(IDexUnit unit, IDexMethod m, MethodSignature ms) {
        this.matchedSigMethods.put(m.getIndex(), ms);
        if (ms.getPrototype().isEmpty()) {
            return;
        }
        IDexPrototype proto = unit.getPrototype(m.getPrototypeIndex());
        String prototypes = proto.generate(true);
        this.contextMatches.saveParamMatching(prototypes, ms.getPrototype(), ms.getCname(), m.getIndex(), ms.getMname());
    }

    public String getMatchedMethod(IDexMethod m) {
        return this.getMatchedMethod(m.getIndex());
    }

    public String getMatchedMethod(int index) {
        return this.matchedMethods.get(index);
    }

    public MethodSignature getMatchedSigMethod(IDexMethod m) {
        return this.getMatchedSigMethod(m.getIndex());
    }

    public MethodSignature getMatchedSigMethod(int index) {
        return this.matchedSigMethods.get(index);
    }

    public boolean containsMatchedMethod(IDexMethod m) {
        return this.containsMatchedMethod(m.getIndex());
    }

    public boolean containsMatchedMethod(int index) {
        return this.matchedMethods.containsKey(index);
    }

    public void removeMatchedMethod(int index) {
        this.matchedMethods.remove(index);
        this.matchedSigMethods.remove(index);
    }

    public Map<Integer, String> getMatchedMethods() {
        return this.matchedMethods;
    }

    public Set<Map.Entry<Integer, String>> entrySetMatchedMethods() {
        return this.matchedMethods.entrySet();
    }

    public Set<Map.Entry<Integer, MethodSignature>> entrySetMatchedSigMethods() {
        return this.matchedSigMethods.entrySet();
    }
}

