/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.androsig.apply.matcher;

import com.pnf.androsig.apply.matcher.ContextMatches;
import com.pnf.androsig.apply.matcher.DatabaseMatcherParameters;
import com.pnf.androsig.apply.matcher.DatabaseReferenceFile;
import com.pnf.androsig.apply.matcher.FileMatches;
import com.pnf.androsig.apply.matcher.HierarchyMatcher;
import com.pnf.androsig.apply.matcher.IAndrosigModule;
import com.pnf.androsig.apply.matcher.IDatabaseMatcher;
import com.pnf.androsig.apply.matcher.IMatcherValidation;
import com.pnf.androsig.apply.matcher.ISignatureMetrics;
import com.pnf.androsig.apply.matcher.MatchingSearch;
import com.pnf.androsig.apply.model.DatabaseReference;
import com.pnf.androsig.apply.model.DexHashcodeList;
import com.pnf.androsig.apply.model.ISignatureFile;
import com.pnf.androsig.apply.model.LibraryInfo;
import com.pnf.androsig.apply.model.MethodSignature;
import com.pnf.androsig.apply.modules.ApkCallerModule;
import com.pnf.androsig.apply.modules.MethodFinderModule;
import com.pnf.androsig.apply.modules.ReverseMatchingModule;
import com.pnf.androsig.apply.util.DexUtilLocal;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexCodeItem;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

class DatabaseMatcher2
implements IDatabaseMatcher,
ISignatureMetrics,
IMatcherValidation {
    private final ILogger logger = GlobalLog.getLogger(DatabaseMatcher2.class);
    private DatabaseMatcherParameters params;
    private DatabaseReference ref;
    private Set<Integer> ignoredClasses = new HashSet<Integer>();
    private Set<Integer> whiteListClasses = new HashSet<Integer>();
    private ContextMatches contextMatches = new ContextMatches();
    private FileMatches fileMatches = new FileMatches(this.contextMatches);
    private Map<String, List<Integer>> dupClasses = new HashMap<String, List<Integer>>();
    private Map<Integer, List<Integer>> dupMethods = new HashMap<Integer, List<Integer>>();
    private Map<Integer, Double> instruCount = new HashMap<Integer, Double>();
    private List<IAndrosigModule> modules = new ArrayList<IAndrosigModule>();
    private Boolean internalUse = null;

    public DatabaseMatcher2(DatabaseMatcherParameters params, DatabaseReference ref) {
        this.params = params;
        this.ref = ref;
        this.modules.add(new MethodFinderModule(this.contextMatches, this.fileMatches, ref, params, this.modules));
        if (params.useCallerList) {
            this.modules.add(new ApkCallerModule(this.contextMatches, this.fileMatches, ref));
        }
        if (params.useReverseMatching) {
            this.modules.add(new ReverseMatchingModule(this.contextMatches, this.fileMatches, ref, params, this.modules));
        }
    }

    @Override
    public void storeMatchedClassesAndMethods(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        for (IAndrosigModule module : this.modules) {
            module.initNewPass(unit, dexHashCodeList, firstRound);
        }
        List<IDexClass> sortedClasses = DexUtilLocal.getSortedClasses(unit);
        if (sortedClasses == null) {
            return;
        }
        if (firstRound) {
            this.bindUnrenamedClasses(unit, sortedClasses, dexHashCodeList);
        }
        boolean processSecondPass = this.storeFinalCandidates(unit, sortedClasses, dexHashCodeList, firstRound, true);
        if (!firstRound && processSecondPass) {
            this.storeFinalCandidates(unit, sortedClasses, dexHashCodeList, firstRound, false);
        }
        this.applyContextMatch(unit, dexHashCodeList, firstRound, true);
        for (Map.Entry<String, List<Integer>> eClass : this.dupClasses.entrySet()) {
            if (eClass.getValue().size() == 1) continue;
            for (Integer e : eClass.getValue()) {
                this.fileMatches.removeMatchedClass(e);
                for (Integer eMethod : this.dupMethods.get(e)) {
                    this.fileMatches.removeMatchedMethod(eMethod);
                }
            }
        }
        this.dupClasses.clear();
        this.dupMethods.clear();
    }

    private void applyContextMatch(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound, boolean firstPass) {
        int size = 0;
        int oldSize = 0;
        do {
            oldSize = size;
            Set<String> matches = this.contextMatches.keySet();
            size = matches.size();
            HashMap<IDexClass, ContextMatches.CMatch> bindings = new HashMap<IDexClass, ContextMatches.CMatch>();
            HashMap<String, IDexClass> classesMatched = new HashMap<String, IDexClass>();
            for (String string : matches) {
                String newName;
                ContextMatches.CMatch cMatch = this.contextMatches.get(string);
                if (cMatch.processed) continue;
                if (cMatch.name != null) {
                    this.removeWrongMethods(cMatch);
                    cMatch.processed = true;
                    continue;
                }
                IDexClass cl = unit.getClass(string);
                if (cl == null || (newName = this.fileMatches.getMatchedClass(cl)) != null) continue;
                String candidateNewName = null;
                List<ContextMatches.Match> candidateNewNames = cMatch.matches;
                if (candidateNewNames.size() != 1) {
                    ContextMatches.Match bestCandidate = null;
                    boolean eq = false;
                    for (ContextMatches.Match cand : candidateNewNames) {
                        if (cand.newName.equals(cl.getSignature(true))) {
                            bestCandidate = cand;
                            eq = false;
                            break;
                        }
                        if (bestCandidate == null) {
                            bestCandidate = cand;
                            continue;
                        }
                        if (cand.count > bestCandidate.count) {
                            bestCandidate = cand;
                            eq = false;
                            continue;
                        }
                        if (cand.count != bestCandidate.count) continue;
                        eq = true;
                    }
                    if (eq) continue;
                    candidateNewName = bestCandidate.newName;
                } else {
                    candidateNewName = candidateNewNames.get((int)0).newName;
                }
                if (this.fileMatches.containsMatchedClassValue(candidateNewName)) continue;
                IDexClass cl2 = (IDexClass)classesMatched.get(candidateNewName);
                if (cl2 == null) {
                    bindings.put(cl, cMatch);
                    classesMatched.put(candidateNewName, cl);
                    cMatch.name = candidateNewName;
                    continue;
                }
                ContextMatches.CMatch m = (ContextMatches.CMatch)bindings.remove(cl2);
                if (m == null) continue;
                m.processed = false;
                m.name = null;
            }
            for (Map.Entry entry : bindings.entrySet()) {
                IDexClass cl = (IDexClass)entry.getKey();
                ContextMatches.CMatch cMatch = (ContextMatches.CMatch)entry.getValue();
                MatchingSearch.InnerMatch innerMatch = this.getClass(unit, cl, dexHashCodeList, firstRound, false, cMatch.name);
                if (innerMatch != null) {
                    this.storeFinalCandidate(unit, cl, innerMatch, firstRound, false);
                    cMatch.processed = true;
                } else if (!firstRound) {
                    this.fileMatches.addMatchedClass(cl, cMatch.name, null, null);
                    cMatch.processed = true;
                }
                if (cMatch.processed && cMatch.matches.size() > 1) {
                    this.removeWrongMethods(cMatch);
                }
                if (cMatch.processed) continue;
                cMatch.name = null;
            }
        } while (oldSize != size);
        for (Map.Entry<Integer, String> entry : this.contextMatches.methodsEntrySet()) {
            IDexMethod m;
            String newName;
            if (!this.contextMatches.isValid(entry.getValue()) || (newName = this.fileMatches.getMatchedMethod(m = unit.getMethod(entry.getKey().intValue()))) == null || newName.equals(entry.getValue())) continue;
            this.logger.warn("Conflict for method: Method %s was already renamed to %s. Can not rename to %s", new Object[]{m.getName(false), newName, entry.getValue()});
            this.contextMatches.setInvalidMethod(entry.getKey());
        }
    }

    private void removeWrongMethods(ContextMatches.CMatch cMatch) {
        for (ContextMatches.Match match : cMatch.matches) {
            if (match.newName.equals(cMatch.name)) continue;
            for (Integer wrongMethod : match.methodIndexes) {
                this.fileMatches.removeMatchedMethod(wrongMethod);
            }
        }
    }

    private void bindUnrenamedClasses(IDexUnit dex, List<IDexClass> classes, DexHashcodeList dexHashCodeList) {
        for (IDexClass eClass : classes) {
            List methods;
            String originalSignature = eClass.getSignature(true);
            List<String> files = this.ref.getFilesContainingClass(originalSignature);
            if (files == null || (methods = eClass.getMethods()) == null || methods.size() == 0) continue;
            MatchingSearch fileCandidates = new MatchingSearch(dex, dexHashCodeList, this.ref, this.params, this.fileMatches, this.modules, true, true);
            int innerLevel = DexUtilLocal.getInnerClassLevel(originalSignature);
            fileCandidates.processClass(this, eClass, methods, innerLevel, files);
            this.filterVersions(fileCandidates);
            ArrayList<MatchingSearch.InnerMatch> candidates = new ArrayList<MatchingSearch.InnerMatch>();
            for (Map.Entry<String, Map<String, MatchingSearch.InnerMatch>> entry : fileCandidates.entrySet()) {
                for (Map.Entry<String, MatchingSearch.InnerMatch> entry2 : entry.getValue().entrySet()) {
                    if (!entry2.getKey().equals(originalSignature)) continue;
                    candidates.add(entry2.getValue());
                }
            }
            if (candidates.size() == 1) {
                MatchingSearch.InnerMatch innerMatch = (MatchingSearch.InnerMatch)candidates.get(0);
                this.fileMatches.addMatchedClass(eClass, innerMatch.getCname(), innerMatch.getFiles(), innerMatch.getUsedMethodSignatures());
                continue;
            }
            fileCandidates = new MatchingSearch(dex, dexHashCodeList, this.ref, this.params, this.fileMatches, this.modules, false, true);
            innerLevel = DexUtilLocal.getInnerClassLevel(originalSignature);
            fileCandidates.processClass(this, eClass, methods, innerLevel, files);
            this.filterVersions(fileCandidates);
            candidates = new ArrayList();
        }
    }

    private boolean storeFinalCandidates(IDexUnit unit, List<? extends IDexClass> classes, DexHashcodeList dexHashCodeList, boolean firstRound, boolean firstPass) {
        boolean found = false;
        for (IDexClass iDexClass : classes) {
            MatchingSearch.InnerMatch innerMatch;
            if (this.fileMatches.containsMatchedClass(iDexClass) || (innerMatch = this.getClass(unit, iDexClass, dexHashCodeList, firstRound, firstPass, null)) == null || !this.storeFinalCandidate(unit, iDexClass, innerMatch, firstRound)) continue;
            found = true;
        }
        return found;
    }

    protected MatchingSearch.InnerMatch getClass(IDexUnit dex, IDexClass eClass, DexHashcodeList dexHashCodeList, boolean firstRound, boolean unique, String hintName) {
        List methods = eClass.getMethods();
        if (hintName == null && (methods == null || methods.size() == 0)) {
            return null;
        }
        MatchingSearch matching = new MatchingSearch(dex, dexHashCodeList, this.ref, this.params, this.fileMatches, this.modules, firstRound, unique);
        String originalSignature = eClass.getSignature(true);
        int innerLevel = DexUtilLocal.getInnerClassLevel(originalSignature);
        boolean parentClassFound = false;
        if (DexUtilLocal.isInnerClass(originalSignature)) {
            String name;
            IDexClass parentClass = DexUtilLocal.getParentClass(dex, originalSignature);
            String string = name = parentClass == null ? null : this.fileMatches.getMatchedClass(parentClass);
            if (name != null) {
                parentClassFound = true;
                DatabaseReferenceFile file = this.fileMatches.getFileFromClass(dex, parentClass);
                if (file != null) {
                    String innerClass = hintName == null ? name.substring(0, name.length() - 1) + "$" : hintName;
                    List<MethodSignature> innerSignatures = this.ref.getSignaturesForClassname(file, innerClass, false);
                    HierarchyMatcher hierarchyMatcher = new HierarchyMatcher(eClass);
                    Set set2 = innerSignatures.stream().map(s -> s.getCname()).collect(Collectors.toSet());
                    set2 = set2.stream().filter(cname -> this.isInnerClassCandidate(dex, file, hierarchy, (String)cname, eClass, innerLevel)).collect(Collectors.toSet());
                    if (hintName == null && set2.size() == 1) {
                        this.contextMatches.saveClassMatch(originalSignature, (String)set2.iterator().next(), name);
                        return null;
                    }
                    innerSignatures = innerSignatures.stream().filter(inner -> this.isInnerClassCandidate(dex, file, hierarchy, inner.getCname(), eClass, innerLevel)).collect(Collectors.toList());
                    matching.processInnerClass(file, eClass, methods, innerClass, innerLevel, innerSignatures);
                    this.ignoredClasses.remove(eClass.getIndex());
                    if (matching.isEmpty() && hintName != null) {
                        return new MatchingSearch.InnerMatch(hintName, file.file);
                    }
                }
            } else if (hintName == null && (firstRound || unique)) {
                return null;
            }
        }
        if (hintName == null && this.ignoredClasses.contains(eClass.getIndex())) {
            return null;
        }
        boolean hasCandidates = true;
        if (!matching.isEmpty() || (hasCandidates = matching.processClass(this, eClass, methods, innerLevel)) || !this.whiteListClasses.contains(eClass.getIndex())) {
            // empty if block
        }
        if (hintName != null) {
            matching.filterClassName(hintName);
        }
        if (matching.isEmpty()) {
            return null;
        }
        this.filterVersions(matching);
        if (unique) {
            this.filterHierarchy(matching, eClass);
        }
        this.findSmallMethods(matching, originalSignature, methods, unique);
        List<MatchingSearch.InnerMatch> bestCandidates = this.filterMaxMethodsMatch(dex, matching);
        MatchingSearch.InnerMatch bestCandidate = null;
        if (bestCandidates.isEmpty()) {
            return null;
        }
        if (bestCandidates.size() != 1) {
            TreeMap<Integer, HashSet<MatchingSearch.InnerMatch>> diffMatch = new TreeMap<Integer, HashSet<MatchingSearch.InnerMatch>>();
            for (MatchingSearch.InnerMatch innerMatch : bestCandidates) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                List<MethodSignature> allTight = this.ref.getSignaturesForClassname(innerMatch.getFirstRefFile(), innerMatch.getCname(), true);
                Iterator<MethodSignature> iterator = allTight.iterator();
                while (iterator.hasNext()) {
                    MethodSignature tight = iterator.next();
                    String[] versions = tight.getVersions();
                    if (versions == null) {
                        DatabaseReferenceFile.increment(hashMap, "all");
                        continue;
                    }
                    for (String v : versions) {
                        DatabaseReferenceFile.increment(hashMap, v);
                    }
                }
                for (Integer methodCount : hashMap.values()) {
                    int diff = Math.abs(methods.size() - methodCount);
                    HashSet<MatchingSearch.InnerMatch> newBestCandidates = (HashSet<MatchingSearch.InnerMatch>)diffMatch.get(diff);
                    if (newBestCandidates == null) {
                        newBestCandidates = new HashSet<MatchingSearch.InnerMatch>();
                        diffMatch.put(diff, newBestCandidates);
                    }
                    newBestCandidates.add(innerMatch);
                }
            }
            if (!diffMatch.isEmpty()) {
                bestCandidates = new ArrayList<MatchingSearch.InnerMatch>((Collection)diffMatch.get(diffMatch.firstKey()));
            }
        }
        if (bestCandidates.size() == 1) {
            bestCandidate = bestCandidates.get(0);
        } else {
            String className;
            if (!firstRound && (className = DatabaseMatcher2.getUniqueName(bestCandidates)) != null) {
                DatabaseReferenceFile bestFile = this.fileMatches.getMatchedClassFile(dex, eClass, className, this.ref);
                if (bestFile != null) {
                    block4: for (MatchingSearch.InnerMatch innerMatch : bestCandidates) {
                        for (String f : innerMatch.getFiles()) {
                            if (!f.equals(bestFile.file)) continue;
                            bestCandidate = innerMatch;
                            break block4;
                        }
                    }
                }
                if (bestCandidate == null) {
                    this.whiteListClasses.add(eClass.getIndex());
                    ArrayList<MatchingSearch.InnerMatch> arrayList = new ArrayList<MatchingSearch.InnerMatch>();
                    for (MatchingSearch.InnerMatch cand : bestCandidates) {
                        if (hintName == null && this.f(dex, eClass, new ArrayList<Integer>(cand.getMatchedMethodIndexes())) != null) continue;
                        arrayList.add(cand);
                    }
                    if (arrayList.size() == 1) {
                        bestCandidate = (MatchingSearch.InnerMatch)arrayList.iterator().next();
                    } else if (hintName != null || !arrayList.isEmpty()) {
                        if (!unique) {
                            bestCandidate = MatchingSearch.InnerMatch.mergeCandidates(dex, arrayList, true);
                        } else {
                            boolean bl;
                            boolean bl2 = false;
                            for (MatchingSearch.InnerMatch cand : arrayList) {
                                if (!this.validateOneMatch(matching, dex, cand, originalSignature, parentClassFound)) continue;
                                bl = true;
                                break;
                            }
                            if (bl && hintName == null) {
                                this.contextMatches.saveClassMatchUnkownFile(originalSignature, className);
                            }
                        }
                    }
                }
            }
            if (bestCandidate == null) {
                return null;
            }
        }
        if (hintName == null && !this.validateOneMatch(matching, dex, bestCandidate, originalSignature, parentClassFound)) {
            return null;
        }
        bestCandidate.validateMethods();
        return bestCandidate;
    }

    private boolean validateOneMatch(MatchingSearch matching, IDexUnit dex, MatchingSearch.InnerMatch bestCandidate, String originalSignature, boolean parentClassFound) {
        if (bestCandidate.oneMatch) {
            if (DexUtilLocal.isInnerClass(originalSignature)) {
                return parentClassFound;
            }
            if (bestCandidate.methodsSize() > this.params.matchedMethodsOneMatch) {
                return true;
            }
            int complexSignatureFound = 0;
            for (Map.Entry<Integer, MethodSignature> entry : bestCandidate.entrySet()) {
                if (entry.getValue().getPrototype().isEmpty()) continue;
                if (matching.isComplexSignature(entry.getValue().getPrototype())) {
                    ++complexSignatureFound;
                    continue;
                }
                String methodName = dex.getMethod(entry.getKey().intValue()).getName(true);
                if (!entry.getValue().getMname().equals(methodName) || DexUtilLocal.isObjectInheritedMethod(entry.getValue().getMname(), entry.getValue().getPrototype())) continue;
                ++complexSignatureFound;
            }
            return complexSignatureFound > 1;
        }
        return true;
    }

    private void filterHierarchy(MatchingSearch fileCandidates, IDexClass eClass) {
        HierarchyMatcher hierarchy = new HierarchyMatcher(eClass);
        for (Map.Entry<String, Map<String, MatchingSearch.InnerMatch>> entry : fileCandidates.entrySet()) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, MatchingSearch.InnerMatch> cand : entry.getValue().entrySet()) {
                if (hierarchy.isCompatible(this.ref, cand.getValue().getFirstRefFile(), cand.getValue().getCname())) continue;
                toRemove.add(cand.getKey());
            }
            for (String remove : toRemove) {
                entry.getValue().remove(remove);
            }
        }
    }

    private void filterVersions(MatchingSearch fileCandidates) {
        for (Map.Entry<String, Map<String, MatchingSearch.InnerMatch>> entry : fileCandidates.entrySet()) {
            for (MatchingSearch.InnerMatch cand : entry.getValue().values()) {
                cand.validateVersions();
                if (cand.methodsSize() != 1) continue;
                cand.oneMatch = true;
            }
        }
    }

    private void findSmallMethods(MatchingSearch fileCandidates, String originalSignature, List<? extends IDexMethod> methods, boolean firstPass) {
        for (Map.Entry<String, Map<String, MatchingSearch.InnerMatch>> entry : fileCandidates.entrySet()) {
            for (MatchingSearch.InnerMatch cand : entry.getValue().values()) {
                if (cand.oneMatch || DexUtilLocal.isInnerClass(originalSignature)) {
                    boolean signatureUsed = false;
                    for (String string : cand.getFiles()) {
                        if (!this.fileMatches.isSignatureFileUsed(string)) continue;
                        signatureUsed = true;
                        break;
                    }
                    if (!signatureUsed) continue;
                }
                List<MethodSignature> sigs = null;
                for (IDexMethod iDexMethod : methods) {
                    if (cand.containsMethod(iDexMethod.getIndex())) continue;
                    MethodSignature strArray = fileCandidates.findMethodMatch(cand.getFirstRefFile(), cand.getCname(), cand.getUsedMethodSignatures(), iDexMethod, true);
                    if (strArray != null) {
                        cand.addMethod(iDexMethod, strArray);
                        continue;
                    }
                    if (firstPass || cand.oneMatch) continue;
                    if (sigs == null) {
                        sigs = this.ref.getSignaturesForClassname(cand.getFirstRefFile(), cand.getCname(), true);
                    }
                    if ((strArray = fileCandidates.findMethodName(sigs, cand.getCname(), new ArrayList<MethodSignature>(), iDexMethod)) == null || strArray.getMname() == null || strArray.getPrototype() == null) continue;
                    cand.addMethod(iDexMethod, strArray);
                }
            }
        }
    }

    private boolean isInnerClassCandidate(IDexUnit dex, DatabaseReferenceFile file, HierarchyMatcher hierarchy, String classname, IDexClass eClass, int innerLevel) {
        IDexClass innerCl = dex.getClass(classname);
        if (innerCl != null && this.fileMatches.containsMatchedClass(innerCl)) {
            return false;
        }
        if (DexUtilLocal.isAnonymous(eClass) != DexUtilLocal.isAnonymous(classname)) {
            return false;
        }
        if (innerLevel != DexUtilLocal.getInnerClassLevel(classname)) {
            return false;
        }
        return hierarchy.isCompatible(this.ref, file, classname);
    }

    private List<MatchingSearch.InnerMatch> filterMaxMethodsMatch(IDexUnit dex, MatchingSearch fileCandidates) {
        Integer higherOccurence = 0;
        ArrayList<MatchingSearch.InnerMatch> bestCandidates = new ArrayList<MatchingSearch.InnerMatch>();
        Integer higherOccurenceInternal = 0;
        ArrayList<MatchingSearch.InnerMatch> bestCandidatesInternal = new ArrayList<MatchingSearch.InnerMatch>();
        HashMap<String, ArrayList<MatchingSearch.InnerMatch>> candidatesPerName = new HashMap<String, ArrayList<MatchingSearch.InnerMatch>>();
        for (Map.Entry<String, Map<String, MatchingSearch.InnerMatch>> cand : fileCandidates.entrySet()) {
            for (Map.Entry<String, MatchingSearch.InnerMatch> entry : cand.getValue().entrySet()) {
                String classname = entry.getKey();
                MatchingSearch.InnerMatch candClass = entry.getValue();
                ArrayList<MatchingSearch.InnerMatch> value = (ArrayList<MatchingSearch.InnerMatch>)candidatesPerName.get(classname);
                if (value == null) {
                    value = new ArrayList<MatchingSearch.InnerMatch>();
                    candidatesPerName.put(classname, value);
                }
                value.add(candClass);
                if (classname.startsWith("Landroid/support/") && classname.contains("/internal/")) {
                    if (candClass.methodsSize() > higherOccurenceInternal) {
                        higherOccurenceInternal = candClass.methodsSize();
                        bestCandidatesInternal.clear();
                        bestCandidatesInternal.add(candClass);
                        continue;
                    }
                    if (candClass.methodsSize() != higherOccurenceInternal.intValue()) continue;
                    bestCandidatesInternal.add(candClass);
                    continue;
                }
                if (candClass.methodsSize() > higherOccurence) {
                    higherOccurence = candClass.methodsSize();
                    bestCandidates.clear();
                    bestCandidates.add(candClass);
                    continue;
                }
                if (candClass.methodsSize() != higherOccurence.intValue()) continue;
                bestCandidates.add(candClass);
            }
        }
        if (!bestCandidatesInternal.isEmpty()) {
            String shortName = DatabaseMatcher2.getUniqueName(bestCandidates);
            String internalName = DatabaseMatcher2.getUniqueName(bestCandidatesInternal);
            if (shortName != null && internalName != null && shortName.equals(internalName.replace("/internal/", "/"))) {
                if (this.internalUse == null) {
                    this.internalUse = higherOccurenceInternal > higherOccurence;
                }
                if (this.internalUse.booleanValue()) {
                    ((List)candidatesPerName.get(internalName)).addAll((Collection)candidatesPerName.get(shortName));
                    bestCandidates = bestCandidatesInternal;
                } else {
                    ((List)candidatesPerName.get(shortName)).addAll((Collection)candidatesPerName.get(internalName));
                }
            } else if (higherOccurenceInternal > higherOccurence) {
                bestCandidates = bestCandidatesInternal;
            }
        }
        if (bestCandidates.size() == 1) {
            MatchingSearch.InnerMatch first = (MatchingSearch.InnerMatch)bestCandidates.get(0);
            List altCandidates = (List)candidatesPerName.get(first.getCname());
            if (altCandidates.size() <= 1) {
                return bestCandidates;
            }
            altCandidates.remove(first);
            altCandidates.add(0, first);
            MatchingSearch.InnerMatch newCand = MatchingSearch.InnerMatch.mergeCandidates(dex, altCandidates, false);
            bestCandidates.clear();
            bestCandidates.add(newCand);
            return bestCandidates;
        }
        return bestCandidates;
    }

    private static String getUniqueName(List<MatchingSearch.InnerMatch> bestCandidates) {
        String className = null;
        if (!bestCandidates.isEmpty()) {
            for (MatchingSearch.InnerMatch cand : bestCandidates) {
                if (className == null) {
                    className = cand.getCname();
                    continue;
                }
                if (className.equals(cand.getCname())) continue;
                className = null;
                break;
            }
        }
        return className;
    }

    protected boolean storeFinalCandidate(IDexUnit unit, IDexClass eClass, MatchingSearch.InnerMatch innerMatch, boolean firstRound) {
        return this.storeFinalCandidate(unit, eClass, innerMatch, firstRound, true);
    }

    /*
     * WARNING - void declaration
     */
    private boolean storeFinalCandidate(IDexUnit unit, IDexClass eClass, MatchingSearch.InnerMatch innerMatch, boolean firstRound, boolean checkCoverage) {
        if (this.fileMatches.containsMatchedClassValue(innerMatch.getCname())) {
            return false;
        }
        String originalSignature = eClass.getSignature(true);
        if (DexUtilLocal.getInnerClassLevel(innerMatch.getCname()) != DexUtilLocal.getInnerClassLevel(originalSignature)) {
            return false;
        }
        if (DexUtilLocal.isInnerClass(innerMatch.getCname())) {
            String parentMatchSignature;
            String oldClass = originalSignature;
            String newClass = innerMatch.getCname();
            if (!DexUtilLocal.isInnerClass(oldClass)) {
                return false;
            }
            String parentSignature = DexUtilLocal.getParentSignature(oldClass);
            if (!parentSignature.equals(parentMatchSignature = DexUtilLocal.getParentSignature(newClass))) {
                if (firstRound) {
                    return false;
                }
                String string = oldClass;
                String newParentClass = newClass;
                while (DexUtilLocal.isInnerClass(newParentClass)) {
                    void var11_13;
                    String string2 = DexUtilLocal.getParentSignature((String)var11_13);
                    newParentClass = DexUtilLocal.getParentSignature(newParentClass);
                    IDexClass oldParentClassObj = unit.getClass(string2);
                    if (oldParentClassObj == null) continue;
                    IDexClass newParentClassObj = unit.getClass(newParentClass);
                    String oldParentMatch = this.fileMatches.getMatchedClass(oldParentClassObj);
                    if (!(oldParentMatch != null ? !oldParentMatch.equals(newParentClass) : newParentClassObj != null && this.fileMatches.containsMatchedClass(newParentClassObj))) continue;
                    return false;
                }
            }
        }
        if (checkCoverage && innerMatch.methodsSize() == 0) {
            return false;
        }
        ArrayList<Integer> temp1 = new ArrayList<Integer>(innerMatch.getMatchedMethodIndexes());
        if (!checkCoverage || temp1.size() != 0) {
            String errorMessage;
            String string = errorMessage = checkCoverage ? this.f(unit, eClass, temp1) : null;
            if (errorMessage == null) {
                List<Integer> tempArrayList;
                this.logger.debug("Found match class: %s from file %s", new Object[]{innerMatch.getCname(), Strings.join((String)",", innerMatch.getFiles())});
                this.fileMatches.addMatchedClass(eClass, innerMatch.getCname(), innerMatch.getFiles(), innerMatch.getUsedMethodSignatures());
                if (DexUtilLocal.isInnerClass(innerMatch.getCname())) {
                    this.contextMatches.saveClassMatch(originalSignature, innerMatch.getCname(), innerMatch.getCname());
                }
                if ((tempArrayList = this.dupClasses.get(innerMatch.getCname())) != null) {
                    tempArrayList.add(eClass.getIndex());
                    this.dupClasses.put(innerMatch.getCname(), tempArrayList);
                } else {
                    ArrayList<Integer> temp2 = new ArrayList<Integer>();
                    temp2.add(eClass.getIndex());
                    this.dupClasses.put(innerMatch.getCname(), temp2);
                }
                this.dupMethods.put(eClass.getIndex(), temp1);
                for (Map.Entry entry : innerMatch.entrySet()) {
                    Integer mIndex = (Integer)entry.getKey();
                    MethodSignature strArray = (MethodSignature)entry.getValue();
                    String methodName = strArray.getMname();
                    if (Strings.isBlank((CharSequence)methodName) || innerMatch.doNotRenameIndexes.contains(mIndex)) continue;
                    this.fileMatches.addMatchedMethod(unit, mIndex, strArray);
                }
                return true;
            }
            this.logger.info("Can not validate candidate %s for %s: %s", new Object[]{innerMatch.getCname(), originalSignature, errorMessage});
            Iterator iterator = temp1.iterator();
            while (iterator.hasNext()) {
                int e = (Integer)iterator.next();
                this.fileMatches.removeMatchedMethod(e);
            }
        }
        return false;
    }

    @Override
    public String f(IDexUnit unit, IDexClass eClass, List<Integer> matchedMethods) {
        String name;
        double totalInstrus = 0.0;
        double matchedInstrus = 0.0;
        List methods = eClass.getMethods();
        Double c = this.instruCount.get(eClass.getIndex());
        if (c != null) {
            totalInstrus = c;
            for (int e : matchedMethods) {
                IDexMethod m = unit.getMethod(e);
                List insns = m.getInstructions();
                matchedInstrus += (double)(insns == null ? 0 : insns.size());
            }
        } else {
            if (methods == null || methods.size() == 0) {
                return "No method";
            }
            for (IDexMethod m : methods) {
                IDexCodeItem ci;
                IDexMethodData md;
                if (!m.isInternal() || (md = m.getData()) == null || (ci = md.getCodeItem()) == null) continue;
                int count = ci.getInstructions().size();
                if (matchedMethods.contains(m.getIndex())) {
                    matchedInstrus += (double)count;
                }
                totalInstrus += (double)count;
            }
            this.instruCount.put(eClass.getIndex(), totalInstrus);
        }
        if (methods.size() == 1 && !DexUtilLocal.isInnerClass(eClass.getSignature(true)) && ((name = ((IDexMethod)methods.get(0)).getName(true)).equals("<init>") || name.equals("<clinit>"))) {
            return matchedInstrus > (double)this.params.standaloneConstructorMethodSizeBar ? null : "Only simple constructor match found";
        }
        double cov = matchedInstrus / totalInstrus;
        if (cov <= this.params.matchedInstusPercentageBar) {
            return Strings.f((String)"User threshold not reached: %.2f", (Object[])new Object[]{cov});
        }
        return null;
    }

    @Override
    public Map<Integer, String> postProcessRenameMethods(IDexUnit unit, DexHashcodeList dexHashCodeList, boolean firstRound) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (IAndrosigModule module : this.modules) {
            result.putAll(module.postProcessRenameMethods(unit, dexHashCodeList, firstRound));
        }
        return result;
    }

    @Override
    public Map<Integer, String> postProcessRenameClasses(IDexUnit dex, DexHashcodeList dexHashCodeList, boolean firstRound) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (IAndrosigModule module : this.modules) {
            result.putAll(module.postProcessRenameClasses(dex, dexHashCodeList, firstRound));
        }
        return result;
    }

    @Override
    public Map<Integer, String> getMatchedClasses() {
        return this.fileMatches.getMatchedClasses();
    }

    @Override
    public Map<Integer, String> getMatchedMethods() {
        return this.fileMatches.getMatchedMethods();
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getApkCallerLists() {
        return new HashMap<Integer, Map<Integer, Integer>>();
    }

    @Override
    public DatabaseMatcherParameters getParameters() {
        return this.params;
    }

    @Override
    public ISignatureMetrics getSignatureMetrics() {
        return this;
    }

    @Override
    public int getAllSignatureCount() {
        int sigCount = 0;
        for (Map.Entry<String, ISignatureFile> sig : this.ref.getLoadedSignatureFiles().entrySet()) {
            if (!this.fileMatches.isSignatureFileUsed(sig.getKey())) continue;
            sigCount += sig.getValue().getAllSignatureCount();
        }
        return sigCount;
    }

    @Override
    public int getAllUsedSignatureFileCount() {
        return this.fileMatches.getSignatureFileUsed().size();
    }

    @Override
    public Map<String, LibraryInfo> getAllLibraryInfos() {
        HashMap<String, LibraryInfo> libs = new HashMap<String, LibraryInfo>();
        block0: for (Map.Entry<Integer, String> entry : this.fileMatches.entrySetMatchedClasses()) {
            DatabaseReferenceFile file = this.fileMatches.getFileFromClassId(entry.getKey());
            if (file == null) {
                for (String used : this.fileMatches.getSignatureFileUsed()) {
                    LibraryInfo res = this.ref.getLibraryInfos(used, entry.getValue());
                    if (res == null) continue;
                    libs.put(entry.getValue(), res);
                    continue block0;
                }
                continue;
            }
            LibraryInfo res = this.ref.getLibraryInfos(file.file, null);
            if (file.getMergedVersions() != null && res.getVersions() == null) {
                res.setVersions(file.getReducedVersions());
            }
            libs.put(entry.getValue(), res);
        }
        return libs;
    }
}

