/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import com.pnf.plugin.pdf.filter.PDFObject;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JBIG2Filter {
    private static final ILogger LOG = GlobalLog.getLogger(JBIG2Filter.class);

    public void decode(InputStream compressedData, OutputStream result, PDFObject dictionary, PDFObject params) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JBIG2");
        if (!readers.hasNext()) {
            LOG.error("Can't find an ImageIO plugin to decode the JBIG2 encoded datastream.", new Object[0]);
            return;
        }
        ImageReader reader = readers.next();
        Integer bits = dictionary.getDictRef("BitsPerComponent").getIntValue();
        PDFObject st = null;
        if (params != null) {
            st = params.getDictRef("JBIG2Globals");
        }
        if (st != null) {
            compressedData = new SequenceInputStream(st.getUnfilteredStream(), compressedData);
        }
        ImageInputStream iis = ImageIO.createImageInputStream(compressedData);
        reader.setInput(iis);
        BufferedImage bi = reader.read(0, reader.getDefaultReadParam());
        iis.close();
        reader.dispose();
        if (bi != null) {
            DataBuffer dBuf;
            if (bi.getColorModel().getPixelSize() != bits.intValue()) {
                if (bits != 1) {
                    LOG.error("Do not know how to deal with JBIG2 with more than 1 bit", new Object[0]);
                    return;
                }
                BufferedImage packedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 12);
                Graphics graphics = packedImage.getGraphics();
                graphics.drawImage(bi, 0, 0, null);
                graphics.dispose();
                bi = packedImage;
            }
            if ((dBuf = bi.getData().getDataBuffer()).getDataType() == 0) {
                result.write(((DataBufferByte)dBuf).getData());
            } else {
                LOG.error("Image data buffer not of type byte but type " + dBuf.getDataType(), new Object[0]);
            }
        } else {
            LOG.error("Something went wrong when decoding the JBIG2 encoded datastream.", new Object[0]);
        }
    }
}

