/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.pattern;

import com.pnf.plugin.pdf.filter.PDFObject;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.pattern.PDFPattern;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;

public class PatternType1
extends PDFPattern {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILE_CONSTANT = 1;
    public static final int TILE_NODISTORT = 2;
    public static final int TILE_FASTER = 3;
    private HashMap<String, PDFObject> resources;
    private int paintType;
    private int tilingType;
    private Rectangle2D bbox;
    private int xStep;
    private int yStep;

    public PatternType1() {
        super(1);
    }

    public HashMap<String, PDFObject> getResources() {
        return this.resources;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public Rectangle2D getBBox() {
        return this.bbox;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    class Type1PaintContext
    implements PaintContext {
        private ColorModel colorModel;
        private Rectangle2D bbox;
        private float xstep;
        private float ystep;
        private Raster data;

        Type1PaintContext(ColorModel colorModel, Rectangle2D bbox, float xstep, float ystep, Raster data) {
            this.colorModel = colorModel;
            this.bbox = bbox;
            this.xstep = xstep;
            this.ystep = ystep;
            this.data = data;
        }

        @Override
        public void dispose() {
            this.colorModel = null;
            this.bbox = null;
            this.data = null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            ColorSpace cs = this.getColorModel().getColorSpace();
            int numComponents = cs.getNumComponents();
            int[] imgData = new int[w * h * (numComponents + 1)];
            int useXStep = (int)Math.ceil(Math.abs(this.xstep));
            int useYStep = (int)Math.ceil(Math.abs(this.ystep));
            int[] emptyPixel = new int[numComponents + 1];
            int[] usePixel = new int[numComponents + 1];
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    int xloc = x + i - (int)Math.ceil(this.bbox.getX());
                    int yloc = y + j - (int)Math.ceil(this.bbox.getY());
                    yloc %= useYStep;
                    if ((xloc %= useXStep) < 0) {
                        xloc = useXStep + xloc;
                    }
                    if (yloc < 0) {
                        yloc = useYStep + yloc;
                    }
                    int[] pixel = emptyPixel;
                    if (xloc < this.data.getWidth() && yloc < this.data.getHeight()) {
                        pixel = this.data.getPixel(xloc, yloc, usePixel);
                    }
                    int base = (j * w + i) * (numComponents + 1);
                    for (int c = 0; c < pixel.length; ++c) {
                        imgData[base + c] = pixel[c];
                    }
                }
            }
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            raster.setPixels(0, 0, w, h, imgData);
            Raster child = raster.createTranslatedChild(x, y);
            return child;
        }
    }

    class TilingPatternPaint
    extends PDFPaint {
        private PatternType1 pattern;

        public TilingPatternPaint(Paint paint, PatternType1 pattern) {
            super(paint);
            this.pattern = pattern;
        }
    }
}

