/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.pnf.plugin.pdf.filter.PDFObject;
import com.pnf.plugin.pdf.parser.PdfFilterException;
import com.sun.pdfview.decode.Predictor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FlateDecode {
    public static ByteBuffer decode(PDFObject dict, ByteBuffer buf, PDFObject params) throws PdfFilterException {
        Inflater inf = new Inflater(false);
        int bufSize = buf.remaining();
        byte[] data = new byte[bufSize];
        buf.get(data);
        inf.setInput(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] decomp = new byte[bufSize];
        boolean loc = false;
        int read = 0;
        try {
            while (!inf.finished()) {
                read = inf.inflate(decomp);
                if (read <= 0) {
                    if (inf.needsDictionary()) {
                        throw new PdfFilterException("Don't know how to ask for a dictionary in FlateDecode", baos, bufSize - inf.getRemaining());
                    }
                    return ByteBuffer.allocate(0);
                }
                baos.write(decomp, 0, read);
            }
        }
        catch (DataFormatException dfe) {
            throw new PdfFilterException(dfe, baos, bufSize - inf.getRemaining());
        }
        ByteBuffer outBytes = ByteBuffer.wrap(baos.toByteArray());
        try {
            Predictor predictor;
            if (params != null && params.getDictionary().containsKey("Predictor") && (predictor = Predictor.getPredictor(params)) != null) {
                outBytes = predictor.unpredict(outBytes);
            }
        }
        catch (IOException dfe) {
            throw new PdfFilterException(dfe, baos, bufSize - inf.getRemaining());
        }
        return outBytes;
    }
}

