/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.unit;

import com.pnf.plugin.pdf.document.TreePdfDocument;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.AbstractTransientUnitRepresentation;
import com.pnfsoftware.jeb.core.output.AbstractUnitRepresentation;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterAdapter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.output.text.impl.HexDumpDocument;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProvider;
import com.pnfsoftware.jeb.core.units.impl.AbstractUnitProvider;
import com.pnfsoftware.jeb.core.units.impl.BinaryWrapperUnit;
import com.pnfsoftware.jeb.core.units.impl.InteractiveWrapperUnit;
import com.pnfsoftware.jeb.core.units.impl.WrapperUnit;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class StreamUnitProvider
extends AbstractUnitProvider {
    @SerId(value=1)
    private PdfStream stream;

    public StreamUnitProvider(String formatType, PdfStream stream) {
        super(formatType, null, null);
        this.stream = stream;
    }

    public IUnitFormatter getFormatter() {
        UnitFormatterAdapter formatter = new UnitFormatterAdapter();
        formatter.addPresentation((IUnitDocumentPresentation)StreamUnitProvider.getDictionaryRepresentation(this.stream), false);
        UnitFormatterUtil.addAllPresentations((IUnitFormatter)formatter, StreamUnitProvider.getEncodedRepresentations(this.stream), (boolean)false);
        return formatter;
    }

    protected static AbstractUnitRepresentation getDictionaryRepresentation(final PdfStream stream) {
        return new AbstractTransientUnitRepresentation("Dictionary", false){

            public IGenericDocument createDocument() {
                return new TreePdfDocument(stream.getDictionary());
            }
        };
    }

    protected static List<IUnitDocumentPresentation> getEncodedRepresentations(PdfStream stream) {
        ArrayList<IUnitDocumentPresentation> representations = new ArrayList<IUnitDocumentPresentation>();
        final List<byte[]> encodedDataList = stream.getEncodedDataList();
        if (!encodedDataList.isEmpty()) {
            if (stream.isEncrypted()) {
                representations.add((IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("Encrypted", false){

                    public IGenericDocument createDocument() {
                        return new HexDumpDocument((IInput)new BytesInput((byte[])encodedDataList.get(0)));
                    }
                });
            }
            IPdfAttribute filters = stream.getAttribute("/Filter");
            for (int i = 0; i < encodedDataList.size() - (stream.isEncrypted() ? 1 : 0); ++i) {
                final byte[] encodedData = encodedDataList.get(i + (stream.isEncrypted() ? 1 : 0));
                representations.add((IUnitDocumentPresentation)new AbstractTransientUnitRepresentation(String.format("Encoded[%d] with %s", i, StreamUnitProvider.getFilterName(filters, i)), false){

                    public IGenericDocument createDocument() {
                        return new HexDumpDocument((IInput)new BytesInput(encodedData));
                    }
                });
            }
        }
        return representations;
    }

    private static String getFilterName(IPdfAttribute filters, int i) {
        IPdfAttribute filter = StreamUnitProvider.getFilter(filters, i);
        return filter.toString().substring(1);
    }

    private static IPdfAttribute getFilter(IPdfAttribute filters, int i) {
        if (filters.getType() == IPdfAttribute.Type.Array) {
            IPdfAttribute filter = ((PdfArray)filters).getAttributes().get(i);
            if (filter.getType() == IPdfAttribute.Type.IndirectReference) {
                return PdfIndirectReference.retrieveDirectObject(filter);
            }
            return filter;
        }
        return filters;
    }

    public static IUnit wrap(IUnit streamUnit, PdfStream stream, String formatType) {
        if (streamUnit == null) {
            return null;
        }
        if (streamUnit instanceof IInteractiveUnit) {
            return new InteractiveWrapperUnit((IInteractiveUnit)streamUnit, (IUnitProvider)new StreamUnitProvider(formatType, stream));
        }
        if (streamUnit instanceof IBinaryUnit) {
            return new BinaryWrapperUnit((IBinaryUnit)streamUnit, (IUnitProvider)new StreamUnitProvider(formatType, stream));
        }
        return new WrapperUnit(streamUnit, (IUnitProvider)new StreamUnitProvider(formatType, stream));
    }
}

